package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementDetailEntity;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementDetailService;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("machinerySettlement")
public class MachinerySettlementBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IMachinerySettlementService service;
	@Autowired
	private IMachinerySettlementDetailService detailService ;
	@Autowired
	private CostanalysisApi costanalysisApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		MachinerySettlementEntity entity = service.selectById(billId);
		CommonResponse<Boolean> response = costanalysisApi.isGenerate(entity.getProjectId(),entity.getSettlementDate());
		if(response != null){
			Boolean isHave = response.getData();
			if(isHave != null && isHave.booleanValue()){
				return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MachinerySettlementEntity entity = service.selectById(billId);
		List<Long> ids = entity.getMachinerySettlementDetailEntities().stream().map(MachinerySettlementDetailEntity::getSourceId).collect(Collectors.toList());
		detailService.changeFlag(ids);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//查询是否生成月度分析报告
		QueryWrapper<MachinerySettlementEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("id",billId);
		MachinerySettlementEntity entity1 = service.getOne(queryWrapper1);
		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity1.getProjectId(), entity1.getSettlementDate());
		if(generate.isSuccess() && generate.getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
