package com.ejianc.business.settlementmanage.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.settlementmanage.bean.*;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 工程分包结算书-主表
 *
 * @author generator
 *
 */
public class SettlementBookVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long contractId; // 合同ID
    private java.lang.String contractName; // 合同名称
    private java.lang.String documentsCode; // 单据编码
    private java.math.BigDecimal reportInamount; // 报审含税金额
    private java.math.BigDecimal reportExamount; // 报审除税金额
    private java.math.BigDecimal initialAmount; // 初审金额
    private java.math.BigDecimal authorizedAmount; // 审定金额
    private java.lang.Long subcontractorsShall; // 分包单位
    private java.lang.String subcontractorsShallName; // 分包单位名称
    private java.lang.String manual; // 编制说明
    private java.lang.String projectSite; // 工程地点
    private java.lang.String remarks; // 备注
    private java.lang.Long agentId; // 经办人
    private java.lang.String agentName; // 经办人姓名
    private java.lang.Long agentDepartment; // 经办人部门
    private Integer isSettlement; // 是否归集状态 0 未归集 1 归集

    private java.lang.String createTimeShow; // 创建时间文本
    private java.lang.String billStateStr; // 单据状态文本
    private String contractType; // 合同类型
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date orderMonth; // 年月
    private java.math.BigDecimal payMnyTax; // 本期扣款金额（含税）
    private java.math.BigDecimal payMny; // 本期扣款金额（除税）
    private java.math.BigDecimal superMnyTax; // 本期节超金额（含税）
    private java.math.BigDecimal superMny; // 本期扣款金额（除税）

    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal sumPayMnyTax; // 中间计量累计扣款金额（含税）
    private java.math.BigDecimal sumPayMny; // 中间计量累计扣款金额（除税）
    private java.math.BigDecimal sumSuperMnyTax; // 中间计量累计节超金额（含税）
    private java.math.BigDecimal sumSuperMny; // 中间计量累计节超金额（除税）
    private List<SettlementBookListDetailVO> settlementBookListDetailEntities = new ArrayList<>(); // 工程分包结算书子表-支出明细-结算甲方供应材料扣款清单

    private List<SettlementBookMaterialDetailVO> settlementBookMaterialDetailEntities = new ArrayList<>(); // 工程分包结算书子表-支出明细-材料节超分析表

    private List<SettlementBookOtherDetailVO> settlementBookOtherDetailEntities = new ArrayList<>(); // 工程分包结算书子表-支出明细-其它

    private List<SettlementBookStatementDetailVO> settlementBookStatementDetailEntities = new ArrayList<>(); // 工程分包结算书子表-收入明细表-工程量清单结算表

    private List<SettlementBookSummaryDetailVO> settlementBookSummaryDetailEntities = new ArrayList<>(); // 工程分包结算书子表-结算汇总表

    private List<SettlementBookBuckleDetailVO> settlementBookBuckleDetailEntities = new ArrayList<>(); // 工程分包结算书子表-支出明细-扣水电费

    private List<SettlementBookVisaScheduleDetailVO> settlementBookVisaScheduleDetailEntities = new ArrayList<>(); // 工程分包结算书子表-收入明细表-工程结算签证明细表

    private List<SettlementBookQuantityBasDeatilVO> settlementBookQuantityBasDeatilEntities = new ArrayList<>(); // 工程分包结算书子表-收入明细表-工程量依据

    public BigDecimal getSumPayMnyTax() {
        return sumPayMnyTax;
    }

    public void setSumPayMnyTax(BigDecimal sumPayMnyTax) {
        this.sumPayMnyTax = sumPayMnyTax;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumSuperMnyTax() {
        return sumSuperMnyTax;
    }

    public void setSumSuperMnyTax(BigDecimal sumSuperMnyTax) {
        this.sumSuperMnyTax = sumSuperMnyTax;
    }

    public BigDecimal getSumSuperMny() {
        return sumSuperMny;
    }

    public void setSumSuperMny(BigDecimal sumSuperMny) {
        this.sumSuperMny = sumSuperMny;
    }

    public BigDecimal getPayMnyTax() {
        return payMnyTax;
    }

    public void setPayMnyTax(BigDecimal payMnyTax) {
        this.payMnyTax = payMnyTax;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getSuperMnyTax() {
        return superMnyTax;
    }

    public void setSuperMnyTax(BigDecimal superMnyTax) {
        this.superMnyTax = superMnyTax;
    }

    public BigDecimal getSuperMny() {
        return superMny;
    }

    public void setSuperMny(BigDecimal superMny) {
        this.superMny = superMny;
    }

    /**
     * 税率
     * @return
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     * @param taxRate
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 合同ID
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同ID
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 单据编码
     */
    public java.lang.String getDocumentsCode() {
        return documentsCode;
    }

    /**
     * 单据编码
     */
    public void setDocumentsCode(java.lang.String documentsCode) {
        this.documentsCode = documentsCode;
    }
    /**
     * 报审含税金额
     */
    public java.math.BigDecimal getReportInamount() {
        return reportInamount;
    }

    /**
     * 报审含税金额
     */
    public void setReportInamount(java.math.BigDecimal reportInamount) {
        this.reportInamount = reportInamount;
    }
    /**
     * 报审除税金额
     */
    public java.math.BigDecimal getReportExamount() {
        return reportExamount;
    }

    /**
     * 报审除税金额
     */
    public void setReportExamount(java.math.BigDecimal reportExamount) {
        this.reportExamount = reportExamount;
    }
    /**
     * 初审金额
     */
    public java.math.BigDecimal getInitialAmount() {
        return initialAmount;
    }

    /**
     * 初审金额
     */
    public void setInitialAmount(java.math.BigDecimal initialAmount) {
        this.initialAmount = initialAmount;
    }
    /**
     * 审定金额
     */
    public java.math.BigDecimal getAuthorizedAmount() {
        return authorizedAmount;
    }

    /**
     * 审定金额
     */
    public void setAuthorizedAmount(java.math.BigDecimal authorizedAmount) {
        this.authorizedAmount = authorizedAmount;
    }
    /**
     * 分包单位
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public java.lang.Long getSubcontractorsShall() {
        return subcontractorsShall;
    }

    /**
     * 分包单位
     */
    @ReferDeserialTransfer
    public void setSubcontractorsShall(java.lang.Long subcontractorsShall) {
        this.subcontractorsShall = subcontractorsShall;
    }

    public String getSubcontractorsShallName() {
        return subcontractorsShallName;
    }

    public void setSubcontractorsShallName(String subcontractorsShallName) {
        this.subcontractorsShallName = subcontractorsShallName;
    }

    /**
     * 编制说明
     */
    public java.lang.String getManual() {
        return manual;
    }

    /**
     * 编制说明
     */
    public void setManual(java.lang.String manual) {
        this.manual = manual;
    }
    /**
     * 工程地点
     */
    public java.lang.String getProjectSite() {
        return projectSite;
    }

    /**
     * 工程地点
     */
    public void setProjectSite(java.lang.String projectSite) {
        this.projectSite = projectSite;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getAgentDepartment() {
        return agentDepartment;
    }

    @ReferDeserialTransfer
    public void setAgentDepartment(Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }

    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Date getOrderMonth() {
        return orderMonth;
    }

    public void setOrderMonth(Date orderMonth) {
        this.orderMonth = orderMonth;
    }

    public List<SettlementBookListDetailVO> getSettlementBookListDetailEntities() {
        return settlementBookListDetailEntities;
    }

    public void setSettlementBookListDetailEntities(List<SettlementBookListDetailVO> settlementBookListDetailEntities) {
        this.settlementBookListDetailEntities = settlementBookListDetailEntities;
    }

    public List<SettlementBookMaterialDetailVO> getSettlementBookMaterialDetailEntities() {
        return settlementBookMaterialDetailEntities;
    }

    public void setSettlementBookMaterialDetailEntities(List<SettlementBookMaterialDetailVO> settlementBookMaterialDetailEntities) {
        this.settlementBookMaterialDetailEntities = settlementBookMaterialDetailEntities;
    }

    public List<SettlementBookOtherDetailVO> getSettlementBookOtherDetailEntities() {
        return settlementBookOtherDetailEntities;
    }

    public void setSettlementBookOtherDetailEntities(List<SettlementBookOtherDetailVO> settlementBookOtherDetailEntities) {
        this.settlementBookOtherDetailEntities = settlementBookOtherDetailEntities;
    }

    public List<SettlementBookStatementDetailVO> getSettlementBookStatementDetailEntities() {
        return settlementBookStatementDetailEntities;
    }

    public void setSettlementBookStatementDetailEntities(List<SettlementBookStatementDetailVO> settlementBookStatementDetailEntities) {
        this.settlementBookStatementDetailEntities = settlementBookStatementDetailEntities;
    }

    public List<SettlementBookSummaryDetailVO> getSettlementBookSummaryDetailEntities() {
        return settlementBookSummaryDetailEntities;
    }

    public void setSettlementBookSummaryDetailEntities(List<SettlementBookSummaryDetailVO> settlementBookSummaryDetailEntities) {
        this.settlementBookSummaryDetailEntities = settlementBookSummaryDetailEntities;
    }

    public List<SettlementBookBuckleDetailVO> getSettlementBookBuckleDetailEntities() {
        return settlementBookBuckleDetailEntities;
    }

    public void setSettlementBookBuckleDetailEntities(List<SettlementBookBuckleDetailVO> settlementBookBuckleDetailEntities) {
        this.settlementBookBuckleDetailEntities = settlementBookBuckleDetailEntities;
    }

    public List<SettlementBookVisaScheduleDetailVO> getSettlementBookVisaScheduleDetailEntities() {
        return settlementBookVisaScheduleDetailEntities;
    }

    public void setSettlementBookVisaScheduleDetailEntities(List<SettlementBookVisaScheduleDetailVO> settlementBookVisaScheduleDetailEntities) {
        this.settlementBookVisaScheduleDetailEntities = settlementBookVisaScheduleDetailEntities;
    }

    public List<SettlementBookQuantityBasDeatilVO> getSettlementBookQuantityBasDeatilEntities() {
        return settlementBookQuantityBasDeatilEntities;
    }

    public void setSettlementBookQuantityBasDeatilEntities(List<SettlementBookQuantityBasDeatilVO> settlementBookQuantityBasDeatilEntities) {
        this.settlementBookQuantityBasDeatilEntities = settlementBookQuantityBasDeatilEntities;
    }
}
