package com.ejianc.business.settlementmanage.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 结算策划书评审-主表
 *
 * @author generator
 */
@TableName("ejc_settlementmanage_settlement_plan")
public class SettlementPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value = "bill_state")
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value = "project_id")
    private java.lang.Long projectId; // 项目id
    @TableField(value = "project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value = "org_id")
    private java.lang.Long orgId; // 所属组织id
    @TableField(value = "org_name")
    private java.lang.String orgName; // 所属组织名称
    @TableField(value = "project_department_id")
    private java.lang.Long projectDepartmentId; // 项目部id
    @TableField(value = "agent_name")
    private java.lang.String agentName; // 经办人
    @TableField(value = "contract_name")
    private java.lang.String contractName; // 合同名称
    @TableField(value = "commencement_date")
    private java.util.Date commencementDate; // 开工日期
    @TableField(value = "completion_date")
    private java.util.Date completionDate; // 竣工日期
    @TableField(value = "contract_price")
    private java.math.BigDecimal contractPrice; // 合同造价
    @TableField(value = "actual_cost")
    private java.math.BigDecimal actualCost; // 实际成本
    @TableField(value = "settlement_value")
    private java.math.BigDecimal settlementValue; // 报审结算值
    @TableField(value = "visa_claims")
    private java.math.BigDecimal visaClaims; // 签证索赔
    @TableField(value = "design_changes")
    private java.math.BigDecimal designChanges; // 设计变更
    @TableField(value = "submission_date")
    private java.util.Date submissionDate; // 合同约定结算提交日期
    @TableField(value = "potential_counterclaims")
    private java.math.BigDecimal potentialCounterclaims; // 潜在违约及反索赔额
    @TableField(value = "received")
    private java.math.BigDecimal received; // 已收款
    @TableField(value = "confirmed_quotation")
    private java.math.BigDecimal confirmedQuotation; // 业主已确认报量
    @TableField(value = "remarks")
    private java.lang.String remarks; // 备注
    @TableField(value = "agent")
    private java.lang.Long agent; // 经办人id
    @TableField(value = "agent_department")
    private java.lang.Long agentDepartment; // 经办人部门
    @TableField(value = "contract_id")
    private java.lang.Long contractId; // 合同id
    @TableField(value = "original_id")
    private java.lang.Long originalId;
    @TableField(value="expect_settlement_value")
    private BigDecimal expectSettlementValue; // 预计结算值
    @TableField(value="expect_cost")
    private BigDecimal expectCost; // 预计成本
    @TableField(value="expect_profit")
    private BigDecimal expectProfit; // 预计利润额
    @TableField(value="expect_profit_rate")
    private BigDecimal expectProfitRate; // 预计利润率%
    @TableField(value="target_responsibility_margin")
    private BigDecimal targetResponsibilityMargin; // 目标责任书利润率

    public BigDecimal getExpectSettlementValue() {
        return expectSettlementValue;
    }

    public void setExpectSettlementValue(BigDecimal expectSettlementValue) {
        this.expectSettlementValue = expectSettlementValue;
    }

    public BigDecimal getExpectCost() {
        return expectCost;
    }

    public void setExpectCost(BigDecimal expectCost) {
        this.expectCost = expectCost;
    }

    public BigDecimal getExpectProfit() {
        return expectProfit;
    }

    public void setExpectProfit(BigDecimal expectProfit) {
        this.expectProfit = expectProfit;
    }

    public BigDecimal getExpectProfitRate() {
        return expectProfitRate;
    }

    public void setExpectProfitRate(BigDecimal expectProfitRate) {
        this.expectProfitRate = expectProfitRate;
    }

    public BigDecimal getTargetResponsibilityMargin() {
        return targetResponsibilityMargin;
    }

    public void setTargetResponsibilityMargin(BigDecimal targetResponsibilityMargin) {
        this.targetResponsibilityMargin = targetResponsibilityMargin;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

    /**
     * 项目id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }

    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }

    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    /**
     * 经办人
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }

    /**
     * 开工日期
     */
    public java.util.Date getCommencementDate() {
        return commencementDate;
    }

    /**
     * 开工日期
     */
    public void setCommencementDate(java.util.Date commencementDate) {
        this.commencementDate = commencementDate;
    }

    /**
     * 竣工日期
     */
    public java.util.Date getCompletionDate() {
        return completionDate;
    }

    /**
     * 竣工日期
     */
    public void setCompletionDate(java.util.Date completionDate) {
        this.completionDate = completionDate;
    }

    /**
     * 合同造价
     */
    public java.math.BigDecimal getContractPrice() {
        return contractPrice;
    }

    /**
     * 合同造价
     */
    public void setContractPrice(java.math.BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }

    /**
     * 实际成本
     */
    public java.math.BigDecimal getActualCost() {
        return actualCost;
    }

    /**
     * 实际成本
     */
    public void setActualCost(java.math.BigDecimal actualCost) {
        this.actualCost = actualCost;
    }

    /**
     * 报审结算值
     */
    public java.math.BigDecimal getSettlementValue() {
        return settlementValue;
    }

    /**
     * 报审结算值
     */
    public void setSettlementValue(java.math.BigDecimal settlementValue) {
        this.settlementValue = settlementValue;
    }

    /**
     * 签证索赔
     */
    public java.math.BigDecimal getVisaClaims() {
        return visaClaims;
    }

    /**
     * 签证索赔
     */
    public void setVisaClaims(java.math.BigDecimal visaClaims) {
        this.visaClaims = visaClaims;
    }

    /**
     * 设计变更
     */
    public java.math.BigDecimal getDesignChanges() {
        return designChanges;
    }

    /**
     * 设计变更
     */
    public void setDesignChanges(java.math.BigDecimal designChanges) {
        this.designChanges = designChanges;
    }

    /**
     * 合同约定结算提交日期
     */
    public java.util.Date getSubmissionDate() {
        return submissionDate;
    }

    /**
     * 合同约定结算提交日期
     */
    public void setSubmissionDate(java.util.Date submissionDate) {
        this.submissionDate = submissionDate;
    }

    /**
     * 潜在违约及反索赔额
     */
    public java.math.BigDecimal getPotentialCounterclaims() {
        return potentialCounterclaims;
    }

    /**
     * 潜在违约及反索赔额
     */
    public void setPotentialCounterclaims(java.math.BigDecimal potentialCounterclaims) {
        this.potentialCounterclaims = potentialCounterclaims;
    }

    /**
     * 已收款
     */
    public java.math.BigDecimal getReceived() {
        return received;
    }

    /**
     * 已收款
     */
    public void setReceived(java.math.BigDecimal received) {
        this.received = received;
    }

    /**
     * 业主已确认报量
     */
    public java.math.BigDecimal getConfirmedQuotation() {
        return confirmedQuotation;
    }

    /**
     * 业主已确认报量
     */
    public void setConfirmedQuotation(java.math.BigDecimal confirmedQuotation) {
        this.confirmedQuotation = confirmedQuotation;
    }

    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }

    /**
     * 经办人id
     */
    public java.lang.Long getAgent() {
        return agent;
    }

    /**
     * 经办人id
     */
    public void setAgent(java.lang.Long agent) {
        this.agent = agent;
    }

    /**
     * 经办人部门
     */
    public java.lang.Long getAgentDepartment() {
        return agentDepartment;
    }

    /**
     * 经办人部门
     */
    public void setAgentDepartment(java.lang.Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }

    /**
     * 合同id
     */
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }
}
