package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.DesignSettlementDetailEntity;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseDetailEntity;
import com.ejianc.business.settlementmanage.service.IDesignSettlementDetailService;
import com.ejianc.business.settlementmanage.service.IDesignSettlementService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseDetailService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.*;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("designSettlementExport")
public class ExcelDesignSettlementController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDesignSettlementDetailService materialPurchaseDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IDesignSettlementService service;

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialPurchaseSettlementExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<DesignSettlementDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DesignSettlementDetailVO subpackagematerialanalysisdetailVO = list.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialPurchaseSettlementExportFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody DesignSettlementVO subpackagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<DesignSettlementDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackagematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<DesignSettlementDetailEntity> list = materialPurchaseDetailService.list(queryWrapper);
        List<DesignSettlementDetailVO> subpackagematerialanalysisdetailVOList = BeanMapper.mapList(list, DesignSettlementDetailVO.class);
        if (subpackagematerialanalysisdetailVOList != null && subpackagematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < subpackagematerialanalysisdetailVOList.size(); i++) {
                DesignSettlementDetailVO subpackagematerialanalysisdetailVO = subpackagematerialanalysisdetailVOList.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaterialPurchaseSettlement")
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designsettlementdetail-import.xlsx", "设计类结算单清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaterialPurchaseSettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response,Long contractId, String date) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DesignSettlementDetailVO> successList = new ArrayList<>();
        List<DesignSettlementDetailVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        HashMap<String, String> map1 = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            //Map<String, DesignSettlementDetailVO> map2 = service.queryDesignDetailCumPastMap(contractId, date);
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    int num = 0;
                    List<String> datas = result.get(i);
                    DesignSettlementDetailVO subpackagematerialanalysisdetailVO = new DesignSettlementDetailVO();
                    subpackagematerialanalysisdetailVO.setId(IdWorker.getId());//id

                    String projectName = datas.get(0);//项目名称
                    String projectCharacteristics = datas.get(1);//项目特征
                    String measuringUnit = datas.get(2);//*计量单位
                    String auditExtaxAddition = datas.get(3);//*除税单价
                    String auditIntaxAddition = datas.get(4);//*含税单价
                    String auditCompleteNum = datas.get(5);//*完成量(本期 )
                    String categorys = datas.get(6);//类别
                    String remarks = datas.get(7);//备注
                    subpackagematerialanalysisdetailVO.setRemarks(remarks);
                    /**
                     * 项目重复校验
                     */
                    String key1 = datas.get(0) + datas.get(3) + datas.get(4);
                    String data0 = map.get(key1);
                    if (map.get(data0) != null) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "项目名称、除税单价、含税单价唯一，不能有重复行,请检查!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        map.put(key1, datas.get(0) + datas.get(3) + datas.get(4));
                        //  subpackagematerialanalysisdetailVO.setProjectName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资编码
                    }

                    if (StringUtils.isBlank(projectName)) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "项目名称不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        subpackagematerialanalysisdetailVO.setProjectName(projectName); // 项目名称
                    }

                    if (StringUtils.isBlank(projectCharacteristics)) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "项目特征不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        subpackagematerialanalysisdetailVO.setProjectCharacteristics(projectCharacteristics); // 项目特征
                    }

                    if (StringUtils.isBlank(measuringUnit)) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "计量单位不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;

                    } else {
                        subpackagematerialanalysisdetailVO.setMeasuringUnit(measuringUnit); // 计量单位
                    }

                    if (StringUtils.isBlank(auditExtaxAddition)) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "除税单价不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        if (!NumberUtil.isNumber(auditExtaxAddition)) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "除税单价格式错误!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditExtaxAddition(new BigDecimal(auditExtaxAddition));
                        }
                    }
                    if (StringUtils.isBlank(auditIntaxAddition)) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "含税单价不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        if (!NumberUtil.isNumber(auditIntaxAddition)) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "含税单价格式错误!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditIntaxAddition(new BigDecimal(auditIntaxAddition)); //  含税单价
                        }
                    }


                    if (StringUtils.isBlank(auditCompleteNum)) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "(本期)完成量不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        if (!NumberUtil.isNumber(auditCompleteNum)) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "(本期)完成量格式错误!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setAuditCompleteNum(new BigDecimal(auditCompleteNum)); // 完成量（本期审核）
                        }
                    }

                    /**
                     * 类别控制
                     */
                    if (categorys != null && !"".equals(categorys)) {
                        if (!"合同内".equals(categorys)&&!"合同外".equals(categorys)) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "类别输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setCategorys(StringUtils.isNotBlank(categorys) ? categorys : null); // 合同单价(含税)(元)
                        }
                    }

                    DesignsubcontractnodedetailVO vo = service.queryDetailHistory(contractId,projectName,new BigDecimal(auditExtaxAddition),new BigDecimal(auditIntaxAddition));
                    if(vo != null){
                        //上期 pastQuantity cumExtaxPrice  cumIntaxPrice
                        subpackagematerialanalysisdetailVO.setPastQuantity(vo.getCompleteThisAudit() == null ? new BigDecimal("0"):vo.getCompleteThisAudit());
                        subpackagematerialanalysisdetailVO.setCumExtaxPrice(vo.getExTaxTotalThisAudit() == null ? new BigDecimal("0"):vo.getExTaxTotalThisAudit());
                        subpackagematerialanalysisdetailVO.setCumIntaxPrice(vo.getInTaxTotalThisAudit() == null ? new BigDecimal("0"):vo.getInTaxTotalThisAudit());
                    }
                    //本期
                    // auditCompleteNum  完成量  curExtaxPrice 本期除税金额 curIntaxPrice 本期含税金额
                    //本期除税金额
                    subpackagematerialanalysisdetailVO.setCurExtaxPrice(ComputeUtil.safeMultiply(subpackagematerialanalysisdetailVO.getAuditCompleteNum()== null ? new BigDecimal("0"):subpackagematerialanalysisdetailVO.getAuditCompleteNum(),subpackagematerialanalysisdetailVO.getAuditExtaxAddition()== null ? new BigDecimal("0"):subpackagematerialanalysisdetailVO.getAuditExtaxAddition()));
                   //本期含税金额
                    subpackagematerialanalysisdetailVO.setCurIntaxPrice(ComputeUtil.safeMultiply(subpackagematerialanalysisdetailVO.getAuditCompleteNum()== null ? new BigDecimal("0"):subpackagematerialanalysisdetailVO.getAuditCompleteNum(),subpackagematerialanalysisdetailVO.getAuditIntaxAddition()== null ? new BigDecimal("0"):subpackagematerialanalysisdetailVO.getAuditIntaxAddition()));


                    // 累计
                   // cumQuantity  累计数量  auditExtaxAmount 累计除税合价 auditIntaxAmount 累计含税合价
                    subpackagematerialanalysisdetailVO.setCumQuantity(ComputeUtil.safeAdd(subpackagematerialanalysisdetailVO.getAuditCompleteNum() == null ? new BigDecimal(0):subpackagematerialanalysisdetailVO.getAuditCompleteNum(),subpackagematerialanalysisdetailVO.getPastQuantity()== null ? new BigDecimal(0):subpackagematerialanalysisdetailVO.getPastQuantity()));
                    subpackagematerialanalysisdetailVO.setAuditExtaxAmount(ComputeUtil.safeAdd(subpackagematerialanalysisdetailVO.getCumExtaxPrice() == null ? new BigDecimal(0):subpackagematerialanalysisdetailVO.getCumExtaxPrice(),subpackagematerialanalysisdetailVO.getCurExtaxPrice()== null ? new BigDecimal(0):subpackagematerialanalysisdetailVO.getCurExtaxPrice()));
                    subpackagematerialanalysisdetailVO.setAuditIntaxAmount(ComputeUtil.safeAdd(subpackagematerialanalysisdetailVO.getCumIntaxPrice() == null ? new BigDecimal(0):subpackagematerialanalysisdetailVO.getCumIntaxPrice(),subpackagematerialanalysisdetailVO.getCurIntaxPrice()== null ? new BigDecimal(0):subpackagematerialanalysisdetailVO.getCurIntaxPrice()));

                    if (num > 0) {
                        errorList.add(subpackagematerialanalysisdetailVO);
                    } else {
                        successList.add(subpackagematerialanalysisdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
