package com.ejianc.business.settlementmanage.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 物资采购最终结算子表
 *
 * @author generator
 *
 */
public class MaterialSettleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long settleId; // 主表id
    private String sort; // 序号
    private String source; // 来源
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long contractInfoId; // 合同清单id
    private String settleCode; // 结算单编号
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String brandModel; // 品牌/规格型号
    private String unit; // 单位
    private BigDecimal supplyQuantity; // 供货数量
    private BigDecimal supplyQuantityTotal; // 累计结算量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date supplyTime; // 供货时间
    private BigDecimal unitPrice; // 合同单价(除税)(元)
    private BigDecimal taxUnitPrice; // 合同单价(含税)(元)
    private BigDecimal settlementPrice; // 结算单价(除税)(元)
    private BigDecimal taxSettlementPrice; // 结算单价(含税)(元)
    private BigDecimal settlementAmount; // 结算金额(除税)(元)
    private BigDecimal taxSettlementAmount; // 结算金额(含税)(元)
    private BigDecimal taxRate; // 税率
    private String remarks; // 备注
    private BigDecimal settlementTotal; // 累计结算金额(除税)
    private BigDecimal paymentProportion; // 合同付款比例
    private String materialCategory; // 物资分类名称
    private BigDecimal taxSettlementTotal; // 累计结算金额(含税)
    private Long materialCategoryId; // 物资分类id
    private String materialCategoryCode; // 物资分类code
    private BigDecimal netPrice; // 网价
    private BigDecimal floatPrice; // 浮动价
    private Integer sourceType; //来源类型1-过程结算2-本期结算
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 发生时间

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractInfoId() {
        return contractInfoId;
    }

    public void setContractInfoId(Long contractInfoId) {
        this.contractInfoId = contractInfoId;
    }
    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getBrandModel() {
        return brandModel;
    }

    public void setBrandModel(String brandModel) {
        this.brandModel = brandModel;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getSupplyQuantity() {
        return supplyQuantity;
    }

    public void setSupplyQuantity(BigDecimal supplyQuantity) {
        this.supplyQuantity = supplyQuantity;
    }
    public BigDecimal getSupplyQuantityTotal() {
        return supplyQuantityTotal;
    }

    public void setSupplyQuantityTotal(BigDecimal supplyQuantityTotal) {
        this.supplyQuantityTotal = supplyQuantityTotal;
    }
    public Date getSupplyTime() {
        return supplyTime;
    }

    public void setSupplyTime(Date supplyTime) {
        this.supplyTime = supplyTime;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getTaxUnitPrice() {
        return taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }
    public BigDecimal getSettlementPrice() {
        return settlementPrice;
    }

    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }
    public BigDecimal getTaxSettlementPrice() {
        return taxSettlementPrice;
    }

    public void setTaxSettlementPrice(BigDecimal taxSettlementPrice) {
        this.taxSettlementPrice = taxSettlementPrice;
    }
    public BigDecimal getSettlementAmount() {
        return settlementAmount;
    }

    public void setSettlementAmount(BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }
    public BigDecimal getTaxSettlementAmount() {
        return taxSettlementAmount;
    }

    public void setTaxSettlementAmount(BigDecimal taxSettlementAmount) {
        this.taxSettlementAmount = taxSettlementAmount;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public BigDecimal getSettlementTotal() {
        return settlementTotal;
    }

    public void setSettlementTotal(BigDecimal settlementTotal) {
        this.settlementTotal = settlementTotal;
    }
    public BigDecimal getPaymentProportion() {
        return paymentProportion;
    }

    public void setPaymentProportion(BigDecimal paymentProportion) {
        this.paymentProportion = paymentProportion;
    }
    public String getMaterialCategory() {
        return materialCategory;
    }

    public void setMaterialCategory(String materialCategory) {
        this.materialCategory = materialCategory;
    }
    public BigDecimal getTaxSettlementTotal() {
        return taxSettlementTotal;
    }

    public void setTaxSettlementTotal(BigDecimal taxSettlementTotal) {
        this.taxSettlementTotal = taxSettlementTotal;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }
    public BigDecimal getNetPrice() {
        return netPrice;
    }

    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }
    public BigDecimal getFloatPrice() {
        return floatPrice;
    }

    public void setFloatPrice(BigDecimal floatPrice) {
        this.floatPrice = floatPrice;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
}
