package com.ejianc.business.settlementmanage.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资采购最终结算
 *
 * @author generator
 *
 */
public class MaterialSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long contractId; // 合同id
    private String contractName; //
    private String contractCode; // 合同编号
    private Long projectId; // 项目id
    private String projectName; //
    private String projectCode; // 项目编号
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long parentOrgId; // 父组织id
    private Long demanderId; // 需方id
    private String demanderName; // 需方名称
    private Long supplierId; // 供方id
    private String supplierName; // 供方名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 发生时间
    private String billCode; // 单据编号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 结算起始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结算截至时间
    private Long departmentAgentId; // 项目部经办人id
    private String departmentAgentName; // 项目部经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date departmentAgentDate; // 项目部经办时间
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date agentTime; // 经办时间
    private BigDecimal settleMny; // 本次结算金额(除税)
    private BigDecimal settleTaxMny; // 本次结算金额(含税)
    private BigDecimal measureSettleMny; // 其中本次安全文明措施费
    private BigDecimal sumMeasureSettleMny; // 其中累计安全文明措施费
    private BigDecimal sumSettleMny; // 累计结算金额(除税)
    private BigDecimal sumSettleTaxMny; // 累计结算金额(含税)

    private List<MaterialSettleDetailVO> detailList = new ArrayList<>(); // 物资采购最终结算子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDemanderId() {
        return demanderId;
    }

    @ReferDeserialTransfer
    public void setDemanderId(Long demanderId) {
        this.demanderId = demanderId;
    }
    public String getDemanderName() {
        return demanderName;
    }

    public void setDemanderName(String demanderName) {
        this.demanderName = demanderName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getDepartmentAgentId() {
        return departmentAgentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentAgentId(Long departmentAgentId) {
        this.departmentAgentId = departmentAgentId;
    }
    public String getDepartmentAgentName() {
        return departmentAgentName;
    }

    public void setDepartmentAgentName(String departmentAgentName) {
        this.departmentAgentName = departmentAgentName;
    }
    public Date getDepartmentAgentDate() {
        return departmentAgentDate;
    }

    public void setDepartmentAgentDate(Date departmentAgentDate) {
        this.departmentAgentDate = departmentAgentDate;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getAgentId() {
        return agentId;
    }
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Date getAgentTime() {
        return agentTime;
    }

    public void setAgentTime(Date agentTime) {
        this.agentTime = agentTime;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getMeasureSettleMny() {
        return measureSettleMny;
    }

    public void setMeasureSettleMny(BigDecimal measureSettleMny) {
        this.measureSettleMny = measureSettleMny;
    }
    public BigDecimal getSumMeasureSettleMny() {
        return sumMeasureSettleMny;
    }

    public void setSumMeasureSettleMny(BigDecimal sumMeasureSettleMny) {
        this.sumMeasureSettleMny = sumMeasureSettleMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public List<MaterialSettleDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MaterialSettleDetailVO> detailList) {
        this.detailList = detailList;
    }
}
