/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookSummaryDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISubcontractCountersignedService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.CostApi;
import com.ejianc.foundation.middlemeasurement.api.MidSettlementStateApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingApi;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionRequestVO;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionVO;
import com.ejianc.foundation.middlemeasurement.vo.SubVOList;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlementBook"})
public class SettlementBookController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SubcontractingApi subcontractingApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.MidSettlementStateApi")
    @Autowired
    private MidSettlementStateApi midSettlementStateApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.CostApi")
    @Autowired
    private CostApi costApi;
    private static final String BILL_CODE = "settlementmanage-settlement-book";
    @Autowired
    private ISettlementBookService service;
    @Autowired
    private ISubcontractCountersignedService subcontractCountersignedService;
    @Autowired
    private IOutcontractApi outcontractApi;
    List<SettlementBookStatementDetailVO> subList = new ArrayList<SettlementBookStatementDetailVO>();

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementBookVO> saveOrUpdate(@RequestBody SettlementBookVO saveorUpdateVO) {
        OverusedeductionRequestVO overusedeductionRequestVO;
        CommonResponse mapCommonResponse;
        Object overusedeductionVO;
        Iterator<SettlementBookMaterialDetailEntity> list;
        List<SettlementBookStatementDetailEntity> settlementBookStatementDetailEntities;
        SettlementBookEntity entity = (SettlementBookEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SettlementBookEntity.class));
        BigDecimal bigDecimal = new BigDecimal(0.0);
        BigDecimal bigDecimal1 = new BigDecimal(0.0);
        BigDecimal bigDecimal2 = new BigDecimal(0.0);
        BigDecimal bigDecimal3 = new BigDecimal(0.0);
        this.checkSubcontract(entity.getContractId());
        this.checkFormUniqueByMonth(entity);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(settlementBookStatementDetailEntities = entity.getSettlementBookStatementDetailEntities()).isEmpty() && settlementBookStatementDetailEntities.size() > 0) {
            ArrayList<SubVOList> subVOList = new ArrayList<SubVOList>();
            for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                String listingCode = settlementBookStatementDetail.getListingCode();
                String section = settlementBookStatementDetail.getSection();
                Long contractId = entity.getContractId();
                SubVOList list2 = new SubVOList();
                list2.setSubitemCode(listingCode);
                list2.setSection(section);
                list2.setContractId(contractId);
                subVOList.add(list2);
            }
            for (SettlementBookStatementDetailEntity settlementBookStatementDetail : settlementBookStatementDetailEntities) {
                BigDecimal thisAmountsTax;
                BigDecimal intaxAddition;
                BigDecimal thisAmountsNotax;
                BigDecimal extaxAddition;
                BigDecimal thisQuantity;
                BigDecimal quantities;
                BigDecimal bigDecimal4 = quantities = settlementBookStatementDetail.getQuantities() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getQuantities();
                if (settlementBookStatementDetail.getCumulativeEngineeringQuantity() == null) {
                    thisQuantity = quantities.subtract(new BigDecimal(0.0));
                    settlementBookStatementDetail.setCumulativeEngineeringQuantity(new BigDecimal(0.0));
                    settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                } else {
                    thisQuantity = quantities.subtract(settlementBookStatementDetail.getCumulativeEngineeringQuantity());
                    settlementBookStatementDetail.setThisEngineeringQuantity(thisQuantity);
                }
                BigDecimal bigDecimal5 = extaxAddition = settlementBookStatementDetail.getExtaxAddition() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getExtaxAddition();
                if (settlementBookStatementDetail.getAccruingAmountsNotax() == null) {
                    thisAmountsNotax = extaxAddition.subtract(new BigDecimal(0.0));
                    settlementBookStatementDetail.setAccruingAmountsNotax(new BigDecimal(0.0));
                    settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                } else {
                    thisAmountsNotax = extaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsNotax());
                    settlementBookStatementDetail.setThisAmountsNotax(thisAmountsNotax);
                }
                BigDecimal bigDecimal6 = intaxAddition = settlementBookStatementDetail.getIntaxAddition() == null ? new BigDecimal(0.0) : settlementBookStatementDetail.getIntaxAddition();
                if (settlementBookStatementDetail.getAccruingAmountsTax() == null) {
                    thisAmountsTax = intaxAddition.subtract(new BigDecimal(0.0));
                    settlementBookStatementDetail.setAccruingAmountsTax(new BigDecimal(0.0));
                    settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
                    continue;
                }
                thisAmountsTax = intaxAddition.subtract(settlementBookStatementDetail.getAccruingAmountsTax());
                settlementBookStatementDetail.setThisAmountsTax(thisAmountsTax);
            }
            entity.setSettlementBookStatementDetailEntities(settlementBookStatementDetailEntities);
        }
        if (!entity.getSettlementBookMaterialDetailEntities().isEmpty() && entity.getSettlementBookMaterialDetailEntities().size() > 0) {
            list = new ArrayList();
            for (SettlementBookMaterialDetailEntity entity1 : entity.getSettlementBookMaterialDetailEntities()) {
                overusedeductionVO = new com.ejianc.business.settlementmanage.vo.OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(entity1.getBillCode());
                overusedeductionVO.setSection(entity1.getSectionB());
                overusedeductionVO.setUnitPrice(entity1.getExtaxPurchasingprice());
                overusedeductionVO.setTaxUnitPrice(entity1.getIntaxPurchasingprice());
                list.add((SettlementBookMaterialDetailEntity)((Object)overusedeductionVO));
            }
            List list2 = BeanMapper.mapList(list, OverusedeductionVO.class);
            mapCommonResponse = this.costApi.queryOveruse(list2);
            if (mapCommonResponse.isSuccess()) {
                for (SettlementBookMaterialDetailEntity entity2 : entity.getSettlementBookMaterialDetailEntities()) {
                    overusedeductionRequestVO = (OverusedeductionRequestVO)((Map)mapCommonResponse.getData()).get(entity2.getBillCode() + entity2.getSectionB() + entity2.getExtaxPurchasingprice() + entity2.getIntaxPurchasingprice());
                    if (overusedeductionRequestVO != null) {
                        entity2.setCumExtaxSectionprice(overusedeductionRequestVO.getAmounts());
                        entity2.setCumIntaxSectionprice(overusedeductionRequestVO.getTaxAmounts());
                        if (entity2.getExtaxSectionprice() == null) {
                            entity2.setCurExtaxSectionprice(new BigDecimal(0.0));
                        } else {
                            entity2.setCurExtaxSectionprice(entity2.getExtaxSectionprice().subtract(entity2.getCumExtaxSectionprice()));
                        }
                        if (entity2.getIntaxSectionprice() == null) {
                            entity2.setCurIntaxSectionprice(new BigDecimal(0.0));
                        } else {
                            entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                        }
                    } else {
                        entity2.setCumExtaxSectionprice(new BigDecimal(0.0));
                        entity2.setCumIntaxSectionprice(new BigDecimal(0.0));
                        entity2.setCurExtaxSectionprice(entity2.getExtaxSectionprice().subtract(entity2.getCumExtaxSectionprice()));
                        entity2.setCurIntaxSectionprice(entity2.getIntaxSectionprice().subtract(entity2.getCumIntaxSectionprice()));
                    }
                    bigDecimal = bigDecimal.add(entity2.getCurExtaxSectionprice());
                    bigDecimal1 = bigDecimal1.add(entity2.getCurIntaxSectionprice());
                }
            }
        }
        if (!entity.getSettlementBookOtherDetailEntities().isEmpty() && entity.getSettlementBookOtherDetailEntities().size() > 0) {
            list = new ArrayList();
            for (SettlementBookOtherDetailEntity entity3 : entity.getSettlementBookOtherDetailEntities()) {
                overusedeductionVO = new com.ejianc.business.settlementmanage.vo.OverusedeductionVO();
                overusedeductionVO.setContractType(entity.getContractType());
                overusedeductionVO.setContractId(entity.getContractId().toString());
                overusedeductionVO.setSubitemCode(entity3.getWithholdingOther());
                overusedeductionVO.setSection(entity3.getDeductionsName());
                overusedeductionVO.setUnitPrice(entity3.getExtaxUnitpriceC());
                overusedeductionVO.setTaxUnitPrice(entity3.getIntaxUnitpriceC());
                list.add((SettlementBookMaterialDetailEntity)((Object)overusedeductionVO));
            }
            List list3 = BeanMapper.mapList(list, OverusedeductionVO.class);
            mapCommonResponse = this.costApi.queryOther(list3);
            if (mapCommonResponse.isSuccess()) {
                for (SettlementBookOtherDetailEntity entity4 : entity.getSettlementBookOtherDetailEntities()) {
                    overusedeductionRequestVO = (OverusedeductionRequestVO)((Map)mapCommonResponse.getData()).get(entity4.getWithholdingOther() + entity4.getDeductionsName() + entity4.getExtaxUnitpriceC() + entity4.getIntaxUnitpriceC());
                    if (overusedeductionRequestVO != null) {
                        entity4.setCumExtaxPrice(overusedeductionRequestVO.getAmounts());
                        entity4.setCumIntaxPrice(overusedeductionRequestVO.getTaxAmounts());
                        if (entity4.getExtaxPriceC() == null) {
                            entity4.setCurExtaxPrice(new BigDecimal(0.0));
                        } else {
                            entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        }
                        if (entity4.getIntaxPriceC() == null) {
                            entity4.setCurIntaxPrice(new BigDecimal(0.0));
                        } else {
                            entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                        }
                    } else {
                        entity4.setCumExtaxPrice(new BigDecimal(0.0));
                        entity4.setCumIntaxPrice(new BigDecimal(0.0));
                        entity4.setCurExtaxPrice(entity4.getExtaxPriceC().subtract(entity4.getCumExtaxPrice()));
                        entity4.setCurIntaxPrice(entity4.getIntaxPriceC().subtract(entity4.getCumIntaxPrice()));
                    }
                    bigDecimal2 = bigDecimal2.add(entity4.getCurExtaxPrice());
                    bigDecimal3 = bigDecimal3.add(entity4.getCurIntaxPrice());
                }
            }
        }
        if (!entity.getSettlementBookSummaryDetailEntities().isEmpty() && entity.getSettlementBookSummaryDetailEntities().size() > 0) {
            for (SettlementBookSummaryDetailEntity settlementBookSummaryDetailEntity : entity.getSettlementBookSummaryDetailEntities()) {
                if (settlementBookSummaryDetailEntity.getProjectName().equals("\u6750\u6599\u8282\u8d85")) {
                    settlementBookSummaryDetailEntity.setExtaxPrice(bigDecimal);
                    settlementBookSummaryDetailEntity.setIntaxPrice(bigDecimal1);
                }
                if (!settlementBookSummaryDetailEntity.getProjectName().equals("\u5176\u4ed6\u6263\u6b3e")) continue;
                settlementBookSummaryDetailEntity.setExtaxPrice(bigDecimal2);
                settlementBookSummaryDetailEntity.setIntaxPrice(bigDecimal3);
            }
        }
        entity = this.service.totalForm(entity);
        for (SettlementBookMaterialDetailEntity settlementBookMaterialDetailEntity : entity.getSettlementBookMaterialDetailEntities()) {
            settlementBookMaterialDetailEntity.setRowState("edit");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SettlementBookMaterialDetailEntity entitys : entity.getSettlementBookMaterialDetailEntities()) {
            if (entitys.getIsMiddId() == null) continue;
            ids.add(entitys.getIsMiddId());
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            this.service.updateIsMiddId(ids);
        }
        SettlementBookVO settlementBookVO = (SettlementBookVO)((Object)BeanMapper.map((Object)((Object)entity), SettlementBookVO.class));
        settlementBookVO.setSettlementBookStatementDetailEntities(this.handleChildren(settlementBookVO.getSettlementBookStatementDetailEntities()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)settlementBookVO));
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        HashMap<String, SettlementBookStatementDetailVO> map = new HashMap<String, SettlementBookStatementDetailVO>();
        SettlementBookStatementDetailVO add = list.get(list.size() - 1);
        for (SettlementBookStatementDetailVO VO : list) {
            if (VO.getId() != null) continue;
            VO.setId(IdWorker.getId());
        }
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getListingCode() + "_" + add.getSection());
        CommonResponse outcontractResp = this.outcontractApi.queryListBycontractIdAndCode(add.getContractId(), add.getListingCode());
        int responseCode = outcontractResp.getCode();
        if (responseCode == 0) {
            List voList = (List)outcontractResp.getData();
            if (voList != null && voList.size() > 0) {
                OutcontractSubcontractUnitPriceVO priceVO = (OutcontractSubcontractUnitPriceVO)voList.get(0);
                BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();
                add.setSource("\u5408\u540c\u5185");
                add.setIntaxUnitprice(comprehensiveUnitPrice);
                BigDecimal tax = priceVO.getTax();
                BigDecimal engineeringQuantity = priceVO.getEngineeringQuantity();
                if (tax != null && engineeringQuantity != null && engineeringQuantity.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal temp = tax.divide(engineeringQuantity, 8, 4);
                    add.setExtaxUnitprice(comprehensiveUnitPrice.subtract(temp));
                } else {
                    add.setExtaxUnitprice(comprehensiveUnitPrice);
                }
            } else {
                add.setSource("\u5408\u540c\u5916");
            }
        } else {
            add.setSource("\u5408\u540c\u5916");
        }
        for (SettlementBookStatementDetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (add.getId().equals(vo.getId()) || !add.getInnercode().equals(vo.getInnercode()) || !add.getExsettlementUnitprice().equals(vo.getExsettlementUnitprice()) || !add.getInsettlementUnitprice().equals(vo.getInsettlementUnitprice())) continue;
            throw new BusinessException("\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        String subitemCode = add.getListingCode();
        String section = add.getSection();
        String innercodeDouble = null;
        Map<String, List<SettlementBookStatementDetailVO>> mapDouble = list.stream().collect(Collectors.groupingBy(s -> s.getListingCode() + '_' + s.getSection()));
        if (subitemCode.length() == 4) {
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
        }
        if (subitemCode.length() == 6) {
            innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
        }
        if (subitemCode.length() > 6) {
            innercodeDouble = subitemCode.substring(0, 6) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
        }
        for (SettlementBookStatementDetailVO vo : list) {
            String innercode = vo.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                vo.setTpid(pid.toString());
                continue;
            }
            vo.setTpid("");
        }
        list = this.handleChildren(list);
        json.put("dataSource", list);
        return CommonResponse.success((Object)json);
    }

    private List<SettlementBookStatementDetailVO> handleChildren(List<SettlementBookStatementDetailVO> voList) {
        Collections.sort(voList, new Comparator<SettlementBookStatementDetailVO>(){

            @Override
            public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                return (o1.getListingCode() + o1.getSection()).compareTo(o2.getListingCode() + o2.getSection());
            }
        });
        List tpidList = voList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
        for (SettlementBookStatementDetailVO subcontractingvolumedetailVO : voList) {
            List<SettlementBookStatementDetailVO> detailByPid = this.getDetailByPid(subcontractingvolumedetailVO.getTid(), voList);
            if (!CollectionUtils.isNotEmpty(detailByPid)) continue;
            subcontractingvolumedetailVO.setCumulativeEngineeringQuantity(null);
            subcontractingvolumedetailVO.setThisEngineeringQuantity(null);
            subcontractingvolumedetailVO.setExtaxAddition(null);
            subcontractingvolumedetailVO.setIntaxAddition(null);
            subcontractingvolumedetailVO.setExsettlementUnitprice(null);
            subcontractingvolumedetailVO.setInsettlementUnitprice(null);
            subcontractingvolumedetailVO.setSource(null);
            BigDecimal thisAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsNotax() != null).map(SettlementBookStatementDetailVO::getThisAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal thisAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsTax() != null).map(SettlementBookStatementDetailVO::getThisAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal accruingAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsNotax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal accruingAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsTax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal intaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getIntaxAddition() != null).map(SettlementBookStatementDetailVO::getIntaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal extaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExtaxAddition() != null).map(SettlementBookStatementDetailVO::getExtaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add);
            subcontractingvolumedetailVO.setThisAmountsNotax(thisAmountsNotax);
            subcontractingvolumedetailVO.setThisAmountsTax(thisAmountsTax);
            subcontractingvolumedetailVO.setAccruingAmountsNotax(accruingAmountsNotax);
            subcontractingvolumedetailVO.setAccruingAmountsTax(accruingAmountsTax);
            subcontractingvolumedetailVO.setIntaxAddition(intaxAddition);
            subcontractingvolumedetailVO.setExtaxAddition(extaxAddition);
            this.subList.clear();
        }
        voList = SettlementBookController.createTreeData(voList);
        return voList;
    }

    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        ArrayList<SettlementBookStatementDetailVO> resp = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SettlementBookStatementDetailVO> listMap = new HashMap<String, SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = (SettlementBookStatementDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SettlementBookStatementDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private List<SettlementBookStatementDetailVO> getDetailByPid(String tid, List<SettlementBookStatementDetailVO> list) {
        for (SettlementBookStatementDetailVO subcontractingvolumedetailVO : list) {
            if (tid == null || !tid.equals(subcontractingvolumedetailVO.getTpid())) continue;
            this.getDetailByPid(subcontractingvolumedetailVO.getTid(), list);
            this.subList.add(subcontractingvolumedetailVO);
        }
        return this.subList;
    }

    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }

    private void checkDouble(String innercode, Map<String, List<SettlementBookStatementDetailVO>> mapDouble) {
        if (mapDouble.containsKey(innercode)) {
            List<SettlementBookStatementDetailVO> subcontractingvolumedetailVOS = mapDouble.get(innercode);
            if (subcontractingvolumedetailVOS.size() > 1) {
                throw new BusinessException("\u7236\u7ea7\u7f16\u7801\u91cd\u590d,\u65e0\u6cd5\u65b0\u589e!");
            }
            for (SettlementBookStatementDetailVO vo : subcontractingvolumedetailVOS) {
                if (vo.getInsettlementUnitprice() == null && vo.getExsettlementUnitprice() == null && vo.getExtaxUnitprice() == null && vo.getIntaxUnitprice() == null) continue;
                throw new BusinessException("\u7236\u7ea7\u5df2\u6709\u6570\u636e,\u65e0\u6cd5\u65b0\u589e!");
            }
        }
    }

    private void checkSubcontract(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pro = this.subcontractCountersignedService.list((Wrapper)queryWrapper);
        if (pro.isEmpty()) {
            throw new BusinessException("\u8bf7\u5148\u521b\u5efa\"\u5206\u5305\u7ed3\u7b97\u6761\u4ef6\u4f1a\u7b7e\u5355\"!");
        }
    }

    private void checkFormUniqueByMonth(SettlementBookEntity entity) {
        int count1;
        int count;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String date = sf.format(entity.getOrderMonth());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper.le((Object)"DATE_FORMAT( order_month, '%Y-%m' )", (Object)date);
        queryWrapper.eq((Object)"bill_state", (Object)0);
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((count = this.service.count((Wrapper)queryWrapper)) > 0) {
            throw new BusinessException("\u6b64\u5408\u540c\u5b58\u5728\u5f80\u671f\u5df2\u4fdd\u5b58\u672a\u63d0\u4ea4\u7ed3\u7b97\u5355,\u8bf7\u5148\u63d0\u4ea4\u5f80\u671f\u672a\u63d0\u4ea4\u7ed3\u7b97\u5355");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper1.eq((Object)"DATE_FORMAT( order_month, '%Y-%m' )", (Object)date);
        if (entity.getId() != null) {
            queryWrapper1.ne((Object)"id", (Object)entity.getId());
        }
        if ((count1 = this.service.count((Wrapper)queryWrapper1)) > 0) {
            throw new BusinessException("\u6b64\u5408\u540c\u5f53\u524d\u6708\u4efd\u5df2\u5b58\u5728\u7ed3\u7b97\u5355\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SettlementBookEntity checkBillCodeUniq(SettlementBookEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            if (entity.getId() != null && entity.getId() != 0L) {
                queryWrapperBillCode.ne((Object)"id", (Object)entity.getId());
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)).size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementBookVO> queryDetail(Long id) {
        SettlementBookEntity entity = (SettlementBookEntity)((Object)this.service.selectById(id));
        SettlementBookVO vo = (SettlementBookVO)((Object)BeanMapper.map((Object)((Object)entity), SettlementBookVO.class));
        vo.setSettlementBookStatementDetailEntities(this.handleChildren(vo.getSettlementBookStatementDetailEntities()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementBookVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.midSettlementStateApi.updateMidSettlementState(vos.get(0).getProjectId(), Integer.valueOf(1), vos.get(0).getOrderMonth().toString());
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("subcontractorsShallName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List settlementBookVOList = BeanMapper.mapList((Iterable)list, SettlementBookVO.class);
        for (int i = 0; i < settlementBookVOList.size(); ++i) {
            String billStateStr;
            SettlementBookVO settlementBookVO = (SettlementBookVO)((Object)settlementBookVOList.get(i));
            if (settlementBookVO.getCreateTime() != null) {
                settlementBookVO.setCreateTimeShow(DateUtils.dateSimple2(settlementBookVO.getCreateTime()));
            }
            if ((billStateStr = settlementBookVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u9a73\u56de";
            }
            settlementBookVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", settlementBookVOList);
        ExcelExport.getInstance().export("SettlementBook-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettlementBookData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettlementBookVO>> refSettlementBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/querySubcontractingvolumeByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, List>> querySubcontractingvolumeMaterialByContractId(@RequestParam(value="contractId") Long contractId) {
        List<SettlementBookStatementDetailVO> resList;
        HashMap map = new HashMap();
        HashMap<String, SettlementBookStatementDetailVO> mapVO = new HashMap<String, SettlementBookStatementDetailVO>();
        List<SettlementBookStatementDetailVO> statementDetailVOList = new ArrayList();
        CommonResponse statementResponse = this.subcontractingvolumeApi.querySubcontractingvolumeDetailByContractId(contractId);
        if (statementResponse.isSuccess()) {
            List data = (List)statementResponse.getData();
            statementDetailVOList = BeanMapper.mapList((Iterable)data, SettlementBookStatementDetailVO.class);
            for (SettlementBookStatementDetailVO VO : statementDetailVOList) {
                Object reVo;
                VO.setId(IdWorker.getId());
                VO.setTid(String.valueOf(IdWorker.getId()));
                VO.setIsDeleted("\u5426");
                VO.setInnercode(VO.getListingCode() + "_" + VO.getSection());
                if ("1".equals(VO.getSource())) {
                    VO.setSource("\u5408\u540c\u5185");
                }
                if ("2".equals(VO.getSource())) {
                    VO.setSource("\u5408\u540c\u5916");
                    VO.setExtaxUnitprice(null);
                    VO.setIntaxUnitprice(null);
                }
                if ((reVo = (SettlementBookStatementDetailVO)((Object)mapVO.get(VO.getInnercode()))) != null) continue;
                mapVO.put(VO.getInnercode(), VO);
            }
            Collections.sort(statementDetailVOList, new Comparator<SettlementBookStatementDetailVO>(){

                @Override
                public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                    return (o1.getListingCode() + o1.getSection()).compareTo(o2.getListingCode() + o2.getSection());
                }
            });
            resList = this.setTidAndTpid(statementDetailVOList, mapVO);
            List tpidList = resList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
            for (Object subcontractingvolumedetailVO : resList) {
                List<SettlementBookStatementDetailVO> detailByPid = this.getDetailByPid(subcontractingvolumedetailVO.getTid(), resList);
                if (!CollectionUtils.isNotEmpty(detailByPid)) continue;
                subcontractingvolumedetailVO.setCumulativeEngineeringQuantity(null);
                subcontractingvolumedetailVO.setThisEngineeringQuantity(null);
                subcontractingvolumedetailVO.setExtaxAddition(null);
                subcontractingvolumedetailVO.setIntaxAddition(null);
                subcontractingvolumedetailVO.setExsettlementUnitprice(null);
                subcontractingvolumedetailVO.setInsettlementUnitprice(null);
                subcontractingvolumedetailVO.setSource(null);
                BigDecimal thisAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsNotax() != null).map(SettlementBookStatementDetailVO::getThisAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal thisAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getThisAmountsTax() != null).map(SettlementBookStatementDetailVO::getThisAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal accruingAmountsNotax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsNotax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal accruingAmountsTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getAccruingAmountsTax() != null).map(SettlementBookStatementDetailVO::getAccruingAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal intaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getIntaxAddition() != null).map(SettlementBookStatementDetailVO::getIntaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal extaxAddition = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExtaxAddition() != null).map(SettlementBookStatementDetailVO::getExtaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add);
                subcontractingvolumedetailVO.setIntaxAddition(intaxAddition);
                subcontractingvolumedetailVO.setExtaxAddition(extaxAddition);
                subcontractingvolumedetailVO.setThisAmountsNotax(thisAmountsNotax);
                subcontractingvolumedetailVO.setThisAmountsTax(thisAmountsTax);
                subcontractingvolumedetailVO.setAccruingAmountsNotax(accruingAmountsNotax);
                subcontractingvolumedetailVO.setAccruingAmountsTax(accruingAmountsTax);
                this.subList.clear();
            }
            for (Object subcontractingvolumedetailVO : resList) {
                subcontractingvolumedetailVO.setQuantities(subcontractingvolumedetailVO.getCumulativeEngineeringQuantity());
                subcontractingvolumedetailVO.setIntaxAddition(subcontractingvolumedetailVO.getAccruingAmountsTax());
                subcontractingvolumedetailVO.setExtaxAddition(subcontractingvolumedetailVO.getAccruingAmountsNotax());
            }
        } else {
            throw new BusinessException(statementResponse.getMsg());
        }
        resList = SettlementBookController.createTreeData(resList);
        map.put("statementDetailVOList", resList);
        List materialDetailVOList = new ArrayList();
        CommonResponse materialResponse = this.subcontractingvolumeApi.querySubcontractingvolumeMaterialByContractId(contractId);
        if (materialResponse.isSuccess()) {
            List data = (List)materialResponse.getData();
            materialDetailVOList = BeanMapper.mapList((Iterable)data, SettlementBookMaterialDetailVO.class);
            Map maps = data.stream().collect(Collectors.toMap(com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO::getId, Function.identity()));
            for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : materialDetailVOList) {
                settlementBookMaterialDetailVO.setMaterialCode(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getBillCodeB());
                settlementBookMaterialDetailVO.setMaterialName(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getMaterialNameB());
                settlementBookMaterialDetailVO.setSort(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getSort());
                settlementBookMaterialDetailVO.setSpec(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getSubitemDesc());
                settlementBookMaterialDetailVO.setUnits(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getUnitsB());
                settlementBookMaterialDetailVO.setExtaxPurchasingprice(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getExtaxPurchasingpriceB());
                settlementBookMaterialDetailVO.setIntaxPurchasingprice(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getIntaxPurchasingprice());
                settlementBookMaterialDetailVO.setDosageCollar(new BigDecimal(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getDosageCollarB()));
                settlementBookMaterialDetailVO.setSettlementNum(new BigDecimal(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getSectionNumB()));
                settlementBookMaterialDetailVO.setSectionNum(new BigDecimal(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getSectionNumB()));
                settlementBookMaterialDetailVO.setExtaxSectionprice(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getExtaxSectionpriceB());
                settlementBookMaterialDetailVO.setIntaxSectionprice(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getIntaxSectionprice());
                settlementBookMaterialDetailVO.setIsEditState("\u5426");
                settlementBookMaterialDetailVO.setIsMiddId(((com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO)maps.get(settlementBookMaterialDetailVO.getId())).getMid());
                settlementBookMaterialDetailVO.setIsDeleted("\u5426");
            }
        } else {
            throw new BusinessException(materialResponse.getMsg());
        }
        map.put("materialDetailVOList", materialDetailVOList);
        List otherDetailVOArrayList = new ArrayList();
        CommonResponse otherResponse = this.subcontractingvolumeApi.querySubcontractingvolumeOtherByContractId(contractId);
        if (otherResponse.isSuccess()) {
            List data = (List)otherResponse.getData();
            otherDetailVOArrayList = BeanMapper.mapList((Iterable)data, SettlementBookOtherDetailVO.class);
            for (SettlementBookOtherDetailVO settlementBookOtherDetailVO : otherDetailVOArrayList) {
                settlementBookOtherDetailVO.setId(IdWorker.getId());
                settlementBookOtherDetailVO.setIsDeleted("\u5426");
            }
        } else {
            throw new BusinessException(otherResponse.getMsg());
        }
        map.put("otherDetailVOArrayList", otherDetailVOArrayList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u6708\u5ea6\u62a5\u91cf\u76f8\u5173\u6570\u636e\u6210\u529f", map);
    }

    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            SettlementBookStatementDetailVO consdrawbudgetdetailVO = vos.get(i);
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
                continue;
            }
            consdrawbudgetdetailVO.setTpid("");
        }
        return vos;
    }
}

