/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookStatementExport"})
public class ExcelSettlementBookStatementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;
    @Autowired
    private IOutcontractApi outcontractApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    List<SettlementBookStatementDetailVO> detailVOList = new ArrayList<SettlementBookStatementDetailVO>();

    @RequestMapping(value={"/exportStateFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        ArrayList<SettlementBookStatementDetailVO> records = new ArrayList<SettlementBookStatementDetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if (statementDetailVO.getChildren() == null || statementDetailVO.getChildren().size() <= 0) continue;
                this.splitList(statementDetailVO.getChildren(), records);
            }
        }
        HashMap<String, ArrayList<SettlementBookStatementDetailVO>> beans = new HashMap<String, ArrayList<SettlementBookStatementDetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    private void splitList(List<SettlementBookStatementDetailVO> list, List<SettlementBookStatementDetailVO> records) {
        for (SettlementBookStatementDetailVO vo : list) {
            String source = vo.getSource();
            if ("1".equals(source)) {
                source = "\u5408\u540c\u5185";
            } else if ("2".equals(source)) {
                source = "\u5408\u540c\u5916";
            }
            vo.setSource(source);
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/exportStateFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.statementDetailService.list((Wrapper)queryWrapper);
        List statementDetailVOList = BeanMapper.mapList((Iterable)list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = (SettlementBookStatementDetailVO)((Object)statementDetailVOList.get(i));
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/stateExcelDown"})
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SettlementBookStatementDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u6e05\u5355\u7ed3\u7b97\u8868\u6a21\u677f");
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/statementExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId, String detailVOS, boolean isExport) throws ParseException {
        void var22_27;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        List<SettlementBookStatementDetailVO> successList = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<SettlementBookStatementDetailVO> errorList = new ArrayList<SettlementBookStatementDetailVO>();
        HashMap<String, SettlementBookStatementDetailVO> map = new HashMap<String, SettlementBookStatementDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        List detailList = JSONArray.parseArray((String)detailVOS, SettlementBookStatementDetailVO.class);
        ArrayList<SettlementBookStatementDetailVO> pcList = new ArrayList<SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO vo : detailList) {
            if (!vo.getIsDeleted().equals("\u5426")) continue;
            vo.setIntaxAddition(vo.getIntaxAddition() != null ? vo.getIntaxAddition() : BigDecimal.ZERO);
            vo.setExtaxAddition(vo.getExtaxAddition() != null ? vo.getExtaxAddition() : BigDecimal.ZERO);
            vo.setThisAmountsTax(vo.getThisAmountsTax() != null ? vo.getThisAmountsTax() : BigDecimal.ZERO);
            vo.setThisAmountsNotax(vo.getThisAmountsNotax() != null ? vo.getThisAmountsNotax() : BigDecimal.ZERO);
            vo.setChildren(null);
            pcList.add(vo);
            map.put(vo.getListingCode() + "_" + vo.getSection(), vo);
        }
        List tpids = pcList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
        ArrayList<String> fList = new ArrayList<String>();
        ArrayList<String> sectionList = new ArrayList<String>();
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList<SettlementBookStatementDetailVO> lastList = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<SettlementBookStatementDetailVO> allList = new ArrayList<SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : pcList) {
            String innerCode = settlementBookStatementDetailVO.getListingCode() + "_" + settlementBookStatementDetailVO.getSection() + "_" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "_" + settlementBookStatementDetailVO.getExsettlementUnitprice();
            if (!fList.contains(innerCode)) {
                fList.add(innerCode);
                allList.add(settlementBookStatementDetailVO);
            }
            if (tpids.contains(settlementBookStatementDetailVO.getTid())) continue;
            sectionList.add(settlementBookStatementDetailVO.getSection());
            codeList.add(settlementBookStatementDetailVO.getListingCode());
            lastList.add(settlementBookStatementDetailVO);
        }
        for (Map.Entry entry : fileMap.entrySet()) {
            mf = (MultipartFile)entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, SettlementBookStatementDetailVO> mapperMap = new HashMap<String, SettlementBookStatementDetailVO>();
        ArrayList arrayList = new ArrayList();
        CommonResponse listCommonResponse = this.subcontractingvolumeApi.querySubcontractingvolumeDetailByContractId(contractId);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            List list = BeanMapper.mapList((Iterable)data, SettlementBookStatementDetailVO.class);
            for (SettlementBookStatementDetailVO VO : list) {
                String listCode = VO.getListingCode();
                String section1 = VO.getSection();
                String extaxUnitprice = VO.getExtaxUnitprice() != null ? VO.getExtaxUnitprice().setScale(2, 4).toString() : "0";
                String intaxUnitprice = VO.getIntaxUnitprice() != null ? VO.getIntaxUnitprice().setScale(2, 4).toString() : "0";
                String key = listCode + "_" + section1 + "_" + extaxUnitprice + "_" + intaxUnitprice;
                if ("1".equals(VO.getSource())) {
                    VO.setSource("\u5408\u540c\u5185");
                } else {
                    VO.setSource("\u5408\u540c\u5916");
                }
                VO.setId(IdWorker.getId());
                mapperMap.put(key, VO);
            }
        }
        boolean flag = true;
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                String inndeCode = (String)datas.get(0) + "_" + (String)datas.get(1) + "_" + (String)datas.get(7) + "_" + (String)datas.get(8);
                SettlementBookStatementDetailVO detailVO = new SettlementBookStatementDetailVO();
                detailVO.setListingCode((String)datas.get(0));
                detailVO.setSection((String)datas.get(1));
                if (fList.contains(inndeCode)) continue;
                fList.add(inndeCode);
                allList.add(detailVO);
            }
        }
        Map<Object, Object> mapPlan = new HashMap();
        if (CollectionUtils.isNotEmpty(allList)) {
            mapPlan = allList.stream().collect(Collectors.groupingBy(s -> s.getListingCode() + '-' + s.getSection()));
        }
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                String intaxUnitpriceString;
                BigDecimal intaxUnitpricedecimal;
                String extaxUnitpriceString;
                BigDecimal extaxUnitpricedecimal;
                List datas = (List)result.get(i);
                String listingCode = (String)datas.get(0);
                String section = (String)datas.get(1);
                String partProjectName = (String)datas.get(2);
                String subitemDesc = (String)datas.get(3);
                String units = (String)datas.get(4);
                String intaxUnitprice = (String)datas.get(5);
                String extaxUnitprice = (String)datas.get(6);
                String insettlementUnitprice = (String)datas.get(7);
                String exsettlementUnitprice = (String)datas.get(8);
                String thisEngineeringQuantity = (String)datas.get(9);
                String quantities = (String)datas.get(10);
                String source = (String)datas.get(11);
                String remarks = (String)datas.get(12);
                SettlementBookStatementDetailVO statementDetailVO = new SettlementBookStatementDetailVO();
                statementDetailVO.setId(IdWorker.getId());
                statementDetailVO.setSort(Long.valueOf(i));
                statementDetailVO.setTid(String.valueOf(IdWorker.getId()));
                statementDetailVO.setUnits(units);
                statementDetailVO.setRemarks(remarks);
                statementDetailVO.setSource(source);
                statementDetailVO.setSubitemDesc(subitemDesc);
                statementDetailVO.setListingCode(listingCode);
                statementDetailVO.setSection(section);
                statementDetailVO.setPartProjectName(partProjectName);
                statementDetailVO.setInnercode(listingCode + "_" + section);
                if (StringUtils.isBlank((CharSequence)listingCode)) {
                    statementDetailVO.setErrorMsg("'\u6e05\u5355\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (listingCode == null || listingCode.length() != 2 && listingCode.length() != 4 && listingCode.length() != 6 && listingCode.length() < 9) {
                    statementDetailVO.setErrorMsg("\u5b50\u76ee\u7f16\u7801\u5fc5\u987b\u7b26\u5408\uff1a2\u4f4d\u30014\u4f4d\u30016\u4f4d\u30019\u4f4d\u62169\u4f4d\u4ee5\u4e0a\u4e2d\u4efb\u610f\u4e00\u89c4\u5219");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                statementDetailVO.setListingCode(listingCode);
                if (StringUtils.isBlank((CharSequence)section)) {
                    statementDetailVO.setErrorMsg("'\u533a\u6bb5'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (((List)mapPlan.get(listingCode + "-" + section)).size() > 1) {
                    statementDetailVO.setErrorMsg("\u7236\u7ea7'\u7f16\u7801' '\u533a\u6bb5'\u91cd\u590d,\u65e0\u6cd5\u65b0\u589e!");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)partProjectName)) {
                    statementDetailVO.setErrorMsg("'\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                statementDetailVO.setPartProjectName(partProjectName);
                SettlementBookStatementDetailVO mapVO = map.get(statementDetailVO.getInnercode());
                if (mapVO != null) {
                    statementDetailVO.setErrorMsg("'\u6e05\u5355\u7f16\u7801','\u533a\u6bb5','\u5408\u540c\u9664\u7a0e\u5355\u4ef7','\u5408\u540c\u542b\u7a0e\u5355\u4ef7'\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d\uff01");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                map.put(statementDetailVO.getInnercode(), statementDetailVO);
                String key = "";
                if (!extaxUnitprice.equals("")) {
                    if (!intaxUnitprice.equals("")) {
                        extaxUnitpricedecimal = new BigDecimal(extaxUnitprice);
                        extaxUnitpricedecimal = extaxUnitpricedecimal.setScale(2, 4);
                        extaxUnitpriceString = extaxUnitpricedecimal.toString();
                        intaxUnitpricedecimal = new BigDecimal(intaxUnitprice);
                        intaxUnitpricedecimal = intaxUnitpricedecimal.setScale(2, 4);
                        intaxUnitpriceString = intaxUnitpricedecimal.toString();
                        key = listingCode + "_" + section + "_" + extaxUnitpriceString + "_" + intaxUnitpriceString;
                    } else {
                        extaxUnitpricedecimal = new BigDecimal(extaxUnitprice);
                        extaxUnitpricedecimal = extaxUnitpricedecimal.setScale(2, 4);
                        extaxUnitpriceString = extaxUnitpricedecimal.toString();
                        intaxUnitprice = "0";
                        intaxUnitpricedecimal = new BigDecimal(intaxUnitprice);
                        intaxUnitpricedecimal = intaxUnitpricedecimal.setScale(2, 4);
                        intaxUnitpriceString = intaxUnitpricedecimal.toString();
                        key = listingCode + "_" + section + "_" + extaxUnitpriceString;
                    }
                } else if (!intaxUnitprice.equals("")) {
                    extaxUnitprice = "0";
                    extaxUnitpricedecimal = new BigDecimal(extaxUnitprice);
                    extaxUnitpricedecimal = extaxUnitpricedecimal.setScale(2, 4);
                    extaxUnitpriceString = extaxUnitpricedecimal.toString();
                    intaxUnitpricedecimal = new BigDecimal(intaxUnitprice);
                    intaxUnitpricedecimal = intaxUnitpricedecimal.setScale(2, 4);
                    intaxUnitpriceString = intaxUnitpricedecimal.toString();
                    key = listingCode + "_" + section + "_" + intaxUnitpriceString;
                } else {
                    extaxUnitprice = "0";
                    extaxUnitpricedecimal = new BigDecimal(extaxUnitprice);
                    extaxUnitpricedecimal = extaxUnitpricedecimal.setScale(2, 4);
                    extaxUnitpriceString = extaxUnitpricedecimal.toString();
                    intaxUnitprice = "0";
                    intaxUnitpricedecimal = new BigDecimal(intaxUnitprice);
                    intaxUnitpricedecimal = intaxUnitpricedecimal.setScale(2, 4);
                    intaxUnitpriceString = intaxUnitpricedecimal.toString();
                    key = listingCode + "_";
                }
                statementDetailVO.setInnercode(key);
                SettlementBookStatementDetailVO VO = (SettlementBookStatementDetailVO)((Object)mapperMap.get(key));
                if (VO != null) {
                    String subcontractingvolumeSource = VO.getSource();
                    statementDetailVO.setSource(subcontractingvolumeSource);
                    statementDetailVO.setCumulativeEngineeringQuantity(VO.getCumulativeEngineeringQuantity());
                } else {
                    CommonResponse outcontractResp = this.outcontractApi.queryListBycontractIdAndCode(contractId, listingCode);
                    List voList = (List)outcontractResp.getData();
                    if (voList != null && voList.size() > 0) {
                        statementDetailVO.setSource("\u5408\u540c\u5185");
                    } else {
                        statementDetailVO.setSource("\u5408\u540c\u5916");
                    }
                }
                if (StringUtils.isBlank((CharSequence)quantities) && StringUtils.isBlank((CharSequence)thisEngineeringQuantity)) {
                    statementDetailVO.setErrorMsg("'\u5de5\u7a0b\u91cf\u548c\u672c\u6b21\u62a5\u91cf\u5de5\u7a0b\u91cf'\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)quantities)) {
                    if (!NumberUtil.isNumber((String)quantities)) {
                        statementDetailVO.setErrorMsg("'\u5de5\u7a0b\u91cf'\u683c\u5f0f\u9519\u8bef");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }
                    statementDetailVO.setQuantities(new BigDecimal(quantities));
                    BigDecimal thisQuantity = new BigDecimal(quantities).subtract(BigDecimalUtils.ofNullable(statementDetailVO.getCumulativeEngineeringQuantity()));
                    statementDetailVO.setThisEngineeringQuantity(thisQuantity);
                }
                if (!StringUtils.isBlank((CharSequence)thisEngineeringQuantity)) {
                    if (!NumberUtil.isNumber((String)thisEngineeringQuantity)) {
                        statementDetailVO.setErrorMsg("'\u672c\u6b21\u62a5\u91cf\u5de5\u7a0b\u91cf'\u683c\u5f0f\u9519\u8bef");
                        errorList.add(statementDetailVO);
                        flag = false;
                        continue;
                    }
                    statementDetailVO.setThisEngineeringQuantity(new BigDecimal(thisEngineeringQuantity));
                    BigDecimal sumQuantity = new BigDecimal(thisEngineeringQuantity).add(BigDecimalUtils.ofNullable(statementDetailVO.getCumulativeEngineeringQuantity()));
                    statementDetailVO.setQuantities(sumQuantity);
                }
                if (StringUtils.isBlank((CharSequence)exsettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u9664\u7a0e\u5355\u4ef7'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (!NumberUtil.isNumber((String)exsettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u9664\u7a0e\u5355\u4ef7'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (VO != null) {
                    statementDetailVO.setExsettlementUnitprice(BigDecimalUtils.ofNullable(VO.getExsettlementUnitprice()));
                } else {
                    statementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                }
                if (StringUtils.isBlank((CharSequence)insettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u542b\u7a0e\u5355\u4ef7'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (!NumberUtil.isNumber((String)insettlementUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u542b\u7a0e\u5355\u4ef7'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (VO != null) {
                    statementDetailVO.setInsettlementUnitprice(BigDecimalUtils.ofNullable(VO.getInsettlementUnitprice()));
                } else {
                    statementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                }
                if (!NumberUtil.isNumber((String)extaxUnitprice)) {
                    statementDetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7(\u9664\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (VO != null) {
                    statementDetailVO.setExtaxUnitprice(BigDecimalUtils.ofNullable(VO.getExtaxUnitprice()));
                } else {
                    statementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                }
                if (!NumberUtil.isNumber((String)intaxUnitprice)) {
                    statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                    statementDetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7(\u542b\u7a0e)'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (VO != null) {
                    statementDetailVO.setIntaxUnitprice(BigDecimalUtils.ofNullable(VO.getIntaxUnitprice()));
                } else {
                    statementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                }
                BigDecimal exsettlementUnitpriceB = statementDetailVO.getExsettlementUnitprice();
                BigDecimal extaxUnitpriceB = statementDetailVO.getExtaxUnitprice();
                if (extaxUnitpriceB.compareTo(exsettlementUnitpriceB) == -1) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7\u9664\u7a0e'\u4e0d\u80fd\u5927\u4e8e'\u5408\u540c\u5355\u4ef7\u9664\u7a0e'");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                BigDecimal insettlementUnitpriceB = statementDetailVO.getInsettlementUnitprice();
                BigDecimal intaxUnitpriceB = statementDetailVO.getIntaxUnitprice();
                if (intaxUnitpriceB.compareTo(insettlementUnitpriceB) == -1) {
                    statementDetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7\u542b\u7a0e'\u4e0d\u80fd\u5927\u4e8e'\u5408\u540c\u5355\u4ef7\u542b\u7a0e'");
                    errorList.add(statementDetailVO);
                    flag = false;
                    continue;
                }
                if (sectionList.contains(section)) {
                    String pcode;
                    if (listingCode.length() == 4) {
                        pcode = listingCode.substring(0, 2);
                        if (codeList.contains(pcode)) {
                            statementDetailVO.setErrorMsg("\u5408\u540c\u5e26\u51fa\u6570\u636e\u672b\u7ea7\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff01");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }
                    } else if (listingCode.length() == 6) {
                        pcode = listingCode.substring(0, 4);
                        if (codeList.contains(pcode)) {
                            statementDetailVO.setErrorMsg("\u5408\u540c\u5e26\u51fa\u6570\u636e\u672b\u7ea7\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff01");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }
                        if (codeList.contains(listingCode.substring(0, 2))) {
                            statementDetailVO.setErrorMsg("\u5408\u540c\u5e26\u51fa\u6570\u636e\u672b\u7ea7\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff01");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }
                    } else if (listingCode.length() > 6) {
                        pcode = listingCode.substring(0, 6);
                        if (codeList.contains(pcode)) {
                            statementDetailVO.setErrorMsg("\u5408\u540c\u5e26\u51fa\u6570\u636e\u672b\u7ea7\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff01");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }
                        if (codeList.contains(listingCode.substring(0, 4))) {
                            statementDetailVO.setErrorMsg("\u5408\u540c\u5e26\u51fa\u6570\u636e\u672b\u7ea7\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff01");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }
                        if (codeList.contains(listingCode.substring(0, 2))) {
                            statementDetailVO.setErrorMsg("\u5408\u540c\u5e26\u51fa\u6570\u636e\u672b\u7ea7\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7\uff01");
                            errorList.add(statementDetailVO);
                            flag = false;
                            continue;
                        }
                    }
                }
                statementDetailVO.setThisAmountsNotax(ComputeUtil.safeMultiply((BigDecimal)statementDetailVO.getExsettlementUnitprice(), (BigDecimal)statementDetailVO.getThisEngineeringQuantity()));
                statementDetailVO.setThisAmountsTax(ComputeUtil.safeMultiply((BigDecimal)statementDetailVO.getInsettlementUnitprice(), (BigDecimal)statementDetailVO.getThisEngineeringQuantity()));
                statementDetailVO.setExtaxAddition(ComputeUtil.safeMultiply((BigDecimal)statementDetailVO.getExsettlementUnitprice(), (BigDecimal)statementDetailVO.getThisEngineeringQuantity()));
                statementDetailVO.setIntaxAddition(ComputeUtil.safeMultiply((BigDecimal)statementDetailVO.getInsettlementUnitprice(), (BigDecimal)statementDetailVO.getThisEngineeringQuantity()));
                statementDetailVO.setIsDeleted("\u662f");
                statementDetailVO.setTid(String.valueOf(IdWorker.getId()));
                map.put(statementDetailVO.getListingCode() + "_" + statementDetailVO.getSection(), statementDetailVO);
                successList.add(statementDetailVO);
                if (var22_27.isEmpty() || VO == null) continue;
                var22_27.remove((Object)VO);
            }
        }
        if (!var22_27.isEmpty() && flag && isExport) {
            int i = 1;
            for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : var22_27) {
                settlementBookStatementDetailVO.setErrorMsg("\u6b64\u6570\u636e\u4e3a\u4ece\u5206\u5305\u6708\u5ea6\u62a5\u91cf\u83b7\u53d6\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                settlementBookStatementDetailVO.setSort(Long.valueOf(i));
                errorList.add(settlementBookStatementDetailVO);
                ++i;
            }
        }
        successList.addAll(pcList);
        List<Object> resList = new ArrayList();
        if (!successList.isEmpty()) {
            Collections.sort(successList, new Comparator<SettlementBookStatementDetailVO>(){

                @Override
                public int compare(SettlementBookStatementDetailVO o1, SettlementBookStatementDetailVO o2) {
                    return (o1.getListingCode() + o1.getPartProjectName()).compareTo(o2.getListingCode() + o2.getPartProjectName());
                }
            });
            resList = this.setTidAndTpid(successList, map);
            List list = resList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
            for (SettlementBookStatementDetailVO vo : successList) {
                List lastDetails;
                vo.setId(IdWorker.getId());
                List<SettlementBookStatementDetailVO> detailVOList = this.getDetailByPidPlanCsf(vo.getTid(), successList);
                if (CollectionUtils.isNotEmpty(detailVOList) && CollectionUtils.isNotEmpty(lastDetails = detailVOList.stream().filter(s -> !successTpids.contains(s.getTid())).collect(Collectors.toList()))) {
                    vo.setThisEngineeringQuantity(null);
                    vo.setQuantities(null);
                    vo.setIntaxUnitprice(null);
                    vo.setExtaxUnitprice(null);
                    vo.setInsettlementUnitprice(null);
                    vo.setExsettlementUnitprice(null);
                    vo.setThisAmountsTax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add));
                    vo.setThisAmountsNotax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add));
                    vo.setIntaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getIntaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
                    vo.setExtaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getExtaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
                detailVOList.clear();
            }
            successList = ExcelSettlementBookStatementController.createTreeData(successList);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("successNum", (Object)resList.size());
        jSONObject.put("successList", successList);
        jSONObject.put("errorList", errorList);
        jSONObject.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)jSONObject);
    }

    private List<SettlementBookStatementDetailVO> getDetailByPidPlanCsf(String tid, List<SettlementBookStatementDetailVO> list) {
        for (SettlementBookStatementDetailVO vo : list) {
            if (tid == null || !tid.equals(vo.getTpid())) continue;
            this.getDetailByPidPlanCsf(vo.getTid(), list);
            this.detailVOList.add(vo);
        }
        return this.detailVOList;
    }

    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            SettlementBookStatementDetailVO settlementBookStatementDetailVO = vos.get(i);
            String innercode = settlementBookStatementDetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                settlementBookStatementDetailVO.setTpid(pid.toString());
                continue;
            }
            settlementBookStatementDetailVO.setTpid("");
        }
        return vos;
    }

    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        ArrayList<SettlementBookStatementDetailVO> resp = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SettlementBookStatementDetailVO> listMap = new HashMap<String, SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = (SettlementBookStatementDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SettlementBookStatementDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }
}

