/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinaldetailService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalodetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"consultotherfinalExport"})
public class ExcelConsultotherfinalController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsultotherfinalService service;
    @Autowired
    private IConsultotherfinaldetailService consultotherfinaldetailService;
    @Autowired
    private IConsultotherfinalodetailService consultotherfinalodetailService;

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"consultotherfinaldetail-import.xlsx", (String)"\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u6700\u7ec8\u7ed3\u7b97\u5355-\u6700\u7ec8\u7ed3\u7b97\u8ba1\u4ef7\u660e\u8868");
    }

    @RequestMapping(value={"/download3"}, method={RequestMethod.POST})
    @ResponseBody
    public void download3(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"consultotherfinalodetail-import.xlsx", (String)"\u5176\u5b83\u6263\u6b3e\u6e05\u5355");
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response, Long contractId, String date) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ConsultotherfinaldetailVO> successList = new ArrayList<ConsultotherfinaldetailVO>();
        ArrayList<ConsultotherfinaldetailVO> errorList = new ArrayList<ConsultotherfinaldetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Map<String, ConsultotherfinaldetailVO> map1 = this.service.queryConsultDetailCumPastMap(contractId, date);
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal quantityB;
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String subitemName = (String)datas.get(0);
                String spec = (String)datas.get(1);
                String unit = (String)datas.get(2);
                String unitprice = (String)datas.get(3);
                String taxUnitprice = (String)datas.get(4);
                String quantity = (String)datas.get(5);
                String amounts = (String)datas.get(6);
                String taxAmounts = (String)datas.get(7);
                String source = (String)datas.get(8);
                String memo = (String)datas.get(9);
                ConsultotherfinaldetailVO detailVO = new ConsultotherfinaldetailVO();
                detailVO.setId(IdWorker.getId());
                detailVO.setTid(String.valueOf(IdWorker.getId()));
                detailVO.setContractId(contractId);
                detailVO.setSubitemName(subitemName);
                detailVO.setSpec(spec);
                detailVO.setUnit(unit);
                if ("\u5408\u540c\u5185".equals(source)) {
                    detailVO.setSource("1");
                } else if ("\u5408\u540c\u5916".equals(source)) {
                    detailVO.setSource("2");
                }
                detailVO.setMemo(memo);
                if (subitemName == null || TextUtils.isEmpty((CharSequence)subitemName)) {
                    detailVO.setErrorMsg("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (unit == null || TextUtils.isEmpty((CharSequence)unit)) {
                    detailVO.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (quantity == null || TextUtils.isEmpty((CharSequence)quantity)) {
                    detailVO.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (unitprice == null || TextUtils.isEmpty((CharSequence)unitprice)) {
                    detailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (taxUnitprice == null || TextUtils.isEmpty((CharSequence)taxUnitprice)) {
                    detailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isNotBlank((CharSequence)quantity)) {
                    if (!NumberUtil.isNumber((String)quantity)) {
                        detailVO.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setQuantity(new BigDecimal(quantity));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)unitprice)) {
                    if (!NumberUtil.isNumber((String)unitprice)) {
                        detailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setUnitprice(new BigDecimal(unitprice));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)taxUnitprice)) {
                    if (!NumberUtil.isNumber((String)taxUnitprice)) {
                        detailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setTaxUnitprice(new BigDecimal(taxUnitprice));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)amounts)) {
                    if (!NumberUtil.isNumber((String)amounts)) {
                        detailVO.setErrorMsg("\u9664\u7a0e\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u9664\u7a0e\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setCurExtaxPrice(new BigDecimal(amounts));
                    }
                } else {
                    quantityB = detailVO.getQuantity();
                    BigDecimal unitpriceB = detailVO.getUnitprice();
                    if (quantityB != null && unitpriceB != null) {
                        detailVO.setCurExtaxPrice(quantityB.multiply(unitpriceB));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)taxAmounts)) {
                    if (!NumberUtil.isNumber((String)taxAmounts)) {
                        detailVO.setErrorMsg("\u542b\u7a0e\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u542b\u7a0e\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setCurIntaxPrice(new BigDecimal(taxAmounts));
                    }
                } else {
                    quantityB = detailVO.getQuantity();
                    BigDecimal taxUnitpriceB = detailVO.getTaxUnitprice();
                    if (quantityB != null && taxUnitpriceB != null) {
                        detailVO.setCurIntaxPrice(quantityB.multiply(taxUnitpriceB));
                    }
                }
                if (!map1.isEmpty()) {
                    String key = detailVO.getSubitemName() + detailVO.getUnitprice().setScale(2, 4) + detailVO.getTaxUnitprice().setScale(2, 4);
                    ConsultotherfinaldetailVO consultotherfinaldetailVO = map1.get(key);
                    if (consultotherfinaldetailVO != null) {
                        detailVO.setIsEditState("\u5426");
                        detailVO.setCumExtaxPrice(consultotherfinaldetailVO.getCumExtaxPrice());
                        detailVO.setCumIntaxPrice(consultotherfinaldetailVO.getCumIntaxPrice());
                        detailVO.setPastQuantity(consultotherfinaldetailVO.getPastQuantity());
                        detailVO.setUnitprice(consultotherfinaldetailVO.getUnitprice());
                        detailVO.setTaxUnitprice(consultotherfinaldetailVO.getTaxUnitprice());
                        detailVO.setCurExtaxPrice(BigDecimalUtils.ofNullable(detailVO.getQuantity()).multiply(BigDecimalUtils.ofNullable(detailVO.getUnitprice())));
                        detailVO.setCurIntaxPrice(BigDecimalUtils.ofNullable(detailVO.getQuantity()).multiply(BigDecimalUtils.ofNullable(detailVO.getTaxUnitprice())));
                        detailVO.setCumQuantity(consultotherfinaldetailVO.getPastQuantity().add(detailVO.getQuantity()));
                        detailVO.setAmounts(consultotherfinaldetailVO.getCumExtaxPrice().add(detailVO.getCurExtaxPrice()));
                        detailVO.setTaxAmounts(consultotherfinaldetailVO.getCumIntaxPrice().add(detailVO.getCurIntaxPrice()));
                    } else {
                        detailVO.setCumExtaxPrice(BigDecimal.ZERO);
                        detailVO.setCumIntaxPrice(BigDecimal.ZERO);
                        detailVO.setPastQuantity(BigDecimal.ZERO);
                        detailVO.setCumQuantity(detailVO.getPastQuantity().add(BigDecimalUtils.ofNullable(detailVO.getQuantity())));
                        detailVO.setAmounts(detailVO.getCumExtaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurExtaxPrice())));
                        detailVO.setTaxAmounts(detailVO.getCumIntaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurIntaxPrice())));
                    }
                } else {
                    detailVO.setCumExtaxPrice(BigDecimal.ZERO);
                    detailVO.setCumIntaxPrice(BigDecimal.ZERO);
                    detailVO.setPastQuantity(BigDecimal.ZERO);
                    detailVO.setCumQuantity(detailVO.getPastQuantity().add(BigDecimalUtils.ofNullable(detailVO.getQuantity())));
                    detailVO.setAmounts(detailVO.getCumExtaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurExtaxPrice())));
                    detailVO.setTaxAmounts(detailVO.getCumIntaxPrice().add(BigDecimalUtils.ofNullable(detailVO.getCurIntaxPrice())));
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/import3"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response, Long contractId, String date) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ConsultotherfinalodetailVO> successList = new ArrayList<ConsultotherfinalodetailVO>();
        ArrayList<ConsultotherfinalodetailVO> errorList = new ArrayList<ConsultotherfinalodetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Map<String, ConsultotherfinalodetailVO> map = this.service.queryConsultOtherDetailCumPastMap(contractId, date);
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal amountsB;
                BigDecimal unitPriceB;
                BigDecimal quantityB;
                StringBuilder errorsMsgBuilder = new StringBuilder();
                ConsultotherfinalodetailVO vo = new ConsultotherfinalodetailVO();
                List datas = (List)result.get(i);
                String expenseName = (String)datas.get(0);
                String unit = (String)datas.get(1);
                String quantity = (String)datas.get(2);
                String unitPrice = (String)datas.get(3);
                String unitTaxPrice = (String)datas.get(4);
                String amounts = (String)datas.get(5);
                String taxAmounts = (String)datas.get(6);
                String remarks = (String)datas.get(7);
                vo.setId(IdWorker.getId());
                vo.setExpenseName(expenseName);
                vo.setUnit(unit);
                vo.setRemarks(remarks);
                if (StringUtils.isNotBlank((CharSequence)quantity)) {
                    if (NumberUtil.isNumber((String)quantity)) {
                        vo.setoQuantity(new BigDecimal(quantity));
                    } else {
                        vo.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)unitPrice)) {
                    if (NumberUtil.isNumber((String)unitPrice)) {
                        vo.setoUnitPrice(new BigDecimal(unitPrice));
                    } else {
                        vo.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)unitTaxPrice)) {
                    if (NumberUtil.isNumber((String)unitTaxPrice)) {
                        vo.setoTaxUnitPrice(new BigDecimal(unitTaxPrice));
                    } else {
                        vo.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)amounts)) {
                    if (NumberUtil.isNumber((String)amounts)) {
                        vo.setCurExtaxPrice(new BigDecimal(amounts));
                    } else {
                        vo.setErrorMsg("\u9664\u7a0e\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u9664\u7a0e\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    quantityB = vo.getoQuantity();
                    unitPriceB = vo.getoUnitPrice();
                    if (quantityB != null && unitPriceB != null) {
                        amountsB = quantityB.multiply(unitPriceB);
                        vo.setCurExtaxPrice(amountsB);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)taxAmounts)) {
                    if (NumberUtil.isNumber((String)taxAmounts)) {
                        vo.setCurIntaxPrice(new BigDecimal(taxAmounts));
                    } else {
                        vo.setErrorMsg("\u542b\u7a0e\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u542b\u7a0e\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    quantityB = vo.getoQuantity();
                    unitPriceB = vo.getoTaxUnitPrice();
                    if (quantityB != null && unitPriceB != null) {
                        amountsB = quantityB.multiply(unitPriceB);
                        vo.setCurIntaxPrice(amountsB);
                    }
                }
                if (!map.isEmpty()) {
                    String key = vo.getExpenseName() + vo.getoUnitPrice().setScale(2, 4) + vo.getoTaxUnitPrice().setScale(2, 4);
                    ConsultotherfinalodetailVO consultotherfinalodetailVO = map.get(key);
                    if (consultotherfinalodetailVO != null) {
                        vo.setIsEditState("\u5426");
                        vo.setCumExtaxPrice(consultotherfinalodetailVO.getCumExtaxPrice());
                        vo.setCumIntaxPrice(consultotherfinalodetailVO.getCumIntaxPrice());
                        vo.setoTaxUnitPrice(consultotherfinalodetailVO.getoTaxUnitPrice());
                        vo.setoUnitPrice(consultotherfinalodetailVO.getoUnitPrice());
                        vo.setPastQuantity(consultotherfinalodetailVO.getPastQuantity());
                        vo.setCurExtaxPrice(BigDecimalUtils.ofNullable(vo.getoQuantity()).multiply(BigDecimalUtils.ofNullable(vo.getoUnitPrice())));
                        vo.setCurIntaxPrice(BigDecimalUtils.ofNullable(vo.getoQuantity()).multiply(BigDecimalUtils.ofNullable(vo.getoTaxUnitPrice())));
                        vo.setCumQuantity(consultotherfinalodetailVO.getPastQuantity().add(vo.getoQuantity()));
                        vo.setAmounts(consultotherfinalodetailVO.getCumExtaxPrice().add(vo.getCurExtaxPrice()));
                        vo.setTaxAmounts(consultotherfinalodetailVO.getCumIntaxPrice().add(vo.getCurIntaxPrice()));
                    } else {
                        vo.setCumExtaxPrice(BigDecimal.ZERO);
                        vo.setCumIntaxPrice(BigDecimal.ZERO);
                        vo.setPastQuantity(BigDecimal.ZERO);
                        vo.setCumQuantity(vo.getPastQuantity().add(vo.getoQuantity()));
                        vo.setAmounts(vo.getCumExtaxPrice().add(vo.getCurExtaxPrice()));
                        vo.setTaxAmounts(vo.getCumIntaxPrice().add(vo.getCurIntaxPrice()));
                    }
                } else {
                    vo.setCumExtaxPrice(BigDecimal.ZERO);
                    vo.setCumIntaxPrice(BigDecimal.ZERO);
                    vo.setPastQuantity(BigDecimal.ZERO);
                    vo.setCumQuantity(vo.getPastQuantity().add(vo.getoQuantity()));
                    vo.setAmounts(vo.getCumExtaxPrice().add(vo.getCurExtaxPrice()));
                    vo.setTaxAmounts(vo.getCumIntaxPrice().add(vo.getCurIntaxPrice()));
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void export(@RequestBody ConsultotherfinalVO consultotherfinalVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)consultotherfinalVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.consultotherfinaldetailService.list((Wrapper)queryWrapper);
        List voList = BeanMapper.mapList((Iterable)list, ConsultotherfinaldetailVO.class);
        ArrayList<ConsultotherfinaldetailVO> records = new ArrayList<ConsultotherfinaldetailVO>();
        for (ConsultotherfinaldetailVO vo : voList) {
            records.add(vo);
        }
        HashMap<String, ArrayList<ConsultotherfinaldetailVO>> beans = new HashMap<String, ArrayList<ConsultotherfinaldetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("consultotherfinaldetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportFromPage(@RequestBody List<ConsultotherfinaldetailVO> list, HttpServletResponse response) {
        ArrayList<ConsultotherfinaldetailVO> records = new ArrayList<ConsultotherfinaldetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ConsultotherfinaldetailVO vo = list.get(i);
                String source = vo.getSource();
                if ("1".equals(source)) {
                    source = "\u5408\u540c\u5185";
                } else if ("2".equals(source)) {
                    source = "\u5408\u540c\u5916";
                }
                vo.setSource(source);
                records.add(vo);
            }
        }
        HashMap<String, ArrayList<ConsultotherfinaldetailVO>> beans = new HashMap<String, ArrayList<ConsultotherfinaldetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("consultotherfinaldetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/export3"}, method={RequestMethod.POST})
    @ResponseBody
    public void export3(@RequestBody ConsultotherfinalVO vo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)vo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.consultotherfinalodetailService.list((Wrapper)queryWrapper);
        List vOList = BeanMapper.mapList((Iterable)list, ConsultotherfinalodetailVO.class);
        if (!CollectionUtil.isEmpty((Collection)vOList)) {
            for (int i = 0; i < vOList.size(); ++i) {
                ConsultotherfinalodetailVO linevo = (ConsultotherfinalodetailVO)((Object)vOList.get(i));
                linevo.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vOList);
        ExcelExport.getInstance().export("consultotherfinalodetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportFromPage3"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportFromPage3(@RequestBody List<ConsultotherfinalodetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ConsultotherfinalodetailVO vo = list.get(i);
                vo.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<ConsultotherfinalodetailVO>> beans = new HashMap<String, List<ConsultotherfinalodetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consultotherfinalodetail-export.xlsx", beans, response);
    }
}

