/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseSettlementEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementFinalizedEntity;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.service.IDesignSettlementService;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementService;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseSettlementService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementFinalizedService;
import com.ejianc.business.settlementmanage.vo.LaborCostRequestDetailVO;
import com.ejianc.business.settlementmanage.vo.LaborCostRequestVO;
import com.ejianc.business.settlementmanage.vo.LaborCostVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/costmanage/"})
public class CostManageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPurchaseSettlementService iMaterialPurchaseSettlementService;
    @Autowired
    private IMachinerySettlementService iMachinerySettlementService;
    @Autowired
    private ISettlementFinalizedService settlementFinalizedService;
    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;
    @Autowired
    private IDesignSettlementService designSettlementService;
    @Autowired
    private IConsultotherfinalService consultotherfinalService;

    @RequestMapping(value={"queryCostaccountPartmaterial"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountPartmaterial(Long projectId, String time) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.le((Object)"create_time", (Object)time);
        List list = this.iMaterialPurchaseSettlementService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            MaterialPurchaseSettlementEntity MaterialPurchaseSettlement = (MaterialPurchaseSettlementEntity)((Object)list.get(i));
            if (MaterialPurchaseSettlement.getIntaxSummaryAmount() == null) continue;
            total = total.add(MaterialPurchaseSettlement.getIntaxSummaryAmount());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"queryCostaccountMechanical"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryCostaccountMechanical(Long projectId, String time) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.le((Object)"create_time", (Object)time);
        List list = this.iMachinerySettlementService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            MachinerySettlementEntity MachinerySettlement = (MachinerySettlementEntity)((Object)list.get(i));
            if (MachinerySettlement.getIntaxMonthlyAmount() == null) continue;
            total = total.add(MachinerySettlement.getIntaxMonthlyAmount());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"queryProjectreportSettlement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryProjectreportSettlement(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        List list = this.settlementFinalizedService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            SettlementFinalizedEntity SettlementFinalized = (SettlementFinalizedEntity)((Object)list.get(i));
            if (SettlementFinalized.getSettlementValue() == null) continue;
            total = total.add(SettlementFinalized.getSettlementValue());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"querySettlementBookStatement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> querySettlementBookStatement(Long projectId, String code, String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"listing_code", (Object)code);
        queryWrapper.eq((Object)"part_project_name", (Object)name);
        List list = this.settlementBookStatementDetailService.list((Wrapper)queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailEntity SettlementBookStatementDetailEntity2 = (SettlementBookStatementDetailEntity)((Object)list.get(i));
            if (SettlementBookStatementDetailEntity2.getQuantities() == null && SettlementBookStatementDetailEntity2.getIntaxUnitprice() == null && SettlementBookStatementDetailEntity2.getIntaxAddition() == null) continue;
            total = total.add(SettlementBookStatementDetailEntity2.getQuantities());
            total = total.add(SettlementBookStatementDetailEntity2.getIntaxUnitprice());
            total = total.add(SettlementBookStatementDetailEntity2.getIntaxAddition());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)total);
    }

    @RequestMapping(value={"queryLabor"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, LaborCostVO>> queryLabor(@RequestBody LaborCostRequestVO laborCostRequestVO) throws ParseException {
        int i;
        List<LaborCostVO> vo1;
        HashMap<String, LaborCostVO> map = new HashMap<String, LaborCostVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        Date time = sdf.parse(laborCostRequestVO.getReportingTime());
        String date = sdf1.format(time);
        if (laborCostRequestVO.getStatus() == null && laborCostRequestVO.getList().size() > 0) {
            for (LaborCostRequestDetailVO entity : laborCostRequestVO.getList()) {
                LaborCostVO vo = this.settlementBookStatementDetailService.getEngineering(laborCostRequestVO.getContractType(), laborCostRequestVO.getProjectId(), entity.getSubitemCode(), entity.getSection(), date);
                map.put(entity.getSubitemCode() + entity.getSection(), vo);
            }
            vo1 = this.settlementBookStatementDetailService.getSum(laborCostRequestVO.getContractType(), laborCostRequestVO.getProjectId(), date);
            for (i = 0; i < vo1.size(); ++i) {
                if (vo1.get(i).getCode().equals("\u6750\u6599\u8282\u8d85")) {
                    map.put("\u6750\u6599\u8282\u8d85", vo1.get(i));
                }
                if (!vo1.get(i).getCode().equals("\u5176\u4ed6\u6263\u6b3e")) continue;
                map.put("\u5176\u4ed6\u6263\u6b3e", vo1.get(i));
            }
        }
        if (laborCostRequestVO.getStatus() != null && laborCostRequestVO.getStatus().equals("0")) {
            vo1 = this.settlementBookStatementDetailService.getSum(laborCostRequestVO.getContractType(), laborCostRequestVO.getProjectId(), date);
            for (i = 0; i < vo1.size(); ++i) {
                if (vo1.get(i).getCode().equals("\u6750\u6599\u8282\u8d85")) {
                    map.put("\u6750\u6599\u8282\u8d85", vo1.get(i));
                }
                if (!vo1.get(i).getCode().equals("\u5176\u4ed6\u6263\u6b3e")) continue;
                map.put("\u5176\u4ed6\u6263\u6b3e", vo1.get(i));
            }
        }
        this.logger.info("\u8fd4\u56de\u6570\u636e=" + ((Object)map).toString());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f!", map);
    }

    @RequestMapping(value={"queryDesignSettlement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryDesignSettlement(@RequestParam(value="projectId") Long projectId, @RequestParam(value="monthStr") String monthStr) {
        BigDecimal curExtaxPrice = this.designSettlementService.queryDesignSettlement(projectId, monthStr);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f!", (Object)curExtaxPrice);
    }

    @RequestMapping(value={"queryConsultotherfinal"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryConsultotherfinal(@RequestParam(value="projectId") Long projectId, @RequestParam(value="monthStr") String monthStr) {
        BigDecimal bigDecimal = this.consultotherfinalService.queryConsultotherfinal(projectId, monthStr);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f!", (Object)bigDecimal);
    }

    @RequestMapping(value={"queryStatementAll"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<LaborCostVO>> queryStatementAll(@RequestParam String projectId, @RequestParam String contractType, @RequestParam String time) {
        List<LaborCostVO> statementAll = this.settlementBookStatementDetailService.getStatementAll(projectId, contractType, time);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", statementAll);
    }
}

