/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookStatementExport"})
public class ExcelSettlementBookStatementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;
    @Autowired
    private IOutcontractApi outcontractApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    List<SettlementBookStatementDetailVO> detailVOList = new ArrayList<SettlementBookStatementDetailVO>();

    @RequestMapping(value={"/exportStateFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        ArrayList<SettlementBookStatementDetailVO> records = new ArrayList<SettlementBookStatementDetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if (statementDetailVO.getChildren() == null || statementDetailVO.getChildren().size() <= 0) continue;
                this.splitList(statementDetailVO.getChildren(), records);
            }
        }
        HashMap<String, ArrayList<SettlementBookStatementDetailVO>> beans = new HashMap<String, ArrayList<SettlementBookStatementDetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    private void splitList(List<SettlementBookStatementDetailVO> list, List<SettlementBookStatementDetailVO> records) {
        for (SettlementBookStatementDetailVO vo : list) {
            String source = vo.getSource();
            if ("1".equals(source)) {
                source = "\u5408\u540c\u5185";
            } else if ("2".equals(source)) {
                source = "\u5408\u540c\u5916";
            }
            vo.setSource(source);
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/exportStateFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.statementDetailService.list((Wrapper)queryWrapper);
        List statementDetailVOList = BeanMapper.mapList((Iterable)list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = (SettlementBookStatementDetailVO)((Object)statementDetailVOList.get(i));
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/stateExcelDown"})
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SettlementBookStatementDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u6e05\u5355\u7ed3\u7b97\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/statementExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId, String detailVOS, boolean isExport) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        List<SettlementBookStatementDetailVO> successList = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList errorList = new ArrayList();
        HashMap<String, BigDecimal> excelMap = new HashMap<String, BigDecimal>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        boolean flag = true;
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                String inndeCode = (String)datas.get(0) + "_" + (String)datas.get(1) + "_" + (String)datas.get(7) + "_" + (String)datas.get(8);
                String thisEngineeringQuantity = datas.get(12) != null && datas.get(12) != "" ? (String)datas.get(12) : "0";
                excelMap.put(inndeCode, new BigDecimal(thisEngineeringQuantity));
            }
        }
        List detailList = JSONArray.parseArray((String)detailVOS, SettlementBookStatementDetailVO.class);
        ArrayList<SettlementBookStatementDetailVO> pcList = new ArrayList<SettlementBookStatementDetailVO>();
        Iterator i = detailList.iterator();
        while (i.hasNext()) {
            Object vo;
            vo.setIntaxAddition((vo = (SettlementBookStatementDetailVO)((Object)i.next())).getIntaxAddition() != null ? vo.getIntaxAddition() : BigDecimal.ZERO);
            vo.setExtaxAddition(vo.getExtaxAddition() != null ? vo.getExtaxAddition() : BigDecimal.ZERO);
            vo.setThisAmountsTax(vo.getThisAmountsTax() != null ? vo.getThisAmountsTax() : BigDecimal.ZERO);
            vo.setThisAmountsNotax(vo.getThisAmountsNotax() != null ? vo.getThisAmountsNotax() : BigDecimal.ZERO);
            vo.setChildren(null);
            pcList.add((SettlementBookStatementDetailVO)((Object)vo));
        }
        for (Object vo : pcList) {
            String code = vo.getListingCode() + "_" + vo.getSection() + "_" + vo.getInsettlementUnitprice() + "_" + vo.getExsettlementUnitprice();
            if (!excelMap.containsKey(code)) continue;
            vo.setThisEngineeringQuantity((BigDecimal)excelMap.get(code));
            vo.setThisAmountsTax(ComputeUtil.safeMultiply((BigDecimal)vo.getInsettlementUnitprice(), (BigDecimal)vo.getThisEngineeringQuantity()));
            vo.setThisAmountsNotax(ComputeUtil.safeMultiply((BigDecimal)vo.getExsettlementUnitprice(), (BigDecimal)vo.getThisEngineeringQuantity()));
            vo.setQuantities(ComputeUtil.safeAdd((BigDecimal)vo.getCumulativeEngineeringQuantity(), (BigDecimal)vo.getThisEngineeringQuantity()));
            vo.setIntaxAddition(ComputeUtil.safeAdd((BigDecimal)vo.getAccruingAmountsTax(), (BigDecimal)vo.getThisAmountsTax()));
            vo.setExtaxAddition(ComputeUtil.safeAdd((BigDecimal)vo.getAccruingAmountsNotax(), (BigDecimal)vo.getThisAmountsNotax()));
        }
        List successTpids = pcList.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
        for (SettlementBookStatementDetailVO vo : pcList) {
            List lastDetails;
            vo.setId(IdWorker.getId());
            List<SettlementBookStatementDetailVO> detailVOList = this.getDetailByPidPlanCsf(vo.getTid(), pcList);
            if (CollectionUtils.isNotEmpty(detailVOList) && CollectionUtils.isNotEmpty(lastDetails = detailVOList.stream().filter(s -> !successTpids.contains(s.getTid())).collect(Collectors.toList()))) {
                vo.setThisEngineeringQuantity(null);
                vo.setQuantities(null);
                vo.setIntaxUnitprice(null);
                vo.setExtaxUnitprice(null);
                vo.setInsettlementUnitprice(null);
                vo.setExsettlementUnitprice(null);
                vo.setThisAmountsTax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setThisAmountsNotax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setIntaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getIntaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setExtaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getExtaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            detailVOList.clear();
        }
        successList = pcList;
        successList = ExcelSettlementBookStatementController.createTreeData(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)pcList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<SettlementBookStatementDetailVO> getDetailByPidPlanCsf(String tid, List<SettlementBookStatementDetailVO> list) {
        for (SettlementBookStatementDetailVO vo : list) {
            if (tid == null || !tid.equals(vo.getTpid())) continue;
            this.getDetailByPidPlanCsf(vo.getTid(), list);
            this.detailVOList.add(vo);
        }
        return this.detailVOList;
    }

    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            SettlementBookStatementDetailVO settlementBookStatementDetailVO = vos.get(i);
            String innercode = settlementBookStatementDetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                settlementBookStatementDetailVO.setTpid(pid.toString());
                continue;
            }
            settlementBookStatementDetailVO.setTpid("");
        }
        return vos;
    }

    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        ArrayList<SettlementBookStatementDetailVO> resp = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SettlementBookStatementDetailVO> listMap = new HashMap<String, SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = (SettlementBookStatementDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SettlementBookStatementDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }
}

