/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.settlementmanage.bean.MaterialSettleEntity;
import com.ejianc.business.settlementmanage.mapper.MaterialSettleMapper;
import com.ejianc.business.settlementmanage.service.IMaterialSettleService;
import com.ejianc.business.settlementmanage.vo.MaterialSettleDetailVO;
import com.ejianc.business.settlementmanage.vo.MaterialSettleVO;
import com.ejianc.foundation.middlemeasurement.api.IPurchasesettlementApi;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialSettleService")
public class MaterialSettleServiceImpl
extends BaseServiceImpl<MaterialSettleMapper, MaterialSettleEntity>
implements IMaterialSettleService {
    private static final String BILL_CODE = "settlemanage_material_settle";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPurchasesettlementApi purchasesettlementApi;
    @Autowired
    private IOutcontractApi outcontractApi;

    @Override
    public MaterialSettleVO saveOrUpdate(MaterialSettleVO materialSettleVO) {
        MaterialSettleEntity entity = (MaterialSettleEntity)((Object)BeanMapper.map((Object)((Object)materialSettleVO), MaterialSettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)materialSettleVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        MaterialSettleVO vo = (MaterialSettleVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialSettleVO.class));
        return vo;
    }

    @Override
    public MaterialSettleVO queryDetail(Long id) {
        MaterialSettleEntity entity = (MaterialSettleEntity)((Object)this.selectById(id));
        MaterialSettleVO vo = (MaterialSettleVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialSettleVO.class));
        return vo;
    }

    @Override
    public MaterialSettleVO queryMidDataByCont(Long contractId, Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MaterialSettleEntity::getContractId, (Object)contractId);
        queryWrapper.ne(null != id, BaseEntity::getId, (Object)id);
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u6700\u7ec8\u7ed3\u7b97\u5355\uff01");
        }
        MaterialSettleVO materialSettleVO = new MaterialSettleVO();
        CommonResponse commonResponse = this.purchasesettlementApi.queryListByCont(contractId);
        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
            List purchaseList = (List)commonResponse.getData();
            ArrayList<PurchasesettlementVO> result = new ArrayList<PurchasesettlementVO>();
            for (PurchasesettlementVO settleVO : purchaseList) {
                if (!settleVO.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !settleVO.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u4e2d\u95f4\u8ba1\u91cf\u5355\uff01");
                }
                result.add(settleVO);
            }
            BigDecimal sumMny = BigDecimal.ZERO;
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            ArrayList<MaterialSettleDetailVO> detailVOList = new ArrayList<MaterialSettleDetailVO>();
            for (PurchasesettlementVO settleVO : result) {
                sumMny = ComputeUtil.safeAdd((BigDecimal)sumMny, (BigDecimal)settleVO.getMeasureCost());
                for (PurchasesettlementdetailVO purchaseDetailVO : settleVO.getPurchasesettlementdetailEntities()) {
                    sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)purchaseDetailVO.getSettlementAmount());
                    sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)purchaseDetailVO.getTaxSettlementAmount());
                    MaterialSettleDetailVO settleDetailVO = (MaterialSettleDetailVO)((Object)BeanMapper.map((Object)purchaseDetailVO, MaterialSettleDetailVO.class));
                    settleDetailVO.setSource(String.valueOf(purchaseDetailVO.getId()));
                    settleDetailVO.setSourceType(1);
                    settleDetailVO.setCreateTime(null);
                    settleDetailVO.setCreateUserCode(null);
                    settleDetailVO.setUpdateTime(null);
                    settleDetailVO.setUpdateUserCode(null);
                    settleDetailVO.setVersion(1);
                    settleDetailVO.setId(null);
                    settleDetailVO.setSettleCode(settleVO.getBillCode());
                    settleDetailVO.setSettleDate(settleVO.getOccurrenceTime());
                    settleDetailVO.setMaterialCode(purchaseDetailVO.getBillCode());
                    settleDetailVO.setMaterialName(purchaseDetailVO.getBillName());
                    settleDetailVO.setRowState("add");
                    detailVOList.add(settleDetailVO);
                }
            }
            materialSettleVO = (MaterialSettleVO)((Object)BeanMapper.map(result.get(0), MaterialSettleVO.class));
            materialSettleVO.setId(null);
            materialSettleVO.setCreateTime(null);
            materialSettleVO.setCreateUserCode(null);
            materialSettleVO.setUpdateTime(null);
            materialSettleVO.setUpdateUserCode(null);
            materialSettleVO.setBillCode(null);
            materialSettleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            materialSettleVO.setSumMeasureSettleMny(sumMny);
            materialSettleVO.setSumSettleMny(sumSettleMny);
            materialSettleVO.setSumSettleTaxMny(sumSettleTaxMny);
            materialSettleVO.setDetailList(detailVOList);
        } else {
            CommonResponse response = this.outcontractApi.queryDetail(contractId);
            OutcontractVO outcontractVO = (OutcontractVO)response.getData();
            materialSettleVO.setContractId(outcontractVO.getId());
            materialSettleVO.setContractCode(outcontractVO.getBillCode());
            materialSettleVO.setContractName(outcontractVO.getContractName());
            materialSettleVO.setProjectId(outcontractVO.getProjectId());
            materialSettleVO.setProjectName(outcontractVO.getProjectName());
            materialSettleVO.setOrgId(outcontractVO.getOrgId());
            materialSettleVO.setOrgName(outcontractVO.getOrgName());
            materialSettleVO.setProjectDepartmentId(outcontractVO.getProjectDepartmentId());
            materialSettleVO.setSupplierId(outcontractVO.getSupplier());
            materialSettleVO.setSupplierName(outcontractVO.getSupplierName());
            materialSettleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        if (null != id) {
            MaterialSettleEntity materialSettleEntity = (MaterialSettleEntity)((Object)this.selectById(id));
            materialSettleVO.setId(materialSettleEntity.getId());
            materialSettleVO.setCreateTime(materialSettleEntity.getCreateTime());
            materialSettleVO.setCreateUserCode(materialSettleEntity.getCreateUserCode());
            materialSettleVO.setUpdateTime(materialSettleEntity.getUpdateTime());
            materialSettleVO.setUpdateUserCode(materialSettleEntity.getUpdateUserCode());
            materialSettleVO.setBillCode(materialSettleEntity.getBillCode());
            materialSettleVO.setVersion(materialSettleEntity.getVersion());
            materialSettleVO.setTenantId(materialSettleEntity.getTenantId());
        }
        return materialSettleVO;
    }
}

