package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookSummaryDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookSummaryDetailService;
import com.ejianc.business.settlementmanage.utils.MonthUtil;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookSumVo;
import com.ejianc.business.settlementmanage.vo.SubDetailVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping("/api/settlementBookStatementDetail")
public class SettlementBookApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookService settlementBookService;//工程分包结算书主表service

    @Autowired
    private ISettlementBookStatementDetailService settlementBookStatementDetailService;//工程分包结算书子表-程量清单结算表service

    @Autowired
    private ISettlementBookSummaryDetailService iSettlementBookSummaryDetailService;//工程分包结算书子表-汇总表

    /**
     * @Description queryActualCost
     * <p>
     * 使用：成本管理-项目月度成本分析报告-子表本期实际成本
     * 数据来源：结算管理-工程分包结算书-工程量清单结算表
     */
    @RequestMapping(value = "/queryActualCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SettlementBookStatementDetailVO>> queryActualCost(Long projectId, String subitemCode, String section, String reportingMonth) {
        List<SettlementBookStatementDetailVO> resList = new ArrayList<>();

        if (StringUtils.isBlank(reportingMonth)) {
            return CommonResponse.error("报告月份为空！");
        }

        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);

            QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("project_id", projectId);
            queryWrapper.eq("dr", 0);
            queryWrapper.in("bill_state", "1", "3");
            queryWrapper.ge("create_time", firstDay);
            queryWrapper.le("create_time", lastDay);
            List<SettlementBookEntity> mList = settlementBookService.list(queryWrapper);

            if (mList != null && mList.size() > 0) {
                Map<String, SettlementBookStatementDetailVO> detailMap = new HashMap<>();
                for (SettlementBookEntity item :
                        mList) {
                    //合同类型
                    String contractType = item.getContractType();
                    if ("劳务分包".equals(contractType)) {
                        QueryWrapper<SettlementBookStatementDetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq("mid", item.getId());
                        statementDetailQueryWrapper.eq("listing_code", subitemCode);
                        statementDetailQueryWrapper.eq("section", section);
                        statementDetailQueryWrapper.eq("dr", 0);
                        List<SettlementBookStatementDetailEntity> detailList = settlementBookStatementDetailService.list(statementDetailQueryWrapper);

                        if (detailList != null && detailList.size() > 0) {
                            for (int i = 0; i < detailList.size(); i++) {
                                //从map获取月度（中间）计量计价明细表，如果为空，把service查回的数据放进map，否则，用map的数据和查回的相加
                                SettlementBookStatementDetailVO mapDetailVo = detailMap.get(subitemCode + section);
                                SettlementBookStatementDetailVO settlementBookStatementDetailVO = new SettlementBookStatementDetailVO();
                                SettlementBookStatementDetailEntity detailEntity = detailList.get(i);
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                SettlementBookStatementDetailVO detailVO = BeanMapper.map(detailEntity, SettlementBookStatementDetailVO.class);
                                //resList.add(detailVO);

                                if(mapDetailVo == null){
                                    detailMap.put(subitemCode + section,detailVO);
                                }else {
                                    BigDecimal mapExamineQuantity = mapDetailVo.getThisEngineeringQuantity() == null ? new BigDecimal(0) : mapDetailVo.getThisEngineeringQuantity();
                                    BigDecimal mapExamineAmounts = mapDetailVo.getThisAmountsNotax() == null ? new BigDecimal(0) : mapDetailVo.getThisAmountsNotax();
                                    BigDecimal mapExamineTaxAmounts = mapDetailVo.getThisAmountsTax() == null ? new BigDecimal(0): mapDetailVo.getThisAmountsTax();

                                    BigDecimal thisEngineeringQuantity = detailEntity.getThisEngineeringQuantity();
                                    BigDecimal thisAmountsNotax = detailEntity.getThisAmountsNotax();//原来的除税金额
                                    BigDecimal thisAmountsTax = detailEntity.getThisAmountsTax();//原来的含税金额

                                    BigDecimal examineQuantityTotal = thisEngineeringQuantity.add(mapExamineQuantity);//汇总的数量
                                    BigDecimal examineAmountsTotal = thisAmountsNotax.add(mapExamineAmounts);//除税金额
                                    BigDecimal examineTaxAmountsTotal = thisAmountsTax.add(mapExamineTaxAmounts);////含税金额
                                    settlementBookStatementDetailVO.setThisEngineeringQuantity(examineQuantityTotal);
                                    settlementBookStatementDetailVO.setThisAmountsNotax(examineAmountsTotal);
                                    settlementBookStatementDetailVO.setThisAmountsTax(examineTaxAmountsTotal);

                                    if(examineQuantityTotal.intValue() != 0){
                                        BigDecimal examineUnitprice = examineAmountsTotal.divide(examineQuantityTotal, 8, BigDecimal.ROUND_HALF_UP);
                                        BigDecimal examineTaxUnitprice = examineTaxAmountsTotal.divide(examineQuantityTotal, 8, BigDecimal.ROUND_HALF_UP);
                                        settlementBookStatementDetailVO.setExtaxUnitprice(examineUnitprice);//除税单价
                                        settlementBookStatementDetailVO.setIntaxUnitprice(examineTaxUnitprice);//含税单价);
                                    }

                                    detailMap.put(subitemCode + section,settlementBookStatementDetailVO);
                                }
                            }
                        }
                    } else if ("专业分包".equals(contractType)) {
                        QueryWrapper<SettlementBookStatementDetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq("mid", item.getId());
                        statementDetailQueryWrapper.eq("listing_code", subitemCode);
                        statementDetailQueryWrapper.eq("section", section);
                        statementDetailQueryWrapper.eq("dr", 0);
                        List<SettlementBookStatementDetailEntity> detailList = settlementBookStatementDetailService.list(statementDetailQueryWrapper);

                        if (detailList != null && detailList.size() > 0) {
                            for (int i = 0; i < detailList.size(); i++) {
                                SettlementBookStatementDetailEntity detailEntity = detailList.get(i);
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                SettlementBookStatementDetailVO detailVO = BeanMapper.map(detailEntity, SettlementBookStatementDetailVO.class);
                                resList.add(detailVO);
                            }
                        }

                    }
                }
                Iterator<Map.Entry<String, SettlementBookStatementDetailVO>> iterator = detailMap.entrySet().iterator();
                while (iterator.hasNext()){
                    Map.Entry<String, SettlementBookStatementDetailVO> next = iterator.next();
                    SettlementBookStatementDetailVO valueVo = next.getValue();
                    resList.add(valueVo);
                }

            }
        }

        return CommonResponse.success("查询详情数据成功！", resList);
    }


    /**
     * @Description queryActualCost
     * <p>
     * 使用：成本管理-项目月度成本分析报告-子表人工费本期实际成本
     * 数据来源：结算管理-工程分包结算书-汇总表
     */
    @RequestMapping(value = "/queryActualSumCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementBookSumVo> queryActualSumCost(Long projectId, String reportingMonth) {
        BigDecimal total = new BigDecimal("0.00");
        SettlementBookSumVo settlementBookSumVo = new SettlementBookSumVo();
        if (StringUtils.isBlank(reportingMonth)) {
            return CommonResponse.error("报告月份为空！");
        }

        String[] strArr = reportingMonth.split("-");
        if (strArr.length > 1) {
            String year = strArr[0];
            String month = strArr[1];
            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
            String lastDay = MonthUtil.getLastDayOfMonth(year, month);

            QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("project_id", projectId);
            queryWrapper.eq("dr", 0);
            queryWrapper.in("bill_state", "1", "3");
            queryWrapper.ge("create_time", firstDay);
            queryWrapper.le("create_time", lastDay);
            List<SettlementBookEntity> mList = settlementBookService.list(queryWrapper);

            if (mList != null && mList.size() > 0) {
                for (SettlementBookEntity item :
                        mList) {
                    String contractType = item.getContractType();
                    QueryWrapper<SettlementBookSummaryDetailEntity> statementDetailQueryWrappers = new QueryWrapper();
                    statementDetailQueryWrappers.eq("mid", item.getId());
                    statementDetailQueryWrappers.eq("dr", 0);
                    List<SettlementBookSummaryDetailEntity> detailList2 = iSettlementBookSummaryDetailService.list(statementDetailQueryWrappers);
                    if (detailList2.size() > 0 && detailList2 != null) {
                        BigDecimal intaxPrice = detailList2.get(4).getIntaxPrice();//材料节超
                        BigDecimal intaxPrice1 = detailList2.get(6).getIntaxPrice();//扣甲供材
                        BigDecimal intaxPrice2 = detailList2.get(7).getIntaxPrice();//扣水电费
                        BigDecimal intaxPrice3 = detailList2.get(8).getIntaxPrice();//其他扣款
                        BigDecimal intaxPrice4 = intaxPrice.add(intaxPrice1);
                        BigDecimal intaxPrice5 = intaxPrice4.add(intaxPrice2);
                        BigDecimal intaxPrice6 = intaxPrice5.add(intaxPrice3);
                        // BigDecimal intaxPrice7 = intaxPrice6.add(intaxPrice4);
                        total = total.add(intaxPrice6);
                        settlementBookSumVo.setId(item.getId());
                        settlementBookSumVo.setTotal(total);
                        settlementBookSumVo.setContractType(contractType);
                        SettlementBookSumVo detailVO = BeanMapper.map(settlementBookSumVo, SettlementBookSumVo.class);

                    }
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！", settlementBookSumVo);
    }

    @RequestMapping(value = "/getAccruingAmountsTax", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubDetailVo> getAccruingAmountsTax(@RequestParam(value = "projectId") Long projectId, @RequestParam Date reportingMonth) {
        QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String month = sdf.format(reportingMonth);
        //当月
        String start = month.substring(0, 7) + "-01";
        //当月最后一天
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(month.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(month.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf1.format(cal.getTime());
        queryWrapper.le("create_time", end);
        queryWrapper.ge("create_time", start);
        queryWrapper.in("bill_state", 1, 3);
        List<SettlementBookEntity> list = settlementBookService.list(queryWrapper);
        BigDecimal total = new BigDecimal(0.00);
        BigDecimal noTaxTotal = new BigDecimal(0.00);
        SubDetailVo subDetailVo = new SubDetailVo();
        if (!list.isEmpty() && list.size() > 0) {
            for (SettlementBookEntity settlementBookEntity : list) {
                QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("mid", settlementBookEntity.getId());
                queryWrapper1.in("bill_state", 1, 3);
                List<SettlementBookStatementDetailEntity> list1 = settlementBookStatementDetailService.list(queryWrapper1);
                if (!list1.isEmpty() && list1.size() > 0) {
                    for (SettlementBookStatementDetailEntity settlementBookStatementDetailEntity : list1) {
                        //本次报量金额 含税
                        BigDecimal thisAmountsTax = settlementBookStatementDetailEntity.getThisAmountsTax();
                        BigDecimal thisAmountsNotax = settlementBookStatementDetailEntity.getThisAmountsNotax();
                        if (thisAmountsTax != null) {
                            total = total.add(thisAmountsTax);
                        }
                        if (thisAmountsNotax != null) {
                            noTaxTotal = noTaxTotal.add(thisAmountsNotax);
                        }
                    }
                }
            }
        }
        subDetailVo.setThisAmountsTax(total);
        subDetailVo.setThisAmountsNotax(noTaxTotal);
        return CommonResponse.success("查询成功", subDetailVo);
    }

    /**
     * 间计量——分包月度报量及申请报告——工程分包结算书生成之后，不允许再做分包月度报量
     */
    @RequestMapping(value = "queryContractIds", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Integer> queryContractIds(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<SettlementBookEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr", 0);
        //无论结算单状态，只要该合同下存在结算单就不允许新增分包中间计量
        //queryWrapper.in("bill_state", 1, 3);
        List<SettlementBookEntity> settlementBookEntityList = settlementBookService.list(queryWrapper);
        Integer total = 0;
        if(settlementBookEntityList.size() > 0){
          total = 1;
        }else{
            total = 0;
        }
        return CommonResponse.success("查询数据成功", total);
    }

}
