package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MaterialPurchaseSettlementEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookMaterialDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.SettlementBookMapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookService;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;

/**
 * 工程分包结算书-主表
 *
 * @author generator
 *
 */
@Service("settlementBookService")
public class SettlementBookServiceImpl extends BaseServiceImpl<SettlementBookMapper, SettlementBookEntity> implements ISettlementBookService{
    @Resource
    private ISettlementBookService service;
    @Autowired
    private ISettlementBookMaterialDetailService materialDetailService;
    @Autowired
    private ISettlementBookOtherDetailService otherDetailService;
    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;
    @Autowired
    private SettlementBookMapper settlementBookMapper;

    @Override
    public SettlementBookEntity checkMaterialAndOtherFromSubcontractingvolume(SettlementBookEntity entity) {
        Map<String, SettlementBookMaterialDetailVO> materialMap =
                materialDetailService.querySubcontractingvolumeMaterialByContractId(entity.getContractId());
        for (SettlementBookMaterialDetailEntity settlementBookMaterialDetailEntity : entity.getSettlementBookMaterialDetailEntities()) {
            String key = settlementBookMaterialDetailEntity.getBillCode() +
                    settlementBookMaterialDetailEntity.getSectionB() +
                    settlementBookMaterialDetailEntity.getExtaxPurchasingprice().setScale(2, RoundingMode.HALF_UP) +
                    settlementBookMaterialDetailEntity.getIntaxPurchasingprice().setScale(2,RoundingMode.HALF_UP);
            SettlementBookMaterialDetailVO settlementBookMaterialDetailVO = materialMap.get(key);
            if (settlementBookMaterialDetailVO != null){
            //    证明是带过来的数 这时需要比较有没有修改 如果修改则需要将这条数据做标记
            //   保存数据的节超量
                BigDecimal sectionNumB = settlementBookMaterialDetailEntity.getSectionNum() == null ? BigDecimal.ZERO : settlementBookMaterialDetailEntity.getSectionNum();
                //带过来的原始的节超量
                BigDecimal sectionNumBOriginal = settlementBookMaterialDetailVO.getSectionNum() == null ? BigDecimal.ZERO : settlementBookMaterialDetailVO.getSectionNum();
                if (!sectionNumB.equals(sectionNumBOriginal)){
                //    比较两个节超量的数值有变化 证明有修改 所以标记这条数据
                }
            }else {
            //    证明数据是新增的 这时无需比较  直接标记这条数据即可
            }
        }
        Map<String, SettlementBookOtherDetailVO> otherDetailVOMap =
                otherDetailService.querySubcontractingvolumeOtherByContractId(entity.getContractId());
        for (SettlementBookOtherDetailEntity settlementBookOtherDetailEntity : entity.getSettlementBookOtherDetailEntities()) {
            String key = settlementBookOtherDetailEntity.getWithholdingOther() +
                    settlementBookOtherDetailEntity.getDeductionsName() +
                    settlementBookOtherDetailEntity.getExtaxUnitpriceC().setScale(2, RoundingMode.HALF_UP) +
                    settlementBookOtherDetailEntity.getIntaxPriceC().setScale(2,RoundingMode.HALF_UP);
            SettlementBookOtherDetailVO settlementBookOtherDetailVO = otherDetailVOMap.get(key);
            if (settlementBookOtherDetailVO != null){
                //证明是带过来的数 这时需要比较有没有修改 如果修改则需要将这条数据做标记
                //保存数据的数量字段

            }else {
                //证明数据是新增的 这时无需比较 直接标记这条数据即可
            }
        }
        return entity;
    }

    @Override
    public SettlementBookEntity totalForm(SettlementBookEntity entity) {
        //汇总清单结算子表的含税金额和除税金额
        Map<String, BigDecimal> map = statementDetailService.totalForm(entity.getSettlementBookStatementDetailEntities());
        //汇总物资节超扣款子表含税金额和除税金额
        Map<String, BigDecimal> materialMap = materialDetailService.totalForm(entity.getSettlementBookMaterialDetailEntities());
        //汇总其他扣款子表含税金额和除税金额
        Map<String, BigDecimal> otherMap = otherDetailService.totalForm(entity.getSettlementBookOtherDetailEntities());
        //表头审定除税金额 = 清单结算子表除税金额汇总 - 物资节超扣款子表汇总除税金额 - 其他扣款子表汇总除税金额
        BigDecimal amount = map.get("amount").subtract(materialMap.get("amount")).subtract(otherMap.get("amount"));
        //表头审定含税金额 = 清单结算子表含税金额汇总 - 物资节超扣款子表汇总含税金额 - 其他扣款子表汇总含税金额
        BigDecimal taxAmount = map.get("taxAmount").subtract(materialMap.get("taxAmount")).subtract(otherMap.get("taxAmount"));
        entity.setReportExamount(amount);
        entity.setReportInamount(taxAmount);
        return entity;
    }
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<SettlementBookEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( order_month, '%Y-%m' )",monthStr);
        List<SettlementBookEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (SettlementBookEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<SettlementBookEntity> query = new LambdaQueryWrapper<SettlementBookEntity>()
                .eq(SettlementBookEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(order_month, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(SettlementBookEntity::getIsSettlement)
                        .or().eq(SettlementBookEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("工程分包结算书有往期未归集的数据");
        LambdaQueryWrapper<SettlementBookEntity> query1 = new LambdaQueryWrapper<SettlementBookEntity>()
                .eq(SettlementBookEntity::getProjectId, projectId)
                .ne(SettlementBookEntity::getBillState, 3)
                .ne(SettlementBookEntity::getBillState, 1)
                .apply("DATE_FORMAT(order_month, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("工程分包结算书有本期审批未通过的数据");
        return true;
    }
}
