package com.ejianc.business.settlementmanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSetDetailEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSetDetailService;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.TurnoverLeaseSettlementMapper;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSettlementEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转租赁结算-主表
 * 
 * @author generator
 * 
 */
@Service("turnoverLeaseSettlementService")
public class TurnoverLeaseSettlementServiceImpl extends BaseServiceImpl<TurnoverLeaseSettlementMapper, TurnoverLeaseSettlementEntity> implements ITurnoverLeaseSettlementService{

    @Autowired
    private TurnoverLeaseSettlementMapper turnoverLeaseSettlementMapper;
    @Autowired
    private ITurnoverLeaseSetDetailService turnoverLeaseSetDetailService;


//    @Override
//    public List<TurnoverLeaseSetDetailVO> queryDetailList(String settlementDate, Long projectId, Long contractId) {
//        List<TurnoverLeaseSetDetailVO> turnoverLeaseSetDetailVOS = turnoverLeaseSettlementMapper.queryDetailList(settlementDate,projectId,contractId);
//        if(CollectionUtils.isNotEmpty(turnoverLeaseSetDetailVOS)){
//            for(TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO :turnoverLeaseSetDetailVOS ){
//                turnoverLeaseSetDetailVO.setLesseeTotalprice(ComputeUtil.safeMultiply(new BigDecimal(turnoverLeaseSetDetailVO.getLesseeQuantity()),new BigDecimal(turnoverLeaseSetDetailVO.getLesseeTerm()),turnoverLeaseSetDetailVO.getLesseeTotalprice()));
//                turnoverLeaseSetDetailVO.setTaxLesseeTotalprice(ComputeUtil.safeMultiply(new BigDecimal(turnoverLeaseSetDetailVO.getLesseeQuantity()),new BigDecimal(turnoverLeaseSetDetailVO.getLesseeTerm()),turnoverLeaseSetDetailVO.getTaxLesseeUnitprice()));
//                turnoverLeaseSetDetailVO.setId(IdWorker.getId());
//            }
//        }
//        return  turnoverLeaseSetDetailVOS;
//    }

    @Override
    public int updateIsFlag(List<Long> sourceIdList) {
        return turnoverLeaseSettlementMapper.updateIsFlag(sourceIdList);
    }

    @Override
    public int updateFlag(List<Long> sourceIdList) {
        return turnoverLeaseSettlementMapper.updateFlag(sourceIdList);
    }

    @Override
    public List<TurnoverLeaseSetDetailVO> queryIsFlag(List<Long> sourceIdList) {
        return turnoverLeaseSettlementMapper.queryIsFlag(sourceIdList);
    }

    @Override
    public JSONObject getDataById(Long contractId) {
        //查询出该项目项所有中间计量数据
        List<TurnoverLeaseSetDetailVO> turnoverLeaseSetDetailVOS = turnoverLeaseSettlementMapper.queryDetailList(contractId);

        if (CollectionUtils.isNotEmpty(turnoverLeaseSetDetailVOS)){
            //父级数据
            List<TurnoverLeaseSetDetailVO> parentList = turnoverLeaseSetDetailVOS.stream().filter(s -> s.getLesseeQuantity() == null).collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(TurnoverLeaseSetDetailVO::getInnercode))), ArrayList::new)
            );
            Map<String, TurnoverLeaseSetDetailVO> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(parentList)){
                map = parentList.stream().collect(Collectors.toMap(TurnoverLeaseSetDetailVO::getInnercode, Function.identity()));
            }

            //末级数据
            List<TurnoverLeaseSetDetailVO> childList = turnoverLeaseSetDetailVOS.stream().filter(s -> s.getLesseeQuantity() != null).collect(Collectors.toList());
            parentList.addAll(childList);
            if (CollectionUtils.isNotEmpty(parentList)){
                parentList.forEach(s->s.setTid(String.valueOf(IdWorker.getId())));
                for (TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO : parentList){
                    turnoverLeaseSetDetailVO.setId(IdWorker.getId());
                    String innercode = turnoverLeaseSetDetailVO.getInnercode();
                    String[] innercodeSubArr = innercode.split("_");
                    String innercodeSub = "";
                    String sectionSuf = "";
                    if (innercodeSubArr.length > 1) {
                        innercodeSub = innercodeSubArr[0];
                        sectionSuf = "_" + innercodeSubArr[1];
                    }

                    Long pid = null;
                    if (innercodeSub.length() == 2) {
                        //最上级
                    } else if (innercodeSub.length() == 4) {
                        String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                        //有父节点
                        pid = this.setPid(pcode, map);

                    } else if (innercodeSub.length() == 6) {
                        String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                        //有父节点
                        pid = this.setPid(pcode, map);
                    } else if (innercodeSub.length() > 6) {
                        String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                        //有父节点
                        pid = this.setPid(pcode, map);
                    }

                    if (pid != null) {
                        turnoverLeaseSetDetailVO.setTpid(pid.toString());
                    } else {
                        turnoverLeaseSetDetailVO.setTpid("");
                    }
                }
                parentList = handleChildren(parentList);
                JSONObject json = new JSONObject();
                json.put("dataSource", parentList);
                return json;
            }

        }
        return null;
    }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<TurnoverLeaseSetDetailVO> handleChildren(List<TurnoverLeaseSetDetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<TurnoverLeaseSetDetailVO>() {
            @Override
            public int compare(TurnoverLeaseSetDetailVO o1, TurnoverLeaseSetDetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });

        //获取子集,汇总数据
        List<String> tpidList = voList.stream().map(TurnoverLeaseSetDetailVO::getTpid).collect(Collectors.toList());
        for(TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO : voList){
            List<TurnoverLeaseSetDetailVO> detailByPid = getDetailByPid(turnoverLeaseSetDetailVO.getTid(), voList);

            if (CollectionUtils.isNotEmpty(detailByPid)){
                turnoverLeaseSetDetailVO.setEndTime(null);
//                租赁合价
                BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity()!= null).map(TurnoverLeaseSetDetailVO::getLesseeTotalprice)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxLesseeTotalprice)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
//                赔偿金额
                BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getCompensateAccount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxCompensateAccount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                //清理维修费非等其他费用(元)
                BigDecimal otherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getOtherExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxOtherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxOtherExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                //本期结算费用
                BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getMonthlyExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxMonthlyExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                turnoverLeaseSetDetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
                turnoverLeaseSetDetailVO.setLesseeTotalprice(lesseeTotalprice);
                turnoverLeaseSetDetailVO.setCompensateAccount(compensateAccount);
                turnoverLeaseSetDetailVO.setTaxCompensateAccount(taxCompensateAccount);
                turnoverLeaseSetDetailVO.setTaxOtherExpenses(taxOtherExpenses);
                turnoverLeaseSetDetailVO.setOtherExpenses(otherExpenses);
                turnoverLeaseSetDetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
                turnoverLeaseSetDetailVO.setMonthlyExpenses(monthlyExpenses);
                subList.clear();
            }
        }
        //构建树
        voList = createTreeData(voList);


        return voList;
    }
    public static List<TurnoverLeaseSetDetailVO> createTreeData(List<TurnoverLeaseSetDetailVO> list) {
        List<TurnoverLeaseSetDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, TurnoverLeaseSetDetailVO> listMap = new HashMap<>();
        for (TurnoverLeaseSetDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            TurnoverLeaseSetDetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            TurnoverLeaseSetDetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<TurnoverLeaseSetDetailVO> child = (List<TurnoverLeaseSetDetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<TurnoverLeaseSetDetailVO> children = new ArrayList<TurnoverLeaseSetDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
    List<TurnoverLeaseSetDetailVO> subList = new ArrayList<>();
    private List<TurnoverLeaseSetDetailVO> getDetailByPid(String tid, List<TurnoverLeaseSetDetailVO> list) {

        for (TurnoverLeaseSetDetailVO subcontractingvolumedetailVO : list) {
            if (tid != null && tid.equals(subcontractingvolumedetailVO.getTpid())) {
                getDetailByPid(subcontractingvolumedetailVO.getTid(), list);
                subList.add(subcontractingvolumedetailVO);
            }
        }
        return subList;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, TurnoverLeaseSetDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }
}
