package com.ejianc.business.settlementmanage.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.settlementmanage.bean.DesignSettlementDetailEntity;
import com.ejianc.business.settlementmanage.bean.DesignSettlementUnitDetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 设计类结算单-主表
 *
 * @author generator
 *
 */
public class DesignSettlementVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractName; // 合同名称
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.String contractorsUnit; // 承包单位
    private java.lang.String behalf; // 结算代表
    private java.lang.String phone; // 联系电话
    private java.lang.String contractPricing; // 合同计价方式
    private java.lang.String contraactCode; // 合同编码
    private java.math.BigDecimal originalContracts; // 原合同额
    private java.math.BigDecimal subcontractAmount; // 分包报审金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date sendingDate; // 送签日期
    private java.lang.Long agentId; // 经办人ID
    private java.lang.String agentName; // 经办人名称
    private java.math.BigDecimal intaxDeclareAmount; // 申报含税总价金额
    private java.math.BigDecimal extaxDeclareAmount; // 申报除税总价金额
    private java.math.BigDecimal intaxReviewTotalPrice; // 审核含税总价金额
    private java.math.BigDecimal extaxReviewTotalPrice; // 审核除税总价金额
    private java.lang.String listingCode; // 清单编码
    private java.lang.String remarks; // 备注
    private java.lang.String units; // 设计单位
    private java.lang.Long agentDepartment; // 经办人部门
    private java.lang.Long designUnitsId; // 设计单位id
    private java.lang.Long contractorsUnitId; // 承包单位id
    private java.lang.String designUnits; // 设计单位
    private java.lang.String designAddress; // 设计地址
    private java.lang.String enterpriseNature; // 企业性质
    private java.lang.String legal; // 法人代表
    private java.lang.String designPhone; // 设计单位联系电话
    private java.lang.String idcardNumber; // 身份证号码
    private java.lang.String designContent; // 设计内容
    private java.lang.String projectAuditor; // 项目审核人
    private java.lang.String projectAuditorSignature; // 项目审核人签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date projectAuditorDate; // 项目审核人审核时间
    private java.lang.String projectDesignDirector; // 项目设计总监
    private java.lang.String projectDesignDirectorSignature; // 项目设计总监签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date projectDesignDirectorDate; // 项目设计总监审核时间
    private java.lang.String projectGeneral; // 项目总工
    private java.lang.String projectGeneralSignature; // 项目总工签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date projectGeneralDate; // 项目总工审核时间
    private java.lang.String projectBusinessManager; // 项目商务经理
    private java.lang.String projectBusinessManagerSignature; // 项目商务经理签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date projectBusinessManagerDate; // 项目商务经理审核时间
    private java.lang.Double taxAmount; // 初审不含税金额
    private java.lang.Double tax; // 初审税金
    private java.lang.Double levied; // 初审价税合计
    private java.lang.String projectManager; // 项目经理
    private java.lang.String projectManagerSignature; // 项目经理签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date projectManagerDate; // 项目经理审核时间
    private java.lang.String settlementRepresentative; // 结算代表
    private java.lang.String settlementRepresentativeSignature; // 结算代表签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date settlementRepresentativeDate; // 结算代表审核时间
    private java.lang.String commerce; // 所属单位商务部
    private java.lang.String commerceSignature; // 所属单位商务部签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date commerceDate; // 所属单位商务部审核时间
    private java.lang.String commerceManager; // 所属单位商务部总经理
    private java.lang.String commerceManagerSignature; // 所属单位商务部总经理签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date commerceManagerDate; // 所属单位商务部总经理审核时间
    private java.lang.String financial; // 所属单位财务资金部总经理
    private java.lang.String financialSignature; // 所属单位财务资金部总经理签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date financialDate; // 所属单位财务资金部总经理审核时间
    private java.lang.String institute; //所属单位设计院分管领导
    private java.lang.String instituteSignature; // 所属单位设计院分管领导签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date instituteDate; // 所属单位设计院分管领导审核时间
    private java.lang.String leadership; //所属单位商务部分管领导
    private java.lang.String leadershipSignature; // 所属单位商务部分管领导签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date leadershipDate; // 所属单位商务部分管领导审核时间
    private java.lang.String subcontractRepresentative; // 分包结算代表最终确认（终审）
    private java.lang.String subcontractRepresentativeSignature; // 分包结算代表最终确认（终审）签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date subcontractRepresentativeDate; // 分包结算代表最终确认（终审）审核时间
    private List<DesignSettlementDetailEntity> designSettlementDetailEntities = new ArrayList<>(); // 设计类结算单子表-设计工程量验收、核算清单
    private List<DesignSettlementUnitDetailEntity> designSettlementUnitDetailEntities = new ArrayList<>(); // 设计类结算单子表-设计单位
    private java.lang.String createTimeShow;
    private java.lang.String billStateStr;
    private Integer isSettlement; // 是否归集状态 0 未归集 1 归集


    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 承包单位
     */
    public java.lang.String getContractorsUnit() {
        return contractorsUnit;
    }

    /**
     * 承包单位
     */
    public void setContractorsUnit(java.lang.String contractorsUnit) {
        this.contractorsUnit = contractorsUnit;
    }
    /**
     * 结算代表
     */
    public java.lang.String getBehalf() {
        return behalf;
    }

    /**
     * 结算代表
     */
    public void setBehalf(java.lang.String behalf) {
        this.behalf = behalf;
    }
    /**
     * 联系电话
     */
    public java.lang.String getPhone() {
        return phone;
    }

    /**
     * 联系电话
     */
    public void setPhone(java.lang.String phone) {
        this.phone = phone;
    }
    /**
     * 合同计价方式
     */
    public java.lang.String getContractPricing() {
        return contractPricing;
    }

    /**
     * 合同计价方式
     */
    public void setContractPricing(java.lang.String contractPricing) {
        this.contractPricing = contractPricing;
    }
    /**
     * 合同编码
     */
    public java.lang.String getContraactCode() {
        return contraactCode;
    }

    /**
     * 合同编码
     */
    public void setContraactCode(java.lang.String contraactCode) {
        this.contraactCode = contraactCode;
    }
    /**
     * 原合同额
     */
    public java.math.BigDecimal getOriginalContracts() {
        return originalContracts;
    }

    /**
     * 原合同额
     */
    public void setOriginalContracts(java.math.BigDecimal originalContracts) {
        this.originalContracts = originalContracts;
    }
    /**
     * 分包报审金额
     */
    public java.math.BigDecimal getSubcontractAmount() {
        return subcontractAmount;
    }

    /**
     * 分包报审金额
     */
    public void setSubcontractAmount(java.math.BigDecimal subcontractAmount) {
        this.subcontractAmount = subcontractAmount;
    }
    /**
     * 送签日期
     */
    public Date getSendingDate() {
        return sendingDate;
    }


    /**
     * 送签日期
     */
    public void setSendingDate(Date sendingDate) {
        this.sendingDate = sendingDate;
    }
    /**
     * 经办人ID
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人ID
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人名称
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 申报含税总价金额
     */
    public java.math.BigDecimal getIntaxDeclareAmount() {
        return intaxDeclareAmount;
    }

    /**
     * 申报含税总价金额
     */
    public void setIntaxDeclareAmount(java.math.BigDecimal intaxDeclareAmount) {
        this.intaxDeclareAmount = intaxDeclareAmount;
    }
    /**
     * 申报除税总价金额
     */
    public java.math.BigDecimal getExtaxDeclareAmount() {
        return extaxDeclareAmount;
    }

    /**
     * 申报除税总价金额
     */
    public void setExtaxDeclareAmount(java.math.BigDecimal extaxDeclareAmount) {
        this.extaxDeclareAmount = extaxDeclareAmount;
    }
    /**
     * 审核含税总价金额
     */
    public java.math.BigDecimal getIntaxReviewTotalPrice() {
        return intaxReviewTotalPrice;
    }

    /**
     * 审核含税总价金额
     */
    public void setIntaxReviewTotalPrice(java.math.BigDecimal intaxReviewTotalPrice) {
        this.intaxReviewTotalPrice = intaxReviewTotalPrice;
    }
    /**
     * 审核除税总价金额
     */
    public java.math.BigDecimal getExtaxReviewTotalPrice() {
        return extaxReviewTotalPrice;
    }

    /**
     * 审核除税总价金额
     */
    public void setExtaxReviewTotalPrice(java.math.BigDecimal extaxReviewTotalPrice) {
        this.extaxReviewTotalPrice = extaxReviewTotalPrice;
    }
    /**
     * 清单编码
     */
    public java.lang.String getListingCode() {
        return listingCode;
    }

    /**
     * 清单编码
     */
    public void setListingCode(java.lang.String listingCode) {
        this.listingCode = listingCode;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 设计单位
     */
    public java.lang.String getUnits() {
        return units;
    }

    /**
     * 设计单位
     */
    public void setUnits(java.lang.String units) {
        this.units = units;
    }
    /**
     * 经办人部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public java.lang.Long getAgentDepartment() {
        return agentDepartment;
    }

    /**
     * 经办人部门
     */
    @ReferDeserialTransfer
    public void setAgentDepartment(java.lang.Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }
    /**
     * 设计单位
     */
    public java.lang.String getDesignUnits() {
        return designUnits;
    }

    /**
     * 设计单位
     */
    public void setDesignUnits(java.lang.String designUnits) {
        this.designUnits = designUnits;
    }
    /**
     * 设计地址
     */
    public java.lang.String getDesignAddress() {
        return designAddress;
    }

    /**
     * 设计地址
     */
    public void setDesignAddress(java.lang.String designAddress) {
        this.designAddress = designAddress;
    }
    /**
     * 企业性质
     */
    public java.lang.String getEnterpriseNature() {
        return enterpriseNature;
    }

    /**
     * 企业性质
     */
    public void setEnterpriseNature(java.lang.String enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    /**
     * 法人代表
     */
    public java.lang.String getLegal() {
        return legal;
    }

    /**
     * 法人代表
     */
    public void setLegal(java.lang.String legal) {
        this.legal = legal;
    }
    /**
     * 设计单位联系电话
     */
    public java.lang.String getDesignPhone() {
        return designPhone;
    }

    /**
     * 设计单位联系电话
     */
    public void setDesignPhone(java.lang.String designPhone) {
        this.designPhone = designPhone;
    }
    /**
     * 身份证号码
     */
    public java.lang.String getIdcardNumber() {
        return idcardNumber;
    }

    /**
     * 身份证号码
     */
    public void setIdcardNumber(java.lang.String idcardNumber) {
        this.idcardNumber = idcardNumber;
    }
    /**
     * 设计内容
     */
    public java.lang.String getDesignContent() {
        return designContent;
    }

    /**
     * 设计内容
     */
    public void setDesignContent(java.lang.String designContent) {
        this.designContent = designContent;
    }
    /**
     * 项目审核人
     */
    public java.lang.String getProjectAuditor() {
        return projectAuditor;
    }

    /**
     * 项目审核人
     */
    public void setProjectAuditor(java.lang.String projectAuditor) {
        this.projectAuditor = projectAuditor;
    }
    /**
     * 项目审核人签字
     */
    public java.lang.String getProjectAuditorSignature() {
        return projectAuditorSignature;
    }

    /**
     * 项目审核人签字
     */
    public void setProjectAuditorSignature(java.lang.String projectAuditorSignature) {
        this.projectAuditorSignature = projectAuditorSignature;
    }
    /**
     * 项目审核人审核时间
     */
    public java.util.Date getProjectAuditorDate() {
        return projectAuditorDate;
    }

    /**
     * 项目审核人审核时间
     */
    public void setProjectAuditorDate(java.util.Date projectAuditorDate) {
        this.projectAuditorDate = projectAuditorDate;
    }
    /**
     * 项目设计总监
     */
    public java.lang.String getProjectDesignDirector() {
        return projectDesignDirector;
    }

    /**
     * 项目设计总监
     */
    public void setProjectDesignDirector(java.lang.String projectDesignDirector) {
        this.projectDesignDirector = projectDesignDirector;
    }
    /**
     * 项目设计总监签字
     */
    public java.lang.String getProjectDesignDirectorSignature() {
        return projectDesignDirectorSignature;
    }

    /**
     * 项目设计总监签字
     */
    public void setProjectDesignDirectorSignature(java.lang.String projectDesignDirectorSignature) {
        this.projectDesignDirectorSignature = projectDesignDirectorSignature;
    }
    /**
     * 项目设计总监审核时间
     */
    public java.util.Date getProjectDesignDirectorDate() {
        return projectDesignDirectorDate;
    }

    /**
     * 项目设计总监审核时间
     */
    public void setProjectDesignDirectorDate(java.util.Date projectDesignDirectorDate) {
        this.projectDesignDirectorDate = projectDesignDirectorDate;
    }
    /**
     * 项目总工
     */
    public java.lang.String getProjectGeneral() {
        return projectGeneral;
    }

    /**
     * 项目总工
     */
    public void setProjectGeneral(java.lang.String projectGeneral) {
        this.projectGeneral = projectGeneral;
    }
    /**
     * 项目总工签字
     */
    public java.lang.String getProjectGeneralSignature() {
        return projectGeneralSignature;
    }

    /**
     * 项目总工签字
     */
    public void setProjectGeneralSignature(java.lang.String projectGeneralSignature) {
        this.projectGeneralSignature = projectGeneralSignature;
    }
    /**
     * 项目总工审核时间
     */
    public java.util.Date getProjectGeneralDate() {
        return projectGeneralDate;
    }

    /**
     * 项目总工审核时间
     */
    public void setProjectGeneralDate(java.util.Date projectGeneralDate) {
        this.projectGeneralDate = projectGeneralDate;
    }
    /**
     * 项目商务经理
     */
    public java.lang.String getProjectBusinessManager() {
        return projectBusinessManager;
    }

    /**
     * 项目商务经理
     */
    public void setProjectBusinessManager(java.lang.String projectBusinessManager) {
        this.projectBusinessManager = projectBusinessManager;
    }
    /**
     * 项目商务经理签字
     */
    public java.lang.String getProjectBusinessManagerSignature() {
        return projectBusinessManagerSignature;
    }

    /**
     * 项目商务经理签字
     */
    public void setProjectBusinessManagerSignature(java.lang.String projectBusinessManagerSignature) {
        this.projectBusinessManagerSignature = projectBusinessManagerSignature;
    }
    /**
     * 项目商务经理审核时间
     */
    public java.util.Date getProjectBusinessManagerDate() {
        return projectBusinessManagerDate;
    }

    /**
     * 项目商务经理审核时间
     */
    public void setProjectBusinessManagerDate(java.util.Date projectBusinessManagerDate) {
        this.projectBusinessManagerDate = projectBusinessManagerDate;
    }
    /**
     * 初审不含税金额
     */
    public java.lang.Double getTaxAmount() {
        return taxAmount;
    }

    /**
     * 初审不含税金额
     */
    public void setTaxAmount(java.lang.Double taxAmount) {
        this.taxAmount = taxAmount;
    }
    /**
     * 初审税金
     */
    public java.lang.Double getTax() {
        return tax;
    }

    /**
     * 初审税金
     */
    public void setTax(java.lang.Double tax) {
        this.tax = tax;
    }
    /**
     * 初审价税合计
     */
    public java.lang.Double getLevied() {
        return levied;
    }

    /**
     * 初审价税合计
     */
    public void setLevied(java.lang.Double levied) {
        this.levied = levied;
    }
    /**
     * 项目经理
     */
    public java.lang.String getProjectManager() {
        return projectManager;
    }

    /**
     * 项目经理
     */
    public void setProjectManager(java.lang.String projectManager) {
        this.projectManager = projectManager;
    }
    /**
     * 项目经理签字
     */
    public java.lang.String getProjectManagerSignature() {
        return projectManagerSignature;
    }

    /**
     * 项目经理签字
     */
    public void setProjectManagerSignature(java.lang.String projectManagerSignature) {
        this.projectManagerSignature = projectManagerSignature;
    }
    /**
     * 项目经理审核时间
     */
    public java.util.Date getProjectManagerDate() {
        return projectManagerDate;
    }

    /**
     * 项目经理审核时间
     */
    public void setProjectManagerDate(java.util.Date projectManagerDate) {
        this.projectManagerDate = projectManagerDate;
    }
    /**
     * 结算代表
     */
    public java.lang.String getSettlementRepresentative() {
        return settlementRepresentative;
    }

    /**
     * 结算代表
     */
    public void setSettlementRepresentative(java.lang.String settlementRepresentative) {
        this.settlementRepresentative = settlementRepresentative;
    }
    /**
     * 结算代表签字
     */
    public java.lang.String getSettlementRepresentativeSignature() {
        return settlementRepresentativeSignature;
    }

    /**
     * 结算代表签字
     */
    public void setSettlementRepresentativeSignature(java.lang.String settlementRepresentativeSignature) {
        this.settlementRepresentativeSignature = settlementRepresentativeSignature;
    }
    /**
     * 结算代表审核时间
     */
    public java.util.Date getSettlementRepresentativeDate() {
        return settlementRepresentativeDate;
    }

    /**
     * 结算代表审核时间
     */
    public void setSettlementRepresentativeDate(java.util.Date settlementRepresentativeDate) {
        this.settlementRepresentativeDate = settlementRepresentativeDate;
    }
    /**
     * 所属单位商务部
     */
    public java.lang.String getCommerce() {
        return commerce;
    }

    /**
     * 所属单位商务部
     */
    public void setCommerce(java.lang.String commerce) {
        this.commerce = commerce;
    }
    /**
     * 所属单位商务部签字
     */
    public java.lang.String getCommerceSignature() {
        return commerceSignature;
    }

    /**
     * 所属单位商务部签字
     */
    public void setCommerceSignature(java.lang.String commerceSignature) {
        this.commerceSignature = commerceSignature;
    }
    /**
     * 所属单位商务部审核时间
     */
    public java.util.Date getCommerceDate() {
        return commerceDate;
    }

    /**
     * 所属单位商务部审核时间
     */
    public void setCommerceDate(java.util.Date commerceDate) {
        this.commerceDate = commerceDate;
    }
    /**
     * 所属单位商务部总经理
     */
    public java.lang.String getCommerceManager() {
        return commerceManager;
    }

    /**
     * 所属单位商务部总经理
     */
    public void setCommerceManager(java.lang.String commerceManager) {
        this.commerceManager = commerceManager;
    }
    /**
     * 所属单位商务部总经理签字
     */
    public java.lang.String getCommerceManagerSignature() {
        return commerceManagerSignature;
    }

    /**
     * 所属单位商务部总经理签字
     */
    public void setCommerceManagerSignature(java.lang.String commerceManagerSignature) {
        this.commerceManagerSignature = commerceManagerSignature;
    }
    /**
     * 所属单位商务部总经理审核时间
     */
    public java.util.Date getCommerceManagerDate() {
        return commerceManagerDate;
    }

    /**
     * 所属单位商务部总经理审核时间
     */
    public void setCommerceManagerDate(java.util.Date commerceManagerDate) {
        this.commerceManagerDate = commerceManagerDate;
    }
    /**
     * 所属单位财务资金部总经理
     */
    public java.lang.String getFinancial() {
        return financial;
    }

    /**
     * 所属单位财务资金部总经理
     */
    public void setFinancial(java.lang.String financial) {
        this.financial = financial;
    }
    /**
     * 所属单位财务资金部总经理签字
     */
    public java.lang.String getFinancialSignature() {
        return financialSignature;
    }

    /**
     * 所属单位财务资金部总经理签字
     */
    public void setFinancialSignature(java.lang.String financialSignature) {
        this.financialSignature = financialSignature;
    }
    /**
     * 所属单位财务资金部总经理审核时间
     */
    public java.util.Date getFinancialDate() {
        return financialDate;
    }

    /**
     * 所属单位财务资金部总经理审核时间
     */
    public void setFinancialDate(java.util.Date financialDate) {
        this.financialDate = financialDate;
    }
    /**
     *
     所属单位设计院分管领导
     */
    public java.lang.String getInstitute() {
        return institute;
    }

    /**
     *
     所属单位设计院分管领导
     */
    public void setInstitute(java.lang.String institute) {
        this.institute = institute;
    }
    /**
     * 所属单位设计院分管领导签字
     */
    public java.lang.String getInstituteSignature() {
        return instituteSignature;
    }

    /**
     * 所属单位设计院分管领导签字
     */
    public void setInstituteSignature(java.lang.String instituteSignature) {
        this.instituteSignature = instituteSignature;
    }
    /**
     * 所属单位设计院分管领导审核时间
     */
    public java.util.Date getInstituteDate() {
        return instituteDate;
    }

    /**
     * 所属单位设计院分管领导审核时间
     */
    public void setInstituteDate(java.util.Date instituteDate) {
        this.instituteDate = instituteDate;
    }
    /**
     *
     所属单位商务部分管领导
     */
    public java.lang.String getLeadership() {
        return leadership;
    }

    /**
     *
     所属单位商务部分管领导
     */
    public void setLeadership(java.lang.String leadership) {
        this.leadership = leadership;
    }
    /**
     * 所属单位商务部分管领导签字
     */
    public java.lang.String getLeadershipSignature() {
        return leadershipSignature;
    }

    /**
     * 所属单位商务部分管领导签字
     */
    public void setLeadershipSignature(java.lang.String leadershipSignature) {
        this.leadershipSignature = leadershipSignature;
    }
    /**
     * 所属单位商务部分管领导审核时间
     */
    public java.util.Date getLeadershipDate() {
        return leadershipDate;
    }

    /**
     * 所属单位商务部分管领导审核时间
     */
    public void setLeadershipDate(java.util.Date leadershipDate) {
        this.leadershipDate = leadershipDate;
    }
    /**
     * 分包结算代表最终确认（终审）
     */
    public java.lang.String getSubcontractRepresentative() {
        return subcontractRepresentative;
    }

    /**
     * 分包结算代表最终确认（终审）
     */
    public void setSubcontractRepresentative(java.lang.String subcontractRepresentative) {
        this.subcontractRepresentative = subcontractRepresentative;
    }
    /**
     * 分包结算代表最终确认（终审）签字
     */
    public java.lang.String getSubcontractRepresentativeSignature() {
        return subcontractRepresentativeSignature;
    }

    /**
     * 分包结算代表最终确认（终审）签字
     */
    public void setSubcontractRepresentativeSignature(java.lang.String subcontractRepresentativeSignature) {
        this.subcontractRepresentativeSignature = subcontractRepresentativeSignature;
    }
    /**
     * 分包结算代表最终确认（终审）审核时间
     */
    public java.util.Date getSubcontractRepresentativeDate() {
        return subcontractRepresentativeDate;
    }

    /**
     * 分包结算代表最终确认（终审）审核时间
     */
    public void setSubcontractRepresentativeDate(java.util.Date subcontractRepresentativeDate) {
        this.subcontractRepresentativeDate = subcontractRepresentativeDate;
    }

    public List<DesignSettlementDetailEntity> getDesignSettlementDetailEntities() {
        return designSettlementDetailEntities;
    }

    public void setDesignSettlementDetailEntities(List<DesignSettlementDetailEntity> designSettlementDetailEntities) {
        this.designSettlementDetailEntities = designSettlementDetailEntities;
    }

    public List<DesignSettlementUnitDetailEntity> getDesignSettlementUnitDetailEntities() {
        return designSettlementUnitDetailEntities;
    }

    public void setDesignSettlementUnitDetailEntities(List<DesignSettlementUnitDetailEntity> designSettlementUnitDetailEntities) {
        this.designSettlementUnitDetailEntities = designSettlementUnitDetailEntities;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    @ReferSerialTransfer(referCode="support-supplier")

    public Long getDesignUnitsId() {
        return designUnitsId;
    }
    @ReferDeserialTransfer
    public void setDesignUnitsId(Long designUnitsId) {
        this.designUnitsId = designUnitsId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getContractorsUnitId() {
        return contractorsUnitId;
    }
    @ReferDeserialTransfer
    public void setContractorsUnitId(Long contractorsUnitId) {
        this.contractorsUnitId = contractorsUnitId;
    }

    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }
}
