package com.ejianc.business.settlementmanage.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 结算责任书评审主表
 *
 * @author generator
 *
 */
public class SettlementResponsibilityVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.String agentName; // 经办人
    private java.lang.String contractName; // 合同名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date actualCommencementDate; // 实际开工日期
    private java.lang.String actualCommencementDateStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date actualCompletionDate; // 实际竣工日期
    private java.lang.String actualCompletionDateStr;
    private java.math.BigDecimal contractPrice; // 合同造价
    private java.math.BigDecimal expectCost; // 预计成本
    private java.math.BigDecimal expectSettlementValue; // 预计结算值
    private java.math.BigDecimal expectProfitMargin; // 预计利润率
    private java.math.BigDecimal surrenderRate; // 项目管理目标责任书总和上缴利润率
    private java.lang.String remarks; // 备注
    private java.lang.Long agentId; // 经办人id
    private java.lang.Long agentDepartment; // 经办人部门
    private java.lang.Long contractId; // 合同id
    private java.lang.String createTimeShow; // 创建时间文本显示
    private java.lang.String billStateStr; // 单据状态Str
    private java.lang.Long originalId;
    private BigDecimal settlementBasicValue; // 结算基本值
    private BigDecimal settlementHopeValue; // 结算期望值
    private BigDecimal profitOvertopBasicval; // 提成高于基本值%
    private BigDecimal profitOvertopHopeval; // 提成高于期望值%

    public BigDecimal getSettlementBasicValue() {
        return settlementBasicValue;
    }

    public void setSettlementBasicValue(BigDecimal settlementBasicValue) {
        this.settlementBasicValue = settlementBasicValue;
    }

    public BigDecimal getSettlementHopeValue() {
        return settlementHopeValue;
    }

    public void setSettlementHopeValue(BigDecimal settlementHopeValue) {
        this.settlementHopeValue = settlementHopeValue;
    }

    public BigDecimal getProfitOvertopBasicval() {
        return profitOvertopBasicval;
    }

    public void setProfitOvertopBasicval(BigDecimal profitOvertopBasicval) {
        this.profitOvertopBasicval = profitOvertopBasicval;
    }

    public BigDecimal getProfitOvertopHopeval() {
        return profitOvertopHopeval;
    }

    public void setProfitOvertopHopeval(BigDecimal profitOvertopHopeval) {
        this.profitOvertopHopeval = profitOvertopHopeval;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer

    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 经办人
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 实际开工日期
     */
    public java.util.Date getActualCommencementDate() {
        return actualCommencementDate;
    }

    /**
     * 实际开工日期
     */
    public void setActualCommencementDate(java.util.Date actualCommencementDate) {
        this.actualCommencementDate = actualCommencementDate;
    }
    /**
     * 实际竣工日期
     */
    public java.util.Date getActualCompletionDate() {
        return actualCompletionDate;
    }

    /**
     * 实际竣工日期
     */
    public void setActualCompletionDate(java.util.Date actualCompletionDate) {
        this.actualCompletionDate = actualCompletionDate;
    }
    /**
     * 合同造价
     */
    public java.math.BigDecimal getContractPrice() {
        return contractPrice;
    }

    /**
     * 合同造价
     */
    public void setContractPrice(java.math.BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    /**
     * 预计成本
     */
    public java.math.BigDecimal getExpectCost() {
        return expectCost;
    }

    /**
     * 预计成本
     */
    public void setExpectCost(java.math.BigDecimal expectCost) {
        this.expectCost = expectCost;
    }
    /**
     * 预计结算值
     */
    public java.math.BigDecimal getExpectSettlementValue() {
        return expectSettlementValue;
    }

    /**
     * 预计结算值
     */
    public void setExpectSettlementValue(java.math.BigDecimal expectSettlementValue) {
        this.expectSettlementValue = expectSettlementValue;
    }
    /**
     * 预计利润率
     */
    public java.math.BigDecimal getExpectProfitMargin() {
        return expectProfitMargin;
    }

    /**
     * 预计利润率
     */
    public void setExpectProfitMargin(java.math.BigDecimal expectProfitMargin) {
        this.expectProfitMargin = expectProfitMargin;
    }
    /**
     * 项目管理目标责任书总和上缴利润率
     */
    public java.math.BigDecimal getSurrenderRate() {
        return surrenderRate;
    }

    /**
     * 项目管理目标责任书总和上缴利润率
     */
    public void setSurrenderRate(java.math.BigDecimal surrenderRate) {
        this.surrenderRate = surrenderRate;
    }

    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer

    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public java.lang.Long getAgentDepartment() {
        return agentDepartment;
    }

    /**
     * 经办人部门
     */
    @ReferDeserialTransfer

    public void setAgentDepartment(java.lang.Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-incontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer

    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }

    public String getActualCommencementDateStr() {
        return actualCommencementDateStr;
    }

    public void setActualCommencementDateStr(String actualCommencementDateStr) {
        this.actualCommencementDateStr = actualCommencementDateStr;
    }

    public String getActualCompletionDateStr() {
        return actualCompletionDateStr;
    }

    public void setActualCompletionDateStr(String actualCompletionDateStr) {
        this.actualCompletionDateStr = actualCompletionDateStr;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }
}
