/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.SettlementFinalizedEntity;
import com.ejianc.business.settlementmanage.service.ISettlementCountersignService;
import com.ejianc.business.settlementmanage.service.ISettlementFinalizedService;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.business.settlementmanage.vo.SettlementFinalizedVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/settlementCountersign"})
public class SettlementApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementCountersignService settlementCountersignService;
    @Autowired
    private ISettlementFinalizedService settlementFinalizedService;

    @RequestMapping(value={"/querySettleById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementCountersignVO> querySettleById(Long contractId) {
        SettlementCountersignVO settlementCountersignVO = this.settlementCountersignService.querySettleById(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)settlementCountersignVO));
    }

    @ResponseBody
    @RequestMapping(value={"/selectByContractIdTime"}, method={RequestMethod.GET})
    public CommonResponse<SettlementFinalizedVO> selectByContractIdTime(@RequestParam(value="contractId") Long contractId, @RequestParam String reportTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)0);
        String start = reportTime.substring(0, 7) + "-01";
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(reportTime.substring(0, 4)));
        cal.set(2, Integer.parseInt(reportTime.substring(5, 7)) - 1);
        cal.set(5, cal.getActualMaximum(5));
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf1.format(cal.getTime());
        queryWrapper.le((Object)"business_date", (Object)end);
        queryWrapper.ge((Object)"business_date", (Object)start);
        SettlementFinalizedEntity settlementFinalizedEntity = (SettlementFinalizedEntity)((Object)this.settlementFinalizedService.getOne((Wrapper)queryWrapper));
        SettlementFinalizedVO result = new SettlementFinalizedVO();
        if (settlementFinalizedEntity != null) {
            result = (SettlementFinalizedVO)((Object)BeanMapper.map((Object)((Object)settlementFinalizedEntity), SettlementFinalizedVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)((Object)result));
    }
}

