/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementDetailService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.MachinerySettlementDetailVO;
import com.ejianc.business.settlementmanage.vo.MachinerySettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"machinerySettlementExport"})
public class ExcelMachinerySettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMachinerySettlementDetailService machinerySettlementDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @RequestMapping(value={"/downloadMachinerySettlementDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadMachinerySettlementDetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"MachinerySettlementDetail-import.xlsx", (String)"\u673a\u68b0\u8bbe\u5907\u7ed3\u7b97\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMachinerySettlementDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMachinerySettlementDetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MachinerySettlementDetailVO> successList = new ArrayList<MachinerySettlementDetailVO>();
        ArrayList<MachinerySettlementDetailVO> errorList = new ArrayList<MachinerySettlementDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 1; i < result.size(); ++i) {
                String errorMessage;
                int num = 0;
                MachinerySettlementDetailVO machinerySettlementDetailVO = new MachinerySettlementDetailVO();
                List datas = (List)result.get(i);
                machinerySettlementDetailVO.setId(IdWorker.getId());
                machinerySettlementDetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? (String)datas.get(10) : null);
                try {
                    String errorMessage2;
                    Date data1 = DateUtils.Date((String)datas.get(1));
                    String str = ExcelMachinerySettlementController.dateToStr(data1);
                    str = str.substring(0, 7);
                    if (map.get(str) != null && StringUtils.isNotEmpty((CharSequence)str) && str.equals(map.get(str))) {
                        errorMessage2 = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u6708\u4efd\u91cd\u590d\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage2);
                        ++num;
                    } else if (!DateUtils.grepDate((String)datas.get(1))) {
                        errorMessage2 = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u6708\u4efd\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage2);
                        ++num;
                    } else {
                        map.put(str, str);
                        machinerySettlementDetailVO.setMonths(DateUtils.Date((String)datas.get(1)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (datas.get(2) != null && !"".equals(datas.get(2))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(2)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u79df\u8d41\u5408\u4ef7(\u542b\u7a0e)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setIntaxLeasePrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? new BigDecimal((String)datas.get(2)) : null);
                    }
                }
                if (datas.get(3) != null && !"".equals(datas.get(3))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(3)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u79df\u8d41\u5408\u4ef7(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setExtaxLeasePrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                    }
                }
                if (datas.get(4) != null && !"".equals(datas.get(4))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(4)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u8d54\u507f\u91d1\u989d(\u542b\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setIntaxCompensationPayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                    }
                }
                if (datas.get(5) != null && !"".equals(datas.get(5))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(5)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u8d54\u507f\u91d1\u989d(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setExtaxCompensationPayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                    }
                }
                if (datas.get(6) != null && !"".equals(datas.get(6))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(6)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u4fee\u7406\u8d39\u7b49\u5176\u5b83\u8d39\u7528(\u542b\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setIntaxRepair(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(6)) : null);
                    }
                }
                if (datas.get(7) != null && !"".equals(datas.get(7))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(7)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u4fee\u7406\u8d39\u7b49\u5176\u5b83\u8d39\u7528(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setExtaxRepair(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(7)) : null);
                    }
                }
                if (datas.get(8) != null && !"".equals(datas.get(8))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(8)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u6708\u5ea6\u7ed3\u7b97\u8d39\u7528(\u542b\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                    }
                }
                if (datas.get(9) != null && !"".equals(datas.get(9))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(9)))) {
                        errorMessage = machinerySettlementDetailVO.getErrorMsg();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u6708\u5ea6\u7ed3\u7b97\u8d39\u7528(\u9664\u7a0e) \u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        machinerySettlementDetailVO.setErrorMsg(errorMessage);
                        ++num;
                    } else {
                        machinerySettlementDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                    }
                }
                if (datas.get(8) != null && !"".equals(datas.get(8))) {
                    machinerySettlementDetailVO.setIntaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                } else if (num == 0) {
                    BigDecimal intaxMonthlySettlementAmount = null;
                    if (datas.get(2) != null && !"".equals(datas.get(2))) {
                        intaxMonthlySettlementAmount = new BigDecimal((String)datas.get(2));
                    }
                    if (datas.get(4) != null && !"".equals(datas.get(4))) {
                        intaxMonthlySettlementAmount = intaxMonthlySettlementAmount != null && num == 0 ? intaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(4))) : new BigDecimal((String)datas.get(4));
                    }
                    if (datas.get(6) != null && !"".equals(datas.get(6))) {
                        intaxMonthlySettlementAmount = intaxMonthlySettlementAmount != null && num == 0 ? intaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(6))) : new BigDecimal((String)datas.get(6));
                    }
                    if (intaxMonthlySettlementAmount != null && num == 0) {
                        machinerySettlementDetailVO.setIntaxMonthlySettlementAmount(intaxMonthlySettlementAmount);
                    }
                }
                if (datas.get(9) != null && !"".equals(datas.get(9))) {
                    machinerySettlementDetailVO.setExtaxMonthlySettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                } else if (num == 0) {
                    BigDecimal extaxMonthlySettlementAmount = null;
                    if (datas.get(3) != null && !"".equals(datas.get(3))) {
                        extaxMonthlySettlementAmount = new BigDecimal((String)datas.get(3));
                    }
                    if (datas.get(5) != null && !"".equals(datas.get(5))) {
                        extaxMonthlySettlementAmount = extaxMonthlySettlementAmount != null && num == 0 ? extaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(5))) : new BigDecimal((String)datas.get(5));
                    }
                    if (datas.get(7) != null && !"".equals(datas.get(7))) {
                        extaxMonthlySettlementAmount = extaxMonthlySettlementAmount != null && num == 0 ? extaxMonthlySettlementAmount.add(new BigDecimal((String)datas.get(7))) : new BigDecimal((String)datas.get(7));
                    }
                    if (extaxMonthlySettlementAmount != null && num == 0) {
                        machinerySettlementDetailVO.setExtaxMonthlySettlementAmount(extaxMonthlySettlementAmount);
                    }
                }
                if (num > 0) {
                    errorList.add(machinerySettlementDetailVO);
                    continue;
                }
                successList.add(machinerySettlementDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    @RequestMapping(value={"/excelExportMachinerySettlementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMachinerySettlementFromPage(@RequestBody List<MachinerySettlementDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MachinerySettlementDetailVO machinerySettlementDetailVO = list.get(i);
                machinerySettlementDetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<MachinerySettlementDetailVO>> beans = new HashMap<String, List<MachinerySettlementDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MachinerySettlementDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMachinerySettlementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMachinerySettlementFromDatabase(@RequestBody MachinerySettlementVO machinerySettlementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)machinerySettlementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.machinerySettlementDetailService.list((Wrapper)queryWrapper);
        List machinerySettlementDetailVOList = BeanMapper.mapList((Iterable)list, MachinerySettlementDetailVO.class);
        if (machinerySettlementDetailVOList != null && machinerySettlementDetailVOList.size() > 0) {
            for (int i = 0; i < machinerySettlementDetailVOList.size(); ++i) {
                MachinerySettlementDetailVO machinerySettlementDetailVO = (MachinerySettlementDetailVO)((Object)machinerySettlementDetailVOList.get(i));
                machinerySettlementDetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", machinerySettlementDetailVOList);
        ExcelExport.getInstance().export("MachinerySettlementDetail-export.xlsx", beans, response);
    }
}

