/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.IMaterialPurchaseDetailService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.MaterialPurchaseDetailVO;
import com.ejianc.business.settlementmanage.vo.MaterialPurchaseSettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialPurchaseSettlementExport"})
public class ExcelMaterialPurchaseSettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPurchaseDetailService materialPurchaseDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @RequestMapping(value={"/excelExportMaterialPurchaseSettlementExportFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<MaterialPurchaseDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MaterialPurchaseDetailVO subpackagematerialanalysisdetailVO = list.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<MaterialPurchaseDetailVO>> beans = new HashMap<String, List<MaterialPurchaseDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialpurchasesettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaterialPurchaseSettlementExportFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody MaterialPurchaseSettlementVO subpackagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)subpackagematerialanalysisVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.materialPurchaseDetailService.list((Wrapper)queryWrapper);
        List subpackagematerialanalysisdetailVOList = BeanMapper.mapList((Iterable)list, MaterialPurchaseDetailVO.class);
        if (subpackagematerialanalysisdetailVOList != null && subpackagematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < subpackagematerialanalysisdetailVOList.size(); ++i) {
                MaterialPurchaseDetailVO subpackagematerialanalysisdetailVO = (MaterialPurchaseDetailVO)((Object)subpackagematerialanalysisdetailVOList.get(i));
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialpurchasesettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadMaterialPurchaseSettlement"})
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialpurchasesettlementdetail-import.xlsx", (String)"\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterialPurchaseSettlement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialPurchaseDetailVO> successList = new ArrayList<MaterialPurchaseDetailVO>();
        ArrayList<MaterialPurchaseDetailVO> errorList = new ArrayList<MaterialPurchaseDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap map = new HashMap();
        HashMap map1 = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal extaxSummaryAmount;
                String errorMessage;
                int num = 0;
                List datas = (List)result.get(i);
                MaterialPurchaseDetailVO subpackagematerialanalysisdetailVO = new MaterialPurchaseDetailVO();
                subpackagematerialanalysisdetailVO.setId(IdWorker.getId());
                subpackagematerialanalysisdetailVO.setSuppliesCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                subpackagematerialanalysisdetailVO.setSupplies(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                subpackagematerialanalysisdetailVO.setSpecifications(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                subpackagematerialanalysisdetailVO.setUnits(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                subpackagematerialanalysisdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? (String)datas.get(13) : null);
                CommonResponse back0 = this.shareMaterialApi.queryMaterialByCode((String)datas.get(1));
                if (back0.getData() == null) {
                    errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "\u7269\u8d44\u7f16\u7801\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5!";
                    subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                    ++num;
                } else {
                    String errorMessage2;
                    String unitName;
                    MaterialVO materialVO = (MaterialVO)back0.getData();
                    String name = materialVO.getName() == null ? "" : materialVO.getName();
                    String spec = materialVO.getSpec() == null ? "" : materialVO.getSpec();
                    String string = unitName = materialVO.getUnitName() == null ? "" : materialVO.getUnitName();
                    if (!name.equals(datas.get(2))) {
                        errorMessage2 = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u7269\u8d44\u540d\u79f0\u4e0e\u7269\u8d44\u7f16\u7801\u4e0d\u7b26,\u8bf7\u68c0\u67e5!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage2);
                        ++num;
                    }
                    if (!spec.equals(datas.get(3))) {
                        errorMessage2 = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u89c4\u683c\u4e0e\u7269\u8d44\u7f16\u7801\u4e0d\u7b26,\u8bf7\u68c0\u67e5!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage2);
                        ++num;
                    }
                    if (!unitName.equals(datas.get(4))) {
                        errorMessage2 = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage2 == null) {
                            errorMessage2 = "";
                        }
                        errorMessage2 = errorMessage2 + "\u8ba1\u91cf\u5355\u4f4d\u4e0e\u7269\u8d44\u7f16\u7801\u4e0d\u7b26,\u8bf7\u68c0\u67e5!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage2);
                        ++num;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "\u7269\u8d44\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
                    subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                    ++num;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "\u7269\u8d44\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
                    subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                    ++num;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "\u4f9b\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a!";
                    subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                    ++num;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "\u7ed3\u7b97\u5355\u4ef7(\u9664\u7a0e)(\u5143)\u4e0d\u80fd\u4e3a\u7a7a!";
                    subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                    ++num;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                    errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)(\u5143)\u4e0d\u80fd\u4e3a\u7a7a!";
                    subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                    ++num;
                }
                if (datas.get(5) != null && !"".equals(datas.get(5))) {
                    try {
                        subpackagematerialanalysisdetailVO.setSupplyMonth(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? DateUtils.Date((String)datas.get(5)) : null);
                    }
                    catch (Exception e) {
                        String errorMessage3 = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage3 == null) {
                            errorMessage3 = "";
                        }
                        errorMessage3 = errorMessage3 + "\u4f9b\u8d27\u6708\u4efd\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage3);
                        ++num;
                    }
                }
                if (datas.get(6) != null && !"".equals(datas.get(6))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(6)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u5206\u5305\u57fa\u7840\u6e05\u5355\u5de5\u7a0b\u91cf\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        String quantitySupplied = (String)datas.get(6);
                        subpackagematerialanalysisdetailVO.setQuantitySupplied(Long.parseLong(String.valueOf(quantitySupplied.split("\\.")[0])));
                    }
                }
                if (datas.get(7) != null && !"".equals(datas.get(7))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(7)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u5408\u540c\u5355\u4ef7(\u9664\u7a0e)(\u5143)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        subpackagematerialanalysisdetailVO.setExtaxContractPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                    }
                }
                if (datas.get(8) != null && !"".equals(datas.get(8))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(8)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u5408\u540c\u5355\u4ef7(\u542b\u7a0e)(\u5143)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        subpackagematerialanalysisdetailVO.setIntaxContractPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                    }
                }
                if (datas.get(9) != null && !"".equals(datas.get(9))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(9)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u7ed3\u7b97\u5355\u4ef7(\u9664\u7a0e)(\u5143)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        subpackagematerialanalysisdetailVO.setExtaxSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                    }
                }
                if (datas.get(10) != null && !"".equals(datas.get(10))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(10)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)(\u5143)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        subpackagematerialanalysisdetailVO.setIntaxSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                    }
                }
                if (datas.get(11) != null && !"".equals(datas.get(11))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(11)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u7ed3\u7b97\u91d1\u989d(\u9664\u7a0e)(\u5143)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                    }
                }
                if (datas.get(12) != null && !"".equals(datas.get(12))) {
                    if (!NumberUtil.isNumber((String)String.valueOf(datas.get(12)))) {
                        errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) {
                            errorMessage = "";
                        }
                        errorMessage = errorMessage + "\u7ed3\u7b97\u91d1\u989d(\u542b\u7a0e)(\u5143)\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        ++num;
                    } else {
                        subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null);
                    }
                }
                if (datas.get(11) == null || "".equals(datas.get(11))) {
                    if (num == 0) {
                        extaxSummaryAmount = new BigDecimal((String)datas.get(6)).multiply(new BigDecimal((String)datas.get(9)));
                        subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(extaxSummaryAmount);
                    }
                } else if (num == 0) {
                    subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(new BigDecimal((String)datas.get(11)));
                }
                if (datas.get(12) == null || "".equals(datas.get(12))) {
                    if (num == 0) {
                        extaxSummaryAmount = new BigDecimal((String)datas.get(6)).multiply(new BigDecimal((String)datas.get(10)));
                        subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(extaxSummaryAmount);
                    }
                } else if (num == 0) {
                    subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(new BigDecimal((String)datas.get(12)));
                }
                extaxSummaryAmount = ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(subpackagematerialanalysisdetailVO.getQuantitySupplied()), (BigDecimal)subpackagematerialanalysisdetailVO.getExtaxSettlementPrice());
                this.logger.info("\u7ed3\u7b97\u91d1\u989d(\u9664\u7a0e)(\u5143):" + subpackagematerialanalysisdetailVO.getQuantitySupplied() + ";" + subpackagematerialanalysisdetailVO.getExtaxSettlementPrice() + ";" + extaxSummaryAmount);
                subpackagematerialanalysisdetailVO.setExtaxSummaryAmount(extaxSummaryAmount == null ? BigDecimal.ZERO : extaxSummaryAmount);
                BigDecimal intaxSummaryAmount = ComputeUtil.safeMultiply((BigDecimal)new BigDecimal(subpackagematerialanalysisdetailVO.getQuantitySupplied()), (BigDecimal)subpackagematerialanalysisdetailVO.getIntaxSettlementPrice());
                this.logger.info("\u7ed3\u7b97\u91d1\u989d(\u542b\u7a0e)(\u5143):" + subpackagematerialanalysisdetailVO.getQuantitySupplied() + ";" + subpackagematerialanalysisdetailVO.getIntaxSettlementPrice() + ";" + intaxSummaryAmount);
                subpackagematerialanalysisdetailVO.setIntaxSummaryAmount(intaxSummaryAmount == null ? BigDecimal.ZERO : intaxSummaryAmount);
                if (num > 0) {
                    errorList.add(subpackagematerialanalysisdetailVO);
                    continue;
                }
                successList.add(subpackagematerialanalysisdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

