/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinaldetailEntity;
import com.ejianc.business.settlementmanage.bean.ConsultotherfinalodetailEntity;
import com.ejianc.business.settlementmanage.mapper.ConsultotherfinalMapper;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinaldetailService;
import com.ejianc.business.settlementmanage.service.IConsultotherfinalodetailService;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinaldetailVO;
import com.ejianc.business.settlementmanage.vo.ConsultotherfinalodetailVO;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.api.DesignAndConsultApi;
import com.ejianc.foundation.middlemeasurement.api.IConsultotherApi;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="consultotherfinalService")
public class ConsultotherfinalServiceImpl
extends BaseServiceImpl<ConsultotherfinalMapper, ConsultotherfinalEntity>
implements IConsultotherfinalService {
    @Autowired
    private IConsultotherfinalodetailService consultotherfinalodetailService;
    @Autowired
    private IConsultotherfinaldetailService consultotherfinaldetailService;
    @Autowired
    private IConsultotherfinalService service;
    @Autowired
    private ConsultotherfinalMapper mapper;
    @Autowired
    private DesignAndConsultApi designAndConsultApi;
    @Autowired
    private IConsultotherApi consultotherApi;
    @Autowired
    private IOutcontractApi outcontractApi;

    @Override
    public BigDecimal queryConsultotherfinal(Long projectId, String monthStr) {
        BigDecimal curExtaxPrice = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS = this.mapper.queryConsultotherfinal(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.add(totalPrice);
        }
        List<CostManageVO> costManageVOS1 = this.mapper.queryConsultotherfinaloDetail(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS1) {
            BigDecimal totalPrice = costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice();
            curExtaxPrice = curExtaxPrice.subtract(totalPrice);
        }
        return curExtaxPrice;
    }

    @Override
    public ConsultotherfinalEntity calculateDetailCurrentAmount(ConsultotherfinalEntity entity) {
        List<ConsultotherfinalodetailEntity> consultotherfinalodetailEntities;
        List<ConsultotherfinaldetailEntity> consultotherfinaldetailEntities = entity.getConsultotherfinaldetailEntities();
        if (!consultotherfinaldetailEntities.isEmpty()) {
            for (ConsultotherfinaldetailEntity consultotherfinaldetailEntity : consultotherfinaldetailEntities) {
                if ("del".equals(consultotherfinaldetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = consultotherfinaldetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = consultotherfinaldetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinaldetailEntity.getCumIntaxPrice();
                consultotherfinaldetailEntity.setCurExtaxPrice(consultotherfinaldetailEntity.getAmounts().subtract(cumExtaxPrice));
                consultotherfinaldetailEntity.setCurIntaxPrice(consultotherfinaldetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
            }
        }
        if (!(consultotherfinalodetailEntities = entity.getConsultotherfinalodetailEntities()).isEmpty()) {
            for (ConsultotherfinalodetailEntity consultotherfinalodetailEntity : consultotherfinalodetailEntities) {
                if ("del".equals(consultotherfinalodetailEntity.getRowState())) continue;
                BigDecimal cumExtaxPrice = consultotherfinalodetailEntity.getCumExtaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumExtaxPrice();
                BigDecimal cumIntaxPrice = consultotherfinalodetailEntity.getCumIntaxPrice() == null ? BigDecimal.ZERO : consultotherfinalodetailEntity.getCumIntaxPrice();
                consultotherfinalodetailEntity.setCurExtaxPrice(consultotherfinalodetailEntity.getAmounts().subtract(cumExtaxPrice));
                consultotherfinalodetailEntity.setCurIntaxPrice(consultotherfinalodetailEntity.getTaxAmounts().subtract(cumIntaxPrice));
            }
        }
        return entity;
    }

    @Override
    public Map<String, ConsultotherfinaldetailVO> queryConsultDetailCumPastMap(Long contractId, String date) {
        HashMap<String, ConsultotherfinaldetailVO> map = new HashMap<String, ConsultotherfinaldetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryConsultDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            List consultotherfinaldetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), ConsultotherfinaldetailVO.class);
            for (ConsultotherfinaldetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getSubitemName() + consultotherfinaldetailVO.getUnitprice().setScale(2, 4) + consultotherfinaldetailVO.getTaxUnitprice().setScale(2, 4);
                map.put(key, consultotherfinaldetailVO);
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public Map<String, ConsultotherfinalodetailVO> queryConsultOtherDetailCumPastMap(Long contractId, String date) {
        HashMap<String, ConsultotherfinalodetailVO> map = new HashMap<String, ConsultotherfinalodetailVO>();
        CommonResponse listCommonResponse = this.designAndConsultApi.queryConsultOtherDetailCumPast(contractId, date);
        if (listCommonResponse.isSuccess()) {
            List consultotherfinaldetailVOS = BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), ConsultotherfinalodetailVO.class);
            for (ConsultotherfinalodetailVO consultotherfinaldetailVO : consultotherfinaldetailVOS) {
                String key = consultotherfinaldetailVO.getExpenseName() + consultotherfinaldetailVO.getoUnitPrice().setScale(2, 4) + consultotherfinaldetailVO.getoTaxUnitPrice().setScale(2, 4);
                map.put(key, consultotherfinaldetailVO);
            }
        } else {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        return map;
    }

    @Override
    public ConsultotherfinalEntity totalForm(ConsultotherfinalEntity entity) {
        Map<String, BigDecimal> map = this.consultotherfinaldetailService.totalForm(entity.getConsultotherfinaldetailEntities());
        Map<String, BigDecimal> map1 = this.consultotherfinalodetailService.totalForm(entity.getConsultotherfinalodetailEntities());
        BigDecimal currentTotal = map.get("currentTotal").subtract(map1.get("currentTotal"));
        BigDecimal currentTaxTotal = map.get("currentTaxTotal").subtract(map1.get("currentTaxTotal"));
        BigDecimal cumulativeAmounts = map.get("cumulativeAmounts").subtract(map1.get("cumulativeAmounts"));
        BigDecimal cumulativeTaxAmounts = map.get("cumulativeTaxAmounts").subtract(map1.get("cumulativeTaxAmounts"));
        entity.setCurrentTotal(currentTotal);
        entity.setTaxCurrentTotal(currentTaxTotal);
        entity.setCumulativeTotal(cumulativeAmounts);
        entity.setTaxCumulativeTotal(cumulativeTaxAmounts);
        entity.setTaxDeductionAmount(map1.get("currentTaxTotal"));
        entity.setDeductionAmount(map1.get("currentTotal"));
        entity.setTaxCurrentContract(map.get("currentTaxTotalContract"));
        entity.setCurrentContract(map.get("currentTotalContract"));
        entity.setTaxCumulativeContract(map.get("cumulativeTaxAmountsContract"));
        entity.setCumulativeContract(map.get("cumulativeAmountsContract"));
        entity.setCurrentContractout(map.get("currentTotalContractOut"));
        entity.setTaxCurrentContractout(map.get("currentTaxTotalContractOut"));
        entity.setCumulativeContractout(map.get("cumulativeAmountsContractOut"));
        entity.setTaxCumulativeContractout(map.get("cumulativeTaxAmountsContractOut"));
        return entity;
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( reporting_time, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (ConsultotherfinalEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConsultotherfinalEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(ConsultotherfinalEntity::getIsSettlement)).or()).eq(ConsultotherfinalEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u6700\u7ec8\u7ed3\u7b97\u5355\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConsultotherfinalEntity::getProjectId, (Object)projectId)).ne(ConsultotherfinalEntity::getBillState, (Object)3)).ne(ConsultotherfinalEntity::getBillState, (Object)1)).apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u6700\u7ec8\u7ed3\u7b97\u5355\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }

    @Override
    public ConsultotherfinalVO queryMidDataByCont(Long contractId, Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConsultotherfinalEntity::getContractId, (Object)contractId);
        queryWrapper.ne(null != id, BaseEntity::getId, (Object)id);
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u6700\u7ec8\u7ed3\u7b97\u5355\uff01");
        }
        ConsultotherfinalVO consultotherfinalVO = new ConsultotherfinalVO();
        CommonResponse commonResponse = this.consultotherApi.queryListByCont(contractId);
        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
            List purchaseList = (List)commonResponse.getData();
            ArrayList<ConsultotherVO> result = new ArrayList<ConsultotherVO>();
            for (ConsultotherVO settleVO : purchaseList) {
                if (!settleVO.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !settleVO.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u4e2d\u95f4\u8ba1\u91cf\u5355\uff01");
                }
                result.add(settleVO);
            }
            BigDecimal farmersWages = BigDecimal.ZERO;
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            BigDecimal sumSettleOthMny = BigDecimal.ZERO;
            BigDecimal sumSettleOthTaxMny = BigDecimal.ZERO;
            HashMap<String, ConsultotherfinaldetailVO> map = new HashMap<String, ConsultotherfinaldetailVO>();
            ArrayList<ConsultotherfinalodetailVO> otherList = new ArrayList<ConsultotherfinalodetailVO>();
            for (ConsultotherVO settleVO : result) {
                farmersWages = ComputeUtil.safeAdd((BigDecimal)farmersWages, (BigDecimal)settleVO.getFarmersWages());
                for (ConsultotherdetailVO purchaseDetailVO : settleVO.getConsultotherdetailEntities()) {
                    sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)purchaseDetailVO.getExamineAmounts());
                    sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)purchaseDetailVO.getExamineTaxAmounts());
                    String key = purchaseDetailVO.getSubitemName() + "@" + purchaseDetailVO.getUnitprice() + "@" + purchaseDetailVO.getTaxUnitprice();
                    ConsultotherfinaldetailVO settleDetailVO = null;
                    if (map.containsKey(key)) {
                        settleDetailVO = (ConsultotherfinaldetailVO)((Object)map.get(key));
                    } else {
                        settleDetailVO.setSource(StringUtils.isNotBlank((CharSequence)(settleDetailVO = new ConsultotherfinaldetailVO()).getSource()) ? settleDetailVO.getSource() + "@" + String.valueOf(purchaseDetailVO.getId()) : String.valueOf(purchaseDetailVO.getId()));
                        settleDetailVO.setSort(purchaseDetailVO.getSort());
                        settleDetailVO.setSubitemCode(purchaseDetailVO.getSubitemCode());
                        settleDetailVO.setSubitemName(purchaseDetailVO.getSubitemName());
                        settleDetailVO.setSpec(purchaseDetailVO.getSpec());
                        settleDetailVO.setUnit(purchaseDetailVO.getUnit());
                        settleDetailVO.setUnitprice(purchaseDetailVO.getUnitprice());
                        settleDetailVO.setTaxUnitprice(purchaseDetailVO.getTaxUnitprice());
                        settleDetailVO.setUnit(purchaseDetailVO.getUnit());
                        settleDetailVO.setVersion(1);
                        settleDetailVO.setId(null);
                        settleDetailVO.setContractId(purchaseDetailVO.getContractId());
                        settleDetailVO.setRowState("add");
                    }
                    settleDetailVO.setPastQuantity(ComputeUtil.safeAdd((BigDecimal)settleDetailVO.getPastQuantity(), (BigDecimal)purchaseDetailVO.getExamineQuantity()));
                    settleDetailVO.setCumExtaxPrice(ComputeUtil.safeAdd((BigDecimal)settleDetailVO.getCumExtaxPrice(), (BigDecimal)purchaseDetailVO.getExamineAmounts()));
                    settleDetailVO.setCumIntaxPrice(ComputeUtil.safeAdd((BigDecimal)settleDetailVO.getCumIntaxPrice(), (BigDecimal)purchaseDetailVO.getExamineTaxAmounts()));
                    settleDetailVO.setCumQuantity(ComputeUtil.safeAdd((BigDecimal)settleDetailVO.getCumQuantity(), (BigDecimal)purchaseDetailVO.getExamineQuantity()));
                    settleDetailVO.setAmounts(ComputeUtil.safeAdd((BigDecimal)settleDetailVO.getAmounts(), (BigDecimal)purchaseDetailVO.getExamineAmounts()));
                    settleDetailVO.setTaxAmounts(ComputeUtil.safeAdd((BigDecimal)settleDetailVO.getTaxAmounts(), (BigDecimal)purchaseDetailVO.getExamineTaxAmounts()));
                    map.put(key, settleDetailVO);
                }
                for (ConsultotherdetailVO purchaseDetailVO : settleVO.getConsultotherodetailEntities()) {
                    ConsultotherfinalodetailVO detailVO = (ConsultotherfinalodetailVO)((Object)BeanMapper.map((Object)purchaseDetailVO, ConsultotherfinalodetailVO.class));
                    sumSettleOthMny = ComputeUtil.safeAdd((BigDecimal)sumSettleOthMny, (BigDecimal)purchaseDetailVO.getAmounts());
                    sumSettleOthTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleOthTaxMny, (BigDecimal)purchaseDetailVO.getTaxAmounts());
                    detailVO.setSource(String.valueOf(purchaseDetailVO.getId()));
                    detailVO.setCreateTime(null);
                    detailVO.setCreateUserCode(null);
                    detailVO.setUpdateTime(null);
                    detailVO.setUpdateUserCode(null);
                    detailVO.setVersion(1);
                    detailVO.setId(null);
                    detailVO.setRowState("add");
                    detailVO.setCurExtaxPrice(purchaseDetailVO.getAmounts());
                    detailVO.setCurIntaxPrice(purchaseDetailVO.getTaxAmounts());
                    otherList.add(detailVO);
                }
            }
            ConsultotherVO settleVO = (ConsultotherVO)result.get(0);
            consultotherfinalVO.setContractId(settleVO.getContractId());
            consultotherfinalVO.setContractName(settleVO.getContractName());
            consultotherfinalVO.setProjectId(settleVO.getProjectId());
            consultotherfinalVO.setProjectName(settleVO.getProjectName());
            consultotherfinalVO.setOrgId(settleVO.getOrgId());
            consultotherfinalVO.setOrgName(settleVO.getOrgName());
            consultotherfinalVO.setProjectDepartmentId(settleVO.getProjectDepartmentId());
            consultotherfinalVO.setSupplierId(settleVO.getSupplierId());
            consultotherfinalVO.setSupplierName(settleVO.getSupplierName());
            consultotherfinalVO.setCumulativeFarmersWages(farmersWages);
            consultotherfinalVO.setCumulativeTotal(sumSettleMny);
            consultotherfinalVO.setTaxCumulativeTotal(sumSettleTaxMny);
            consultotherfinalVO.setSumDeduction(sumSettleOthMny);
            consultotherfinalVO.setSumTaxDeduction(sumSettleOthTaxMny);
            consultotherfinalVO.setContractType(settleVO.getContractType());
            consultotherfinalVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            consultotherfinalVO.setConsultotherfinaldetailEntities(new ArrayList<ConsultotherfinaldetailVO>(map.values()));
            consultotherfinalVO.setConsultotherfinalodetailEntities(otherList);
        } else {
            CommonResponse response = this.outcontractApi.queryDetail(contractId);
            OutcontractVO outcontractVO = (OutcontractVO)response.getData();
            consultotherfinalVO.setContractId(outcontractVO.getId());
            consultotherfinalVO.setContractName(outcontractVO.getContractName());
            consultotherfinalVO.setProjectId(outcontractVO.getProjectId());
            consultotherfinalVO.setProjectName(outcontractVO.getProjectName());
            consultotherfinalVO.setOrgId(outcontractVO.getOrgId());
            consultotherfinalVO.setOrgName(outcontractVO.getOrgName());
            consultotherfinalVO.setSupplierId(outcontractVO.getSupplier());
            consultotherfinalVO.setSupplierName(outcontractVO.getSupplierName());
            consultotherfinalVO.setProjectDepartmentId(outcontractVO.getProjectDepartmentId());
            consultotherfinalVO.setContractType(outcontractVO.getType());
            consultotherfinalVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        if (null != id) {
            ConsultotherfinalEntity finalEntity = (ConsultotherfinalEntity)((Object)this.selectById(id));
            consultotherfinalVO.setId(finalEntity.getId());
            consultotherfinalVO.setCreateTime(finalEntity.getCreateTime());
            consultotherfinalVO.setCreateUserCode(finalEntity.getCreateUserCode());
            consultotherfinalVO.setUpdateTime(finalEntity.getUpdateTime());
            consultotherfinalVO.setUpdateUserCode(finalEntity.getUpdateUserCode());
            consultotherfinalVO.setBillCode(finalEntity.getBillCode());
            consultotherfinalVO.setVersion(finalEntity.getVersion());
            consultotherfinalVO.setTenantId(finalEntity.getTenantId());
        }
        return consultotherfinalVO;
    }
}

