/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.mapper.SettlementBookStatementDetailMapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.vo.LaborCostVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementBookStatementDetailService")
public class SettlementBookStatementDetailServiceImpl
extends BaseServiceImpl<SettlementBookStatementDetailMapper, SettlementBookStatementDetailEntity>
implements ISettlementBookStatementDetailService {
    @Autowired
    private SettlementBookStatementDetailMapper settlementBookStatementDetailMapper;

    @Override
    public LaborCostVO getEngineering(String contractType, Long projectId, String subitemCode, String section, String reportingTime) {
        LaborCostVO vo = this.settlementBookStatementDetailMapper.getEngineering(contractType, projectId, subitemCode, section, reportingTime);
        return vo;
    }

    @Override
    public List<LaborCostVO> getSum(String contractType, Long projectId, String reportingTime) {
        List<LaborCostVO> vo = this.settlementBookStatementDetailMapper.getSum(contractType, projectId, reportingTime);
        return vo;
    }

    @Override
    public List<LaborCostVO> getStatementAll(String projectId, String contractType, String time) {
        List<LaborCostVO> statementAll = this.settlementBookStatementDetailMapper.getStatementAll(projectId, contractType, time);
        return statementAll;
    }

    @Override
    public Map<String, BigDecimal> totalForm(List<SettlementBookStatementDetailEntity> list) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (!list.isEmpty()) {
            for (SettlementBookStatementDetailEntity entity : list) {
                if ("del".equals(entity.getRowState())) continue;
                amount = amount.add(BigDecimalUtils.ofNullable(entity.getExtaxAddition()));
                taxAmount = taxAmount.add(BigDecimalUtils.ofNullable(entity.getIntaxAddition()));
            }
        }
        map.put("amount", amount);
        map.put("taxAmount", taxAmount);
        return map;
    }
}

