/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSettlementEntity;
import com.ejianc.business.settlementmanage.mapper.TurnoverLeaseSettlementMapper;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSetDetailService;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="turnoverLeaseSettlementService")
public class TurnoverLeaseSettlementServiceImpl
extends BaseServiceImpl<TurnoverLeaseSettlementMapper, TurnoverLeaseSettlementEntity>
implements ITurnoverLeaseSettlementService {
    @Autowired
    private TurnoverLeaseSettlementMapper turnoverLeaseSettlementMapper;
    @Autowired
    private ITurnoverLeaseSetDetailService turnoverLeaseSetDetailService;
    List<TurnoverLeaseSetDetailVO> subList = new ArrayList<TurnoverLeaseSetDetailVO>();

    @Override
    public int updateIsFlag(List<Long> sourceIdList) {
        return this.turnoverLeaseSettlementMapper.updateIsFlag(sourceIdList);
    }

    @Override
    public int updateFlag(List<Long> sourceIdList) {
        return this.turnoverLeaseSettlementMapper.updateFlag(sourceIdList);
    }

    @Override
    public List<TurnoverLeaseSetDetailVO> queryIsFlag(List<Long> sourceIdList) {
        return this.turnoverLeaseSettlementMapper.queryIsFlag(sourceIdList);
    }

    @Override
    public JSONObject getDataById(Long contractId) {
        List<TurnoverLeaseSetDetailVO> turnoverLeaseSetDetailVOS = this.turnoverLeaseSettlementMapper.queryDetailList(contractId);
        if (CollectionUtils.isNotEmpty(turnoverLeaseSetDetailVOS)) {
            List<TurnoverLeaseSetDetailVO> parentList = turnoverLeaseSetDetailVOS.stream().filter(s -> s.getLesseeQuantity() == null).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TurnoverLeaseSetDetailVO>(Comparator.comparing(TurnoverLeaseSetDetailVO::getInnercode))), ArrayList::new));
            HashMap<String, TurnoverLeaseSetDetailVO> map = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)parentList)) {
                map = parentList.stream().collect(Collectors.toMap(TurnoverLeaseSetDetailVO::getInnercode, Function.identity()));
            }
            List childList = turnoverLeaseSetDetailVOS.stream().filter(s -> s.getLesseeQuantity() != null).collect(Collectors.toList());
            parentList.addAll(childList);
            if (CollectionUtils.isNotEmpty((Collection)parentList)) {
                parentList.forEach(s -> s.setTid(String.valueOf(IdWorker.getId())));
                for (TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO : parentList) {
                    turnoverLeaseSetDetailVO.setId(IdWorker.getId());
                    String innercode = turnoverLeaseSetDetailVO.getInnercode();
                    String[] innercodeSubArr = innercode.split("_");
                    String innercodeSub = "";
                    String sectionSuf = "";
                    if (innercodeSubArr.length > 1) {
                        innercodeSub = innercodeSubArr[0];
                        sectionSuf = "_" + innercodeSubArr[1];
                    }
                    Long pid = null;
                    if (innercodeSub.length() != 2) {
                        String pcode;
                        if (innercodeSub.length() == 4) {
                            pcode = innercodeSub.substring(0, 2) + sectionSuf;
                            pid = this.setPid(pcode, map);
                        } else if (innercodeSub.length() == 6) {
                            pcode = innercodeSub.substring(0, 4) + sectionSuf;
                            pid = this.setPid(pcode, map);
                        } else if (innercodeSub.length() > 6) {
                            pcode = innercodeSub.substring(0, 6) + sectionSuf;
                            pid = this.setPid(pcode, map);
                        }
                    }
                    if (pid != null) {
                        turnoverLeaseSetDetailVO.setTpid(pid.toString());
                        continue;
                    }
                    turnoverLeaseSetDetailVO.setTpid("");
                }
                parentList = this.handleChildren(parentList);
                JSONObject json = new JSONObject();
                json.put("dataSource", parentList);
                return json;
            }
        }
        return null;
    }

    private List<TurnoverLeaseSetDetailVO> handleChildren(List<TurnoverLeaseSetDetailVO> voList) {
        Collections.sort(voList, new Comparator<TurnoverLeaseSetDetailVO>(){

            @Override
            public int compare(TurnoverLeaseSetDetailVO o1, TurnoverLeaseSetDetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });
        List tpidList = voList.stream().map(TurnoverLeaseSetDetailVO::getTpid).collect(Collectors.toList());
        for (TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO : voList) {
            List<TurnoverLeaseSetDetailVO> detailByPid = this.getDetailByPid(turnoverLeaseSetDetailVO.getTid(), voList);
            if (!CollectionUtils.isNotEmpty(detailByPid)) continue;
            turnoverLeaseSetDetailVO.setEndTime(null);
            BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal otherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getOtherExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxOtherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxOtherExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeQuantity() != null).map(TurnoverLeaseSetDetailVO::getTaxMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            turnoverLeaseSetDetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
            turnoverLeaseSetDetailVO.setLesseeTotalprice(lesseeTotalprice);
            turnoverLeaseSetDetailVO.setCompensateAccount(compensateAccount);
            turnoverLeaseSetDetailVO.setTaxCompensateAccount(taxCompensateAccount);
            turnoverLeaseSetDetailVO.setTaxOtherExpenses(taxOtherExpenses);
            turnoverLeaseSetDetailVO.setOtherExpenses(otherExpenses);
            turnoverLeaseSetDetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
            turnoverLeaseSetDetailVO.setMonthlyExpenses(monthlyExpenses);
            this.subList.clear();
        }
        voList = TurnoverLeaseSettlementServiceImpl.createTreeData(voList);
        return voList;
    }

    public static List<TurnoverLeaseSetDetailVO> createTreeData(List<TurnoverLeaseSetDetailVO> list) {
        ArrayList<TurnoverLeaseSetDetailVO> resp = new ArrayList<TurnoverLeaseSetDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, TurnoverLeaseSetDetailVO> listMap = new HashMap<String, TurnoverLeaseSetDetailVO>();
        for (TurnoverLeaseSetDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            TurnoverLeaseSetDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            TurnoverLeaseSetDetailVO parent = (TurnoverLeaseSetDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<TurnoverLeaseSetDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<TurnoverLeaseSetDetailVO> children = new ArrayList<TurnoverLeaseSetDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((TurnoverLeaseSetDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private List<TurnoverLeaseSetDetailVO> getDetailByPid(String tid, List<TurnoverLeaseSetDetailVO> list) {
        for (TurnoverLeaseSetDetailVO subcontractingvolumedetailVO : list) {
            if (tid == null || !tid.equals(subcontractingvolumedetailVO.getTpid())) continue;
            this.getDetailByPid(subcontractingvolumedetailVO.getTid(), list);
            this.subList.add(subcontractingvolumedetailVO);
        }
        return this.subList;
    }

    private Long setPid(String pcode, Map<String, TurnoverLeaseSetDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }
}

