package com.ejianc.business.settlementmanage.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 物资采购最终结算
 *
 * @author generator
 *
 */
 @TableName("ejc_settlementmanage_material_settle")
public class MaterialSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; //
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; //
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织id
    @TableField(value="demander_id")
    private Long demanderId; // 需方id
    @TableField(value="demander_name")
    private String demanderName; // 需方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供方id
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="settle_date")
    private Date settleDate; // 发生时间
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="start_date")
    private Date startDate; // 结算起始时间
    @TableField(value="end_date")
    private Date endDate; // 结算截至时间
    @TableField(value="department_agent_id")
    private Long departmentAgentId; // 项目部经办人id
    @TableField(value="department_agent_name")
    private String departmentAgentName; // 项目部经办人名称
    @TableField(value="department_agent_date")
    private Date departmentAgentDate; // 项目部经办时间
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="agent_time")
    private Date agentTime; // 经办时间
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 本次结算金额(除税)
    @TableField(value="settle_tax_mny")
    private BigDecimal settleTaxMny; // 本次结算金额(含税)
    @TableField(value="measure_settle_mny")
    private BigDecimal measureSettleMny; // 其中本次安全文明措施费
    @TableField(value="sum_measure_settle_mny")
    private BigDecimal sumMeasureSettleMny; // 其中累计安全文明措施费
    @TableField(value="sum_settle_mny")
    private BigDecimal sumSettleMny; // 累计结算金额(除税)
    @TableField(value="sum_settle_tax_mny")
    private BigDecimal sumSettleTaxMny; // 累计结算金额(含税)

    @TableField(value="project_department_id")
    private java.lang.Long projectDepartmentId; // 项目部id

    @TableField(exist = false)
    private String billStateStr;

    @TableField(value="is_settlement")
    private Integer isSettlement; // 是否归集状态 0 未归集 1 归集




    @TableField(exist=false)
    @SubEntity(serviceName="materialSettleDetailService", pidName = "settleId")
    private List<MaterialSettleDetailEntity> detailList = new ArrayList<>(); // 物资采购最终结算子表

    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getDemanderId() {
        return demanderId;
    }

    public void setDemanderId(Long demanderId) {
        this.demanderId = demanderId;
    }
    public String getDemanderName() {
        return demanderName;
    }

    public void setDemanderName(String demanderName) {
        this.demanderName = demanderName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Long getDepartmentAgentId() {
        return departmentAgentId;
    }

    public void setDepartmentAgentId(Long departmentAgentId) {
        this.departmentAgentId = departmentAgentId;
    }
    public String getDepartmentAgentName() {
        return departmentAgentName;
    }

    public void setDepartmentAgentName(String departmentAgentName) {
        this.departmentAgentName = departmentAgentName;
    }
    public Date getDepartmentAgentDate() {
        return departmentAgentDate;
    }

    public void setDepartmentAgentDate(Date departmentAgentDate) {
        this.departmentAgentDate = departmentAgentDate;
    }
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Date getAgentTime() {
        return agentTime;
    }

    public void setAgentTime(Date agentTime) {
        this.agentTime = agentTime;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getMeasureSettleMny() {
        return measureSettleMny;
    }

    public void setMeasureSettleMny(BigDecimal measureSettleMny) {
        this.measureSettleMny = measureSettleMny;
    }
    public BigDecimal getSumMeasureSettleMny() {
        return sumMeasureSettleMny;
    }

    public void setSumMeasureSettleMny(BigDecimal sumMeasureSettleMny) {
        this.sumMeasureSettleMny = sumMeasureSettleMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public List<MaterialSettleDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MaterialSettleDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
