package com.ejianc.business.settlementmanage.service;

import com.ejianc.business.settlementmanage.vo.MaterialSettleVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.settlementmanage.bean.MaterialSettleEntity;

/**
 * 物资采购最终结算
 *
 * @author generator
 *
 */
public interface IMaterialSettleService extends IBaseService<MaterialSettleEntity> {

    MaterialSettleVO saveOrUpdate(MaterialSettleVO materialSettleVO);

    MaterialSettleVO queryDetail(Long id);

    MaterialSettleVO queryMidDataByCont(Long contractId, Long id);

    /**
     * @Description //TODO 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);
}
