package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MaterialSettleEntity;
import com.ejianc.business.settlementmanage.service.IMaterialSettleService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Service("materialSettle")
public class MaterialSettleBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private CostanalysisApi costanalysisApi;
	@Autowired
	private IMaterialSettleService service;

	@Autowired
	private IParamConfigApi paramConfigApi;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		MaterialSettleEntity entity = service.selectById(billId);
//		CommonResponse<Boolean> response = costanalysisApi.isGenerate(entity.getProjectId(),entity.getSettleDate());
//		if(response != null){
//			Boolean isHave = response.getData();
//			if(isHave != null && isHave.booleanValue()){
//				return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
//			}
//		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//查询是否生成月度分析报告
//		QueryWrapper<MaterialSettleEntity> queryWrapper1 = new QueryWrapper<>();
//		queryWrapper1.eq("id",billId);
//		MaterialSettleEntity entity1 = service.getOne(queryWrapper1);
//		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity1.getProjectId(), entity1.getSettleDate());
//		if(generate.isSuccess() && generate.getData()){
//			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
//		}
		MaterialSettleEntity materialSettleEntity = service.selectById(billId);
		//报表已生成, 数据已被抓取的不能撤回
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode("P-P29C0z0304");
		if (!byCode.isSuccess()){
			throw new BusinessException("获取参数失败");
		}
		ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
		String valueData = paramRegisterSetVO.getValueData();
		Date reportingTime = materialSettleEntity.getSettleDate();
//获取对应数据的报表生成日期
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		calendar.setTime(reportingTime);
		calendar.add(Calendar.MONTH, 1);
		Date date = calendar.getTime();
		String period = sdf.format(date);
		String limit = period + "-"+valueData;
		SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date limitDate = ft.parse(limit);
			if (new Date().after(limitDate)){
				return CommonResponse.error("当前单据已生成运营分析报表,不能撤回!");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
