package com.ejianc.business.settlementmanage.service.impl;

import com.ejianc.business.settlementmanage.bean.SettlementBookMaterialDetailEntity;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.vo.SettlementBookMaterialDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookOtherDetailVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settlementmanage.mapper.SettlementBookOtherDetailMapper;
import com.ejianc.business.settlementmanage.bean.SettlementBookOtherDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookOtherDetailService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工程分包结算书子表-支出明细-其它
 * 
 * @author generator
 * 
 */
@Service("settlementBookOtherDetailService")
public class SettlementBookOtherDetailServiceImpl extends BaseServiceImpl<SettlementBookOtherDetailMapper, SettlementBookOtherDetailEntity> implements ISettlementBookOtherDetailService{
    @Qualifier("com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;

    @Override
    public Map<String, SettlementBookOtherDetailVO> querySubcontractingvolumeOtherByContractId(Long contractId) {
        Map<String, SettlementBookOtherDetailVO> map = new HashMap<>();
        List<SettlementBookOtherDetailVO> otherDetailVOArrayList = new ArrayList<>();
        CommonResponse<List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO>> otherResponse =
                subcontractingvolumeApi.querySubcontractingvolumeOtherByContractId(contractId);
        if (otherResponse.isSuccess()){
            List<com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO> data =
                    otherResponse.getData();
            otherDetailVOArrayList = BeanMapper.mapList(data,SettlementBookOtherDetailVO.class);
            for (SettlementBookOtherDetailVO settlementBookOtherDetailVO : otherDetailVOArrayList) {
                settlementBookOtherDetailVO.setId(IdWorker.getId());
                settlementBookOtherDetailVO.setIsEditState("否");
                String key = settlementBookOtherDetailVO.getWithholdingOther() +
                        settlementBookOtherDetailVO.getDeductionsName() +
                        settlementBookOtherDetailVO.getExtaxUnitpriceC().setScale(2, RoundingMode.HALF_UP) +
                        settlementBookOtherDetailVO.getIntaxPriceC().setScale(2,RoundingMode.HALF_UP);
                map.put(key,settlementBookOtherDetailVO);
            }
        }else {
            throw new BusinessException(otherResponse.getMsg());
        }
        return map;
    }

    @Override
    public Map<String, BigDecimal> totalForm(List<SettlementBookOtherDetailEntity> list) {
        Map<String, BigDecimal> map = new HashMap<>();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (!list.isEmpty()){
            for (SettlementBookOtherDetailEntity entity : list) {
                amount = amount.add(BigDecimalUtils.ofNullable(entity.getCurExtaxPrice()));
                taxAmount = taxAmount.add(BigDecimalUtils.ofNullable(entity.getCurIntaxPrice()));
            }
        }
        map.put("amount",amount);
        map.put("taxAmount",taxAmount);
        return map;
    }
}
