package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSetDetailEntity;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSettlementEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("turnoverLeaseSettlement")
public class TurnoverLeaseSettlementBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ITurnoverLeaseSettlementService service;
	@Autowired
	private CostanalysisApi costanalysisApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		TurnoverLeaseSettlementEntity entity = service.selectById(billId);
		CommonResponse<Boolean> response = costanalysisApi.isGenerate(entity.getProjectId(),entity.getSettlementDate());
		if(response != null){
			Boolean isHave = response.getData();
			if(isHave != null && isHave.booleanValue()){
				return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 *
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("------------------------------------提交完回调-------------------------------------------");
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("------------------------------------有审批流的撤回前回调-------------------------------------------");
		TurnoverLeaseSettlementEntity entity = service.selectById(billId);
		if(CollectionUtils.isNotEmpty(entity.getTurnoverLeaseSetDetailEntities())){
			List<Long> sourceIdList = new ArrayList<>();
			for(TurnoverLeaseSetDetailEntity detailEntity : entity.getTurnoverLeaseSetDetailEntities()){
				sourceIdList.add(detailEntity.getSourceId());
			}
			service.updateFlag(sourceIdList);
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("------------------------------------有审批流的撤回后回调-------------------------------------------");
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("------------------------------------终审审核完回调-------------------------------------------");
		TurnoverLeaseSettlementEntity entity = service.selectById(billId);
		if(CollectionUtils.isNotEmpty(entity.getTurnoverLeaseSetDetailEntities())){
			List<Long> sourceIdList = new ArrayList<>();
			for(TurnoverLeaseSetDetailEntity detailEntity : entity.getTurnoverLeaseSetDetailEntities()){
				sourceIdList.add(detailEntity.getSourceId());
			}
			List<TurnoverLeaseSetDetailVO> list = service.queryIsFlag(sourceIdList);
			if(CollectionUtils.isNotEmpty(list)){
				for(TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO : list){
					if(null != turnoverLeaseSetDetailVO.getIsFlag() && turnoverLeaseSetDetailVO.getIsFlag() == 1){
						throw new BusinessException("该单据引用的中间计量单已被引用过，不允许提交，请删除后重新做！");
					}
				}
			}

			service.updateIsFlag(sourceIdList);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("------------------------------------弃审前事件回调-------------------------------------------");
		//查询是否生成月度分析报告
		QueryWrapper<TurnoverLeaseSettlementEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("id",billId);
		TurnoverLeaseSettlementEntity entity1 = service.getOne(queryWrapper1);
		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity1.getProjectId(), entity1.getSettlementDate());
		if(generate.isSuccess() && generate.getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}

		TurnoverLeaseSettlementEntity entity = service.selectById(billId);
		if(CollectionUtils.isNotEmpty(entity.getTurnoverLeaseSetDetailEntities())){
			List<Long> sourceIdList = new ArrayList<>();
			for(TurnoverLeaseSetDetailEntity detailEntity : entity.getTurnoverLeaseSetDetailEntities()){
				sourceIdList.add(detailEntity.getSourceId());
			}
			service.updateFlag(sourceIdList);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
