package com.ejianc.business.settlementmanage.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 影响总包结算的关键事项清单
 *
 * @author generator
 *
 */
public class EventListVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractName; // 合同名称
    private java.math.BigDecimal settleReportAuditedValue; // 结算报审值
    private java.math.BigDecimal contractPrice; // 合同造价
    private java.math.BigDecimal paymentReceived; // 已收款
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date contractCompletionDate; // 合同竣工日期
    private java.lang.String contractCompletionDateStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date actualDate; // 实际完工日期
    private java.lang.String actualDateStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date expectedCompletionDate; // 预计完工日期
    private java.lang.String expectedCompletionDateStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date actualCompletionDate; // 实际竣工验收日期
    private java.lang.String actualCompletionDateStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date settlementPlanCompletionTime; // 结算策划完成时间
    private java.lang.String settlementPlanCompletionTimeStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signTime; // 结算目标责任书签订时间
    private java.lang.String signTimeStr;
    private java.math.BigDecimal settlementProvisionalValuation; // 结算暂估值(自施)(含税)
    private java.math.BigDecimal actualCost; // 实际成本(含税)
    private java.math.BigDecimal expectedCost; // 预计成本(含税)
    private java.math.BigDecimal expectedProfit; // 预计利润
    private java.math.BigDecimal actualProfitValue; // 预计利润值
    private java.math.BigDecimal targetResponsibilityMargin; // 目标责任书利润率
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date estimatedCompletionTime; // 预计结算完成时间
    private java.lang.String estimatedCompletionTimeStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date expectreportTime; // 结算预计报出时间
    private java.lang.String expectreportTimeStr;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reportTime; // 结算报出日期
    private java.lang.String reportTimeStr;
    private java.lang.Long agentId; // 经办人id
    private java.lang.String agentName; // 经办人名称
    private java.lang.Long agentDepartment; // 经办人部门
    private String agentDepartmentName; // 经办人部门名称
    private java.lang.String remarks; // 备注
    private java.math.BigDecimal completedSettlement; // 已完成结算项
    private java.math.BigDecimal unfinishedSettlement; // 未完成结算项
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date completionTime; // 预计完成时间
    private java.lang.String completionTimeStr; // 备注
    private java.lang.String unfinishedReason; // 分包结算未完成原因
    private List<EventListdetailVO> eventListdetailEntities = new ArrayList<>();
    private java.lang.String createTimeShow; // 创建时间文本显示
    private java.lang.String billStateStr; // 单据状态Str
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date actualCommencementDate; // 实际开工日期
    private java.math.BigDecimal settlementPrice; // 结算造价
    private java.lang.String isConstructionComplete; //工程是否施工完毕
    private java.lang.String isSettlementplanComplete; // 结算策划是否完成
    private java.lang.String settlementStatus;//结算状态
    private java.math.BigDecimal taxes;//税金
    private java.math.BigDecimal projectProfitMargins;//项目利润率
    private java.math.BigDecimal actualCostExcludingTax;//实际成本(不含税)
    private java.lang.String reason;//未施工完毕原因
    private java.lang.Long originalId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementCompletionTime; // 确保结算完成时间
    private String orgInsuranceLeader; // 所属单位包保领导
    private BigDecimal settlementDutyProfitRate; // 结算责任书利润率
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completedReportDate; // 竣工报告日期
    private BigDecimal settlementEstimateValue; // 结算预估值

    public Date getSettlementCompletionTime() {
        return settlementCompletionTime;
    }

    public void setSettlementCompletionTime(Date settlementCompletionTime) {
        this.settlementCompletionTime = settlementCompletionTime;
    }

    public String getOrgInsuranceLeader() {
        return orgInsuranceLeader;
    }

    public void setOrgInsuranceLeader(String orgInsuranceLeader) {
        this.orgInsuranceLeader = orgInsuranceLeader;
    }

    public BigDecimal getSettlementDutyProfitRate() {
        return settlementDutyProfitRate;
    }

    public void setSettlementDutyProfitRate(BigDecimal settlementDutyProfitRate) {
        this.settlementDutyProfitRate = settlementDutyProfitRate;
    }

    public Date getCompletedReportDate() {
        return completedReportDate;
    }

    public void setCompletedReportDate(Date completedReportDate) {
        this.completedReportDate = completedReportDate;
    }

    public BigDecimal getSettlementEstimateValue() {
        return settlementEstimateValue;
    }

    public void setSettlementEstimateValue(BigDecimal settlementEstimateValue) {
        this.settlementEstimateValue = settlementEstimateValue;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-incontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 结算报审值
     */
    public java.math.BigDecimal getSettleReportAuditedValue() {
        return settleReportAuditedValue;
    }

    /**
     * 结算报审值
     */
    public void setSettleReportAuditedValue(java.math.BigDecimal settleReportAuditedValue) {
        this.settleReportAuditedValue = settleReportAuditedValue;
    }
    /**
     * 合同造价
     */
    public java.math.BigDecimal getContractPrice() {
        return contractPrice;
    }

    /**
     * 合同造价
     */
    public void setContractPrice(java.math.BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    /**
     * 已收款
     */
    public java.math.BigDecimal getPaymentReceived() {
        return paymentReceived;
    }

    /**
     * 已收款
     */
    public void setPaymentReceived(java.math.BigDecimal paymentReceived) {
        this.paymentReceived = paymentReceived;
    }
    /**
     * 合同竣工日期
     */
    public java.util.Date getContractCompletionDate() {
        return contractCompletionDate;
    }

    /**
     * 合同竣工日期
     */
    public void setContractCompletionDate(java.util.Date contractCompletionDate) {
        this.contractCompletionDate = contractCompletionDate;
    }
    /**
     * 实际完工日期
     */
    public java.util.Date getActualDate() {
        return actualDate;
    }

    /**
     * 实际完工日期
     */
    public void setActualDate(java.util.Date actualDate) {
        this.actualDate = actualDate;
    }
    /**
     * 预计完工日期
     */
    public java.util.Date getExpectedCompletionDate() {
        return expectedCompletionDate;
    }

    /**
     * 预计完工日期
     */
    public void setExpectedCompletionDate(java.util.Date expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }
    /**
     * 实际竣工验收日期
     */
    public java.util.Date getActualCompletionDate() {
        return actualCompletionDate;
    }

    /**
     * 实际竣工验收日期
     */
    public void setActualCompletionDate(java.util.Date actualCompletionDate) {
        this.actualCompletionDate = actualCompletionDate;
    }
    /**
     * 结算策划完成时间
     */
    public java.util.Date getSettlementPlanCompletionTime() {
        return settlementPlanCompletionTime;
    }

    /**
     * 结算策划完成时间
     */
    public void setSettlementPlanCompletionTime(java.util.Date settlementPlanCompletionTime) {
        this.settlementPlanCompletionTime = settlementPlanCompletionTime;
    }
    /**
     * 结算目标责任书签订时间
     */
    public java.util.Date getSignTime() {
        return signTime;
    }

    /**
     * 结算目标责任书签订时间
     */
    public void setSignTime(java.util.Date signTime) {
        this.signTime = signTime;
    }
    /**
     * 结算暂估值(自施)(含税)
     */
    public java.math.BigDecimal getSettlementProvisionalValuation() {
        return settlementProvisionalValuation;
    }

    /**
     * 结算暂估值(自施)(含税)
     */
    public void setSettlementProvisionalValuation(java.math.BigDecimal settlementProvisionalValuation) {
        this.settlementProvisionalValuation = settlementProvisionalValuation;
    }
    /**
     * 实际成本(含税)
     */
    public java.math.BigDecimal getActualCost() {
        return actualCost;
    }

    /**
     * 实际成本(含税)
     */
    public void setActualCost(java.math.BigDecimal actualCost) {
        this.actualCost = actualCost;
    }
    /**
     * 预计成本(含税)
     */
    public java.math.BigDecimal getExpectedCost() {
        return expectedCost;
    }

    /**
     * 预计成本(含税)
     */
    public void setExpectedCost(java.math.BigDecimal expectedCost) {
        this.expectedCost = expectedCost;
    }
    /**
     * 预计利润
     */
    public java.math.BigDecimal getExpectedProfit() {
        return expectedProfit;
    }

    /**
     * 预计利润
     */
    public void setExpectedProfit(java.math.BigDecimal expectedProfit) {
        this.expectedProfit = expectedProfit;
    }
    /**
     * 预计利润值
     */
    public java.math.BigDecimal getActualProfitValue() {
        return actualProfitValue;
    }

    /**
     * 预计利润值
     */
    public void setActualProfitValue(java.math.BigDecimal actualProfitValue) {
        this.actualProfitValue = actualProfitValue;
    }
    /**
     * 目标责任书利润率
     */
    public java.math.BigDecimal getTargetResponsibilityMargin() {
        return targetResponsibilityMargin;
    }

    /**
     * 目标责任书利润率
     */
    public void setTargetResponsibilityMargin(java.math.BigDecimal targetResponsibilityMargin) {
        this.targetResponsibilityMargin = targetResponsibilityMargin;
    }
    /**
     * 预计结算完成时间
     */
    public java.util.Date getEstimatedCompletionTime() {
        return estimatedCompletionTime;
    }

    /**
     * 预计结算完成时间
     */
    public void setEstimatedCompletionTime(java.util.Date estimatedCompletionTime) {
        this.estimatedCompletionTime = estimatedCompletionTime;
    }
    /**
     * 结算预计报出时间
     */
    public java.util.Date getExpectreportTime() {
        return expectreportTime;
    }

    /**
     * 结算预计报出时间
     */
    public void setExpectreportTime(java.util.Date expectreportTime) {
        this.expectreportTime = expectreportTime;
    }
    /**
     * 结算报出日期
     */
    public java.util.Date getReportTime() {
        return reportTime;
    }

    /**
     * 结算报出日期
     */
    public void setReportTime(java.util.Date reportTime) {
        this.reportTime = reportTime;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer

    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getAgentName() {
        return agentName;
    }
    /**
     * 经办人名称
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 经办人部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public java.lang.Long getAgentDepartment() {
        return agentDepartment;
    }
    /**
     * 经办人部门
     */
    @ReferDeserialTransfer
    public void setAgentDepartment(java.lang.Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 已完成结算项
     */
    public java.math.BigDecimal getCompletedSettlement() {
        return completedSettlement;
    }

    /**
     * 已完成结算项
     */
    public void setCompletedSettlement(java.math.BigDecimal completedSettlement) {
        this.completedSettlement = completedSettlement;
    }
    /**
     * 未完成结算项
     */
    public java.math.BigDecimal getUnfinishedSettlement() {
        return unfinishedSettlement;
    }

    /**
     * 未完成结算项
     */
    public void setUnfinishedSettlement(java.math.BigDecimal unfinishedSettlement) {
        this.unfinishedSettlement = unfinishedSettlement;
    }
    /**
     * 预计完成时间
     */
    public java.util.Date getCompletionTime() {
        return completionTime;
    }

    /**
     * 预计完成时间
     */
    public void setCompletionTime(java.util.Date completionTime) {
        this.completionTime = completionTime;
    }
    /**
     * 分包结算未完成原因
     */
    public java.lang.String getUnfinishedReason() {
        return unfinishedReason;
    }

    /**
     * 分包结算未完成原因
     */
    public void setUnfinishedReason(java.lang.String unfinishedReason) {
        this.unfinishedReason = unfinishedReason;
    }

    public List<EventListdetailVO> getEventListdetailEntities() {
        return eventListdetailEntities;
    }

    public void setEventListdetailEntities(List<EventListdetailVO> eventListdetailEntities) {
        this.eventListdetailEntities = eventListdetailEntities;
    }

    public String getContractCompletionDateStr() {
        return contractCompletionDateStr;
    }

    public void setContractCompletionDateStr(String contractCompletionDateStr) {
        this.contractCompletionDateStr = contractCompletionDateStr;
    }

    public String getActualDateStr() {
        return actualDateStr;
    }

    public void setActualDateStr(String actualDateStr) {
        this.actualDateStr = actualDateStr;
    }

    public String getExpectedCompletionDateStr() {
        return expectedCompletionDateStr;
    }

    public void setExpectedCompletionDateStr(String expectedCompletionDateStr) {
        this.expectedCompletionDateStr = expectedCompletionDateStr;
    }

    public String getActualCompletionDateStr() {
        return actualCompletionDateStr;
    }

    public void setActualCompletionDateStr(String actualCompletionDateStr) {
        this.actualCompletionDateStr = actualCompletionDateStr;
    }

    public String getSettlementPlanCompletionTimeStr() {
        return settlementPlanCompletionTimeStr;
    }

    public void setSettlementPlanCompletionTimeStr(String settlementPlanCompletionTimeStr) {
        this.settlementPlanCompletionTimeStr = settlementPlanCompletionTimeStr;
    }

    public String getSignTimeStr() {
        return signTimeStr;
    }

    public void setSignTimeStr(String signTimeStr) {
        this.signTimeStr = signTimeStr;
    }

    public String getEstimatedCompletionTimeStr() {
        return estimatedCompletionTimeStr;
    }

    public void setEstimatedCompletionTimeStr(String estimatedCompletionTimeStr) {
        this.estimatedCompletionTimeStr = estimatedCompletionTimeStr;
    }

    public String getExpectreportTimeStr() {
        return expectreportTimeStr;
    }

    public void setExpectreportTimeStr(String expectreportTimeStr) {
        this.expectreportTimeStr = expectreportTimeStr;
    }

    public String getReportTimeStr() {
        return reportTimeStr;
    }

    public void setReportTimeStr(String reportTimeStr) {
        this.reportTimeStr = reportTimeStr;
    }

    public String getCompletionTimeStr() {
        return completionTimeStr;
    }

    public void setCompletionTimeStr(String completionTimeStr) {
        this.completionTimeStr = completionTimeStr;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public Date getActualCommencementDate() {
        return actualCommencementDate;
    }

    public void setActualCommencementDate(Date actualCommencementDate) {
        this.actualCommencementDate = actualCommencementDate;
    }

    public BigDecimal getSettlementPrice() {
        return settlementPrice;
    }

    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    public String getIsConstructionComplete() {
        return isConstructionComplete;
    }

    public void setIsConstructionComplete(String isConstructionComplete) {
        this.isConstructionComplete = isConstructionComplete;
    }

    public String getIsSettlementplanComplete() {
        return isSettlementplanComplete;
    }

    public void setIsSettlementplanComplete(String isSettlementplanComplete) {
        this.isSettlementplanComplete = isSettlementplanComplete;
    }

    public String getSettlementStatus() {
        return settlementStatus;
    }

    public void setSettlementStatus(String settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    public BigDecimal getTaxes() {
        return taxes;
    }

    public void setTaxes(BigDecimal taxes) {
        this.taxes = taxes;
    }

    public BigDecimal getProjectProfitMargins() {
        return projectProfitMargins;
    }

    public void setProjectProfitMargins(BigDecimal projectProfitMargins) {
        this.projectProfitMargins = projectProfitMargins;
    }

    public BigDecimal getActualCostExcludingTax() {
        return actualCostExcludingTax;
    }

    public void setActualCostExcludingTax(BigDecimal actualCostExcludingTax) {
        this.actualCostExcludingTax = actualCostExcludingTax;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }

    public String getAgentDepartmentName() {
        return agentDepartmentName;
    }

    public void setAgentDepartmentName(String agentDepartmentName) {
        this.agentDepartmentName = agentDepartmentName;
    }
}
