package com.ejianc.business.settlementmanage.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 机械设备结算-子表
 *
 * @author generator
 *
 */
public class MachinerySettlementDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.Long mid; // 主表id
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractName; // 合同名称
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.String sort; // 序号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM", timezone = "GMT+8")
    private java.util.Date months; // 月份
    private java.math.BigDecimal intaxLeasePrice; // 租赁合价(含税)
    private java.math.BigDecimal extaxLeasePrice; // 租赁合价(除税)
    private java.math.BigDecimal intaxCompensationPayable; // 赔偿金额(含税)
    private java.math.BigDecimal extaxCompensationPayable; // 赔偿金额(除税)
    private java.math.BigDecimal intaxRepair; // 修理费等其它费用(含税)
    private java.math.BigDecimal extaxRepair; // 修理费等其它费用(除税)
    private java.math.BigDecimal intaxMonthlySettlementAmount; // 月度结算费用(含税)
    private java.math.BigDecimal extaxMonthlySettlementAmount; // 月度结算费用(除税)
    private java.lang.String remarks; // 备注
    private java.lang.String errorMsg;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM", timezone = "GMT+8")
    private java.lang.String monthsShow;
    private java.lang.Long sourceId; // 来源单据id
    private java.lang.String sourceCode; // 来源单据编号
    private java.lang.String equipmentCode; // 设备编码
    private java.lang.String name; // 租赁物资名称
    private java.lang.String spec; // 规格型号
    private java.lang.String measuringUnit; // 计量单位
    private java.math.BigDecimal leaseNum; // 租赁数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM", timezone = "GMT+8")
    private java.util.Date billingStartTimes; // 租赁起始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM", timezone = "GMT+8")
    private java.util.Date billingEndTimes; // 租赁终止日期
    private BigDecimal leaseDaysThisTime; // 租赁期长（天）
    private java.math.BigDecimal inTaxLeaseUnit; // 租赁单价（含税）（元）
    private java.math.BigDecimal exTaxLeaseUnit; // 租赁单价（除税）（元）
    private java.math.BigDecimal inTaxLeaseTotal; // 租赁合价（含税）（元）
    private java.math.BigDecimal exTaxLeaseTotal; // 租赁合价（除税）（元）
    private BigDecimal exTaxEntranceExitFee; // 进出场费（除税）
    private BigDecimal inTaxEntranceExitFee; // 进出场费（含税）
    private BigDecimal exTaxEefCurrentSettleAmount; // 结算费用(除税)
    private BigDecimal inTaxEefCurrentSettleAmount; // 结算费用(含税)


    public String getMonthsShow() {
        return monthsShow;
    }

    public void setMonthsShow(String monthsShow) {
        this.monthsShow = monthsShow;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 主表id
     */
    public java.lang.Long getMid() {
        return mid;
    }

    /**
     * 主表id
     */
    public void setMid(java.lang.Long mid) {
        this.mid = mid;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同id
     */
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 序号
     */
    public java.lang.String getSort() {
        return sort;
    }

    /**
     * 序号
     */
    public void setSort(java.lang.String sort) {
        this.sort = sort;
    }
    /**
     * 月份
     */
    public Date getMonths() {
        return months;
    }

    /**
     * 月份
     */
    public void setMonths(Date months) {
        this.months = months;
    }

    /**
     * 租赁合价(含税)
     */
    public java.math.BigDecimal getIntaxLeasePrice() {
        return intaxLeasePrice;
    }

    /**
     * 租赁合价(含税)
     */
    public void setIntaxLeasePrice(java.math.BigDecimal intaxLeasePrice) {
        this.intaxLeasePrice = intaxLeasePrice;
    }
    /**
     * 租赁合价(除税)
     */
    public java.math.BigDecimal getExtaxLeasePrice() {
        return extaxLeasePrice;
    }

    /**
     * 租赁合价(除税)
     */
    public void setExtaxLeasePrice(java.math.BigDecimal extaxLeasePrice) {
        this.extaxLeasePrice = extaxLeasePrice;
    }
    /**
     * 赔偿金额(含税)
     */
    public java.math.BigDecimal getIntaxCompensationPayable() {
        return intaxCompensationPayable;
    }

    /**
     * 赔偿金额(含税)
     */
    public void setIntaxCompensationPayable(java.math.BigDecimal intaxCompensationPayable) {
        this.intaxCompensationPayable = intaxCompensationPayable;
    }
    /**
     * 赔偿金额(除税)
     */
    public java.math.BigDecimal getExtaxCompensationPayable() {
        return extaxCompensationPayable;
    }

    /**
     * 赔偿金额(除税)
     */
    public void setExtaxCompensationPayable(java.math.BigDecimal extaxCompensationPayable) {
        this.extaxCompensationPayable = extaxCompensationPayable;
    }
    /**
     * 修理费等其它费用(含税)
     */
    public java.math.BigDecimal getIntaxRepair() {
        return intaxRepair;
    }

    /**
     * 修理费等其它费用(含税)
     */
    public void setIntaxRepair(java.math.BigDecimal intaxRepair) {
        this.intaxRepair = intaxRepair;
    }
    /**
     * 修理费等其它费用(除税)
     */
    public java.math.BigDecimal getExtaxRepair() {
        return extaxRepair;
    }

    /**
     * 修理费等其它费用(除税)
     */
    public void setExtaxRepair(java.math.BigDecimal extaxRepair) {
        this.extaxRepair = extaxRepair;
    }
    /**
     * 月度结算费用(含税)
     */
    public java.math.BigDecimal getIntaxMonthlySettlementAmount() {
        return intaxMonthlySettlementAmount;
    }

    /**
     * 月度结算费用(含税)
     */
    public void setIntaxMonthlySettlementAmount(java.math.BigDecimal intaxMonthlySettlementAmount) {
        this.intaxMonthlySettlementAmount = intaxMonthlySettlementAmount;
    }
    /**
     * 月度结算费用(除税)
     */
    public java.math.BigDecimal getExtaxMonthlySettlementAmount() {
        return extaxMonthlySettlementAmount;
    }

    /**
     * 月度结算费用(除税)
     */
    public void setExtaxMonthlySettlementAmount(java.math.BigDecimal extaxMonthlySettlementAmount) {
        this.extaxMonthlySettlementAmount = extaxMonthlySettlementAmount;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasuringUnit() {
        return measuringUnit;
    }

    public void setMeasuringUnit(String measuringUnit) {
        this.measuringUnit = measuringUnit;
    }

    public BigDecimal getLeaseNum() {
        return leaseNum;
    }

    public void setLeaseNum(BigDecimal leaseNum) {
        this.leaseNum = leaseNum;
    }

    public Date getBillingStartTimes() {
        return billingStartTimes;
    }

    public void setBillingStartTimes(Date billingStartTimes) {
        this.billingStartTimes = billingStartTimes;
    }

    public Date getBillingEndTimes() {
        return billingEndTimes;
    }

    public void setBillingEndTimes(Date billingEndTimes) {
        this.billingEndTimes = billingEndTimes;
    }

    public BigDecimal getLeaseDaysThisTime() {
        return leaseDaysThisTime;
    }

    public void setLeaseDaysThisTime(BigDecimal leaseDaysThisTime) {
        this.leaseDaysThisTime = leaseDaysThisTime;
    }

    public BigDecimal getInTaxLeaseUnit() {
        return inTaxLeaseUnit;
    }

    public void setInTaxLeaseUnit(BigDecimal inTaxLeaseUnit) {
        this.inTaxLeaseUnit = inTaxLeaseUnit;
    }

    public BigDecimal getExTaxLeaseUnit() {
        return exTaxLeaseUnit;
    }

    public void setExTaxLeaseUnit(BigDecimal exTaxLeaseUnit) {
        this.exTaxLeaseUnit = exTaxLeaseUnit;
    }

    public BigDecimal getInTaxLeaseTotal() {
        return inTaxLeaseTotal;
    }

    public void setInTaxLeaseTotal(BigDecimal inTaxLeaseTotal) {
        this.inTaxLeaseTotal = inTaxLeaseTotal;
    }

    public BigDecimal getExTaxLeaseTotal() {
        return exTaxLeaseTotal;
    }

    public void setExTaxLeaseTotal(BigDecimal exTaxLeaseTotal) {
        this.exTaxLeaseTotal = exTaxLeaseTotal;
    }

    public BigDecimal getExTaxEntranceExitFee() {
        return exTaxEntranceExitFee;
    }

    public void setExTaxEntranceExitFee(BigDecimal exTaxEntranceExitFee) {
        this.exTaxEntranceExitFee = exTaxEntranceExitFee;
    }

    public BigDecimal getInTaxEntranceExitFee() {
        return inTaxEntranceExitFee;
    }

    public void setInTaxEntranceExitFee(BigDecimal inTaxEntranceExitFee) {
        this.inTaxEntranceExitFee = inTaxEntranceExitFee;
    }

    public BigDecimal getExTaxEefCurrentSettleAmount() {
        return exTaxEefCurrentSettleAmount;
    }

    public void setExTaxEefCurrentSettleAmount(BigDecimal exTaxEefCurrentSettleAmount) {
        this.exTaxEefCurrentSettleAmount = exTaxEefCurrentSettleAmount;
    }

    public BigDecimal getInTaxEefCurrentSettleAmount() {
        return inTaxEefCurrentSettleAmount;
    }

    public void setInTaxEefCurrentSettleAmount(BigDecimal inTaxEefCurrentSettleAmount) {
        this.inTaxEefCurrentSettleAmount = inTaxEefCurrentSettleAmount;
    }
}
