/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settlementmanage.bean.TurnoverLeaseSettlementEntity;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSettlementService;
import com.ejianc.business.settlementmanage.service.impl.TurnoverLeaseSettlementServiceImpl;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"turnoverLeaseSettlement"})
public class TurnoverLeaseSettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "settlementmanage-turnover-lease-settlement";
    @Autowired
    private ITurnoverLeaseSettlementService service;
    @Autowired
    private TurnoverLeaseSettlementServiceImpl turnoverLeaseSettlementService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TurnoverLeaseSettlementVO> saveOrUpdate(@RequestBody TurnoverLeaseSettlementVO saveorUpdateVO) {
        TurnoverLeaseSettlementEntity entity = (TurnoverLeaseSettlementEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), TurnoverLeaseSettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TurnoverLeaseSettlementVO vo = (TurnoverLeaseSettlementVO)((Object)BeanMapper.map((Object)((Object)entity), TurnoverLeaseSettlementVO.class));
        List<TurnoverLeaseSetDetailVO> turnoverLeaseSetDetailEntities = vo.getTurnoverLeaseSetDetailEntities();
        List<TurnoverLeaseSetDetailVO> treeData = TurnoverLeaseSettlementController.createTreeData(turnoverLeaseSetDetailEntities);
        vo.setTurnoverLeaseSetDetailEntities(treeData);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TurnoverLeaseSettlementVO> queryDetail(Long id) {
        TurnoverLeaseSettlementEntity entity = (TurnoverLeaseSettlementEntity)((Object)this.service.selectById(id));
        TurnoverLeaseSettlementVO vo = (TurnoverLeaseSettlementVO)((Object)BeanMapper.map((Object)((Object)entity), TurnoverLeaseSettlementVO.class));
        List<TurnoverLeaseSetDetailVO> turnoverLeaseSetDetailEntities = vo.getTurnoverLeaseSetDetailEntities();
        List<TurnoverLeaseSetDetailVO> treeData = TurnoverLeaseSettlementController.createTreeData(turnoverLeaseSetDetailEntities);
        vo.setTurnoverLeaseSetDetailEntities(treeData);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/getDataById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getDataById(@RequestParam(value="contractId", required=false) Long contractId) {
        JSONObject json = this.service.getDataById(contractId);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TurnoverLeaseSettlementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TurnoverLeaseSettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("lessorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TurnoverLeaseSettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("lessorName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List TurnoverLeaseSettlementVOList = BeanMapper.mapList((Iterable)list, TurnoverLeaseSettlementVO.class);
        for (int i = 0; i < TurnoverLeaseSettlementVOList.size(); ++i) {
            String billStateStr;
            TurnoverLeaseSettlementVO turnoverLeaseSettlementVO = (TurnoverLeaseSettlementVO)((Object)TurnoverLeaseSettlementVOList.get(i));
            if (turnoverLeaseSettlementVO.getBillingStartTime() != null) {
                turnoverLeaseSettlementVO.setBillingStartTimeStr(DateUtils.dateSimple(turnoverLeaseSettlementVO.getBillingStartTime()));
            }
            if (turnoverLeaseSettlementVO.getBillingEndTime() != null) {
                turnoverLeaseSettlementVO.setBillingEndTimeStr(DateUtils.dateSimple(turnoverLeaseSettlementVO.getBillingEndTime()));
            }
            if (turnoverLeaseSettlementVO.getSettlementDate() != null) {
                turnoverLeaseSettlementVO.setSettlementDateStr(DateUtils.dateSimple(turnoverLeaseSettlementVO.getSettlementDate()));
            }
            if ((billStateStr = turnoverLeaseSettlementVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u9a73\u56de";
            }
            turnoverLeaseSettlementVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", TurnoverLeaseSettlementVOList);
        ExcelExport.getInstance().export("TurnoverLeaseSettlement-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTurnoverLeaseSettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TurnoverLeaseSettlementVO>> refTurnoverLeaseSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TurnoverLeaseSettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    public static List<TurnoverLeaseSetDetailVO> createTreeData(List<TurnoverLeaseSetDetailVO> list) {
        ArrayList<TurnoverLeaseSetDetailVO> resp = new ArrayList<TurnoverLeaseSetDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, TurnoverLeaseSetDetailVO> listMap = new HashMap<String, TurnoverLeaseSetDetailVO>();
        for (TurnoverLeaseSetDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            TurnoverLeaseSetDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            TurnoverLeaseSetDetailVO parent = (TurnoverLeaseSetDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<TurnoverLeaseSetDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<TurnoverLeaseSetDetailVO> children = new ArrayList<TurnoverLeaseSetDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((TurnoverLeaseSetDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

