/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"settlementBookStatementExport"})
public class ExcelSettlementBookStatementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;
    @Autowired
    private IOutcontractApi outcontractApi;
    @Qualifier(value="com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;
    List<SettlementBookStatementDetailVO> detailVOList = new ArrayList<SettlementBookStatementDetailVO>();

    @RequestMapping(value={"/exportStateFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        ArrayList<SettlementBookStatementDetailVO> records = new ArrayList<SettlementBookStatementDetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if (statementDetailVO.getChildren() == null || statementDetailVO.getChildren().size() <= 0) continue;
                this.splitList(statementDetailVO.getChildren(), records);
            }
        }
        HashMap<String, ArrayList<SettlementBookStatementDetailVO>> beans = new HashMap<String, ArrayList<SettlementBookStatementDetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    private void splitList(List<SettlementBookStatementDetailVO> list, List<SettlementBookStatementDetailVO> records) {
        for (SettlementBookStatementDetailVO vo : list) {
            String source = vo.getSource();
            if ("1".equals(source)) {
                source = "\u5408\u540c\u5185";
            } else if ("2".equals(source)) {
                source = "\u5408\u540c\u5916";
            }
            vo.setSource(source);
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/exportStateFromDataBase"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)settlementBookVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.statementDetailService.list((Wrapper)queryWrapper);
        List statementDetailVOList = BeanMapper.mapList((Iterable)list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); ++i) {
                SettlementBookStatementDetailVO statementDetailVO = (SettlementBookStatementDetailVO)((Object)statementDetailVOList.get(i));
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/stateExcelDown"})
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SettlementBookStatementDetail-import.xlsx", (String)"\u5de5\u7a0b\u91cf\u6e05\u5355\u7ed3\u7b97\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/statementExcelUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId, String detailVOS, boolean isExport) throws ParseException {
        Object outcontractVOCommonResponse;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        List<Object> successList = new ArrayList();
        ArrayList<SettlementBookStatementDetailVO> errorList = new ArrayList<SettlementBookStatementDetailVO>();
        HashMap<String, BigDecimal> excelMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> aloneMap = new HashMap<String, String>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        boolean flag = true;
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            List datas;
            int i;
            outcontractVOCommonResponse = this.outcontractApi.queryDetail(contractId);
            if (!outcontractVOCommonResponse.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25" + outcontractVOCommonResponse.getMsg());
            }
            OutcontractVO outcontractVO = (OutcontractVO)outcontractVOCommonResponse.getData();
            Iterator outcontractSubcontractUnitPriceList = outcontractVO.getOutcontractSubcontractUnitPriceList();
            Map<String, List<OutcontractSubcontractUnitPriceVO>> map = outcontractSubcontractUnitPriceList.stream().collect(Collectors.groupingBy(s -> s.getListCode()));
            for (i = 2; i < result.size(); ++i) {
                datas = (List)result.get(i);
                String inndeCode = (String)datas.get(0) + "_" + (String)datas.get(1) + "_" + (String)datas.get(7) + "_" + (String)datas.get(8);
                String thisEngineeringQuantity = datas.get(12) != null && datas.get(12) != "" ? (String)datas.get(12) : "0";
                excelMap.put(inndeCode, new BigDecimal(thisEngineeringQuantity));
            }
            for (i = 2; i < result.size(); ++i) {
                datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String listingCode = (String)datas.get(0);
                String section = (String)datas.get(1);
                String partProjectName = (String)datas.get(2);
                String subitemDesc = (String)datas.get(3);
                String units = (String)datas.get(4);
                String intaxUnitprice = (String)datas.get(5);
                String extaxUnitprice = (String)datas.get(6);
                String insettlementUnitprice = (String)datas.get(7);
                String exsettlementUnitprice = (String)datas.get(8);
                String thisEngineeringQuantity = (String)datas.get(12);
                String remarks = (String)datas.get(19);
                SettlementBookStatementDetailVO settlementBookStatementDetailVO = new SettlementBookStatementDetailVO();
                settlementBookStatementDetailVO.setId(IdWorker.getId());
                settlementBookStatementDetailVO.setTid(settlementBookStatementDetailVO.getId().toString());
                if (datas.get(0) == null || datas.get(0) == "") {
                    settlementBookStatementDetailVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u6e05\u5355\u7f16\u7801");
                } else {
                    settlementBookStatementDetailVO.setListingCode((String)datas.get(0));
                }
                if (datas.get(1) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    settlementBookStatementDetailVO.setErrorMsg("\u533a\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u533a\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    settlementBookStatementDetailVO.setSection((String)datas.get(1));
                }
                if (StringUtils.isNotBlank((CharSequence)listingCode)) {
                    settlementBookStatementDetailVO.setInnercode(listingCode + "_" + section);
                    if (listingCode == null || listingCode.length() != 2 && listingCode.length() != 4 && listingCode.length() != 6 && listingCode.length() < 9) {
                        settlementBookStatementDetailVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5b9a\u683c\u5f0f");
                        errorsMsgBuilder.append("\u6e05\u5355\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5b9a\u683c\u5f0f\uff01");
                    }
                    settlementBookStatementDetailVO.setListingCode(listingCode);
                }
                if (datas.get(2) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    settlementBookStatementDetailVO.setErrorMsg("\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    settlementBookStatementDetailVO.setPartProjectName((String)datas.get(2));
                }
                settlementBookStatementDetailVO.setSubitemDesc((String)datas.get(3));
                settlementBookStatementDetailVO.setUnits((String)datas.get(4));
                if (StringUtils.isNotBlank((CharSequence)intaxUnitprice)) {
                    if (NumberUtil.isNumber((String)intaxUnitprice)) {
                        settlementBookStatementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                    } else {
                        settlementBookStatementDetailVO.setErrorMsg("\u5408\u540c\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u5408\u540c\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)extaxUnitprice)) {
                    if (NumberUtil.isNumber((String)extaxUnitprice)) {
                        settlementBookStatementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                    } else {
                        settlementBookStatementDetailVO.setErrorMsg("\u5408\u540c\u5355\u4ef7\uff08\u9664\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u5408\u540c\u5355\u4ef7\uff08\u9664\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)insettlementUnitprice)) {
                    if (NumberUtil.isNumber((String)insettlementUnitprice)) {
                        settlementBookStatementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                    } else {
                        settlementBookStatementDetailVO.setErrorMsg("\u7ed3\u7b97\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7ed3\u7b97\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    settlementBookStatementDetailVO.setErrorMsg("\u7ed3\u7b97\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7ed3\u7b97\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotBlank((CharSequence)exsettlementUnitprice)) {
                    if (NumberUtil.isNumber((String)exsettlementUnitprice)) {
                        settlementBookStatementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                    } else {
                        settlementBookStatementDetailVO.setErrorMsg("\u7ed3\u7b97\u5355\u4ef7\uff08\u9664\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7ed3\u7b97\u5355\u4ef7\uff08\u9664\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    settlementBookStatementDetailVO.setErrorMsg("\u7ed3\u7b97\u5355\u4ef7\uff08\u9664\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7ed3\u7b97\u5355\u4ef7\uff08\u9664\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotBlank((CharSequence)thisEngineeringQuantity)) {
                    if (NumberUtil.isNumber((String)thisEngineeringQuantity)) {
                        settlementBookStatementDetailVO.setThisEngineeringQuantity(new BigDecimal(thisEngineeringQuantity));
                    } else {
                        settlementBookStatementDetailVO.setErrorMsg("\u672c\u671f\u5ba1\u6838\u5de5\u7a0b\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u672c\u671f\u5ba1\u6838\u5de5\u7a0b\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    settlementBookStatementDetailVO.setErrorMsg("\u672c\u671f\u5ba1\u6838\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u672c\u671f\u5ba1\u6838\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (errorsMsgBuilder.length() <= 0) {
                    String key = settlementBookStatementDetailVO.getListingCode() + "-" + settlementBookStatementDetailVO.getSection() + "-" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "-" + settlementBookStatementDetailVO.getExsettlementUnitprice();
                    if (aloneMap.containsKey(key)) {
                        settlementBookStatementDetailVO.setErrorMsg(settlementBookStatementDetailVO.getListingCode() + ":\u6570\u636e\u91cd\u590d!");
                        errorsMsgBuilder.append(key + "\u6570\u636e\u91cd\u590d!");
                    } else {
                        aloneMap.put(key, "1");
                    }
                }
                if (map.containsKey(settlementBookStatementDetailVO.getListingCode())) {
                    OutcontractSubcontractUnitPriceVO outcontractSubcontractUnitPriceVO = (OutcontractSubcontractUnitPriceVO)map.get(settlementBookStatementDetailVO.getListingCode()).stream().findFirst().get();
                    settlementBookStatementDetailVO.setSource("1");
                } else {
                    settlementBookStatementDetailVO.setSource("2");
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(settlementBookStatementDetailVO);
                    continue;
                }
                successList.add((Object)settlementBookStatementDetailVO);
            }
        }
        List detailList = JSONArray.parseArray((String)detailVOS, SettlementBookStatementDetailVO.class);
        ArrayList<SettlementBookStatementDetailVO> pcList = new ArrayList<SettlementBookStatementDetailVO>();
        outcontractVOCommonResponse = detailList.iterator();
        while (outcontractVOCommonResponse.hasNext()) {
            SettlementBookStatementDetailVO vo;
            vo.setIntaxAddition((vo = (SettlementBookStatementDetailVO)((Object)outcontractVOCommonResponse.next())).getIntaxAddition() != null ? vo.getIntaxAddition() : BigDecimal.ZERO);
            vo.setExtaxAddition(vo.getExtaxAddition() != null ? vo.getExtaxAddition() : BigDecimal.ZERO);
            vo.setThisAmountsTax(vo.getThisAmountsTax() != null ? vo.getThisAmountsTax() : BigDecimal.ZERO);
            vo.setThisAmountsNotax(vo.getThisAmountsNotax() != null ? vo.getThisAmountsNotax() : BigDecimal.ZERO);
            vo.setChildren(null);
            pcList.add(vo);
        }
        Map<Object, Object> pcMap = new HashMap();
        if (CollectionUtils.isNotEmpty(pcList)) {
            pcMap = pcList.stream().filter(s -> "del" != s.getRowState()).collect(Collectors.groupingBy(s -> s.getListingCode() + "-" + s.getSection() + "-" + s.getInsettlementUnitprice() + "-" + s.getExsettlementUnitprice()));
        }
        Map<Object, Object> excelDataMap = new HashMap();
        if (CollectionUtils.isNotEmpty(successList)) {
            excelDataMap = successList.stream().filter(s -> "del" != s.getRowState()).collect(Collectors.groupingBy(s -> s.getListingCode() + "-" + s.getSection() + "-" + s.getInsettlementUnitprice() + "-" + s.getExsettlementUnitprice()));
        }
        for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : pcList) {
            String code = settlementBookStatementDetailVO.getListingCode() + "_" + settlementBookStatementDetailVO.getSection() + "_" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "_" + settlementBookStatementDetailVO.getExsettlementUnitprice();
            if (!excelMap.containsKey(code)) continue;
            settlementBookStatementDetailVO.setThisEngineeringQuantity((BigDecimal)excelMap.get(code));
            settlementBookStatementDetailVO.setThisAmountsTax(ComputeUtil.safeMultiply((BigDecimal)settlementBookStatementDetailVO.getInsettlementUnitprice(), (BigDecimal)settlementBookStatementDetailVO.getThisEngineeringQuantity()));
            settlementBookStatementDetailVO.setThisAmountsNotax(ComputeUtil.safeMultiply((BigDecimal)settlementBookStatementDetailVO.getExsettlementUnitprice(), (BigDecimal)settlementBookStatementDetailVO.getThisEngineeringQuantity()));
            settlementBookStatementDetailVO.setQuantities(ComputeUtil.safeAdd((BigDecimal)settlementBookStatementDetailVO.getCumulativeEngineeringQuantity(), (BigDecimal)settlementBookStatementDetailVO.getThisEngineeringQuantity()));
            settlementBookStatementDetailVO.setIntaxAddition(ComputeUtil.safeAdd((BigDecimal)settlementBookStatementDetailVO.getAccruingAmountsTax(), (BigDecimal)settlementBookStatementDetailVO.getThisAmountsTax()));
            settlementBookStatementDetailVO.setExtaxAddition(ComputeUtil.safeAdd((BigDecimal)settlementBookStatementDetailVO.getAccruingAmountsNotax(), (BigDecimal)settlementBookStatementDetailVO.getThisAmountsNotax()));
        }
        for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : successList) {
            String key = settlementBookStatementDetailVO.getListingCode() + "-" + settlementBookStatementDetailVO.getSection() + "-" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "-" + settlementBookStatementDetailVO.getExsettlementUnitprice();
            BigDecimal thisEngineeringQuantity = settlementBookStatementDetailVO.getThisEngineeringQuantity();
            if (pcMap.containsKey(key)) continue;
            settlementBookStatementDetailVO.setThisAmountsTax(ComputeUtil.safeMultiply((BigDecimal)settlementBookStatementDetailVO.getInsettlementUnitprice(), (BigDecimal)settlementBookStatementDetailVO.getThisEngineeringQuantity()));
            settlementBookStatementDetailVO.setThisAmountsNotax(ComputeUtil.safeMultiply((BigDecimal)settlementBookStatementDetailVO.getExsettlementUnitprice(), (BigDecimal)settlementBookStatementDetailVO.getThisEngineeringQuantity()));
            settlementBookStatementDetailVO.setQuantities(ComputeUtil.safeAdd((BigDecimal)settlementBookStatementDetailVO.getCumulativeEngineeringQuantity(), (BigDecimal)settlementBookStatementDetailVO.getThisEngineeringQuantity()));
            settlementBookStatementDetailVO.setIntaxAddition(ComputeUtil.safeAdd((BigDecimal)settlementBookStatementDetailVO.getAccruingAmountsTax(), (BigDecimal)settlementBookStatementDetailVO.getThisAmountsTax()));
            settlementBookStatementDetailVO.setExtaxAddition(ComputeUtil.safeAdd((BigDecimal)settlementBookStatementDetailVO.getAccruingAmountsNotax(), (BigDecimal)settlementBookStatementDetailVO.getThisAmountsNotax()));
            pcList.add(settlementBookStatementDetailVO);
        }
        Map<String, SettlementBookStatementDetailVO> attacMap = pcList.stream().collect(Collectors.toMap(SettlementBookStatementDetailVO::getInnercode, Function.identity()));
        Map<String, List<SettlementBookStatementDetailVO>> map = pcList.stream().collect(Collectors.groupingBy(s -> s.getListingCode() + '_' + s.getSection()));
        Map<String, List<SettlementBookStatementDetailVO>> mapPcDouble = pcList.stream().filter(s -> "\u5426".equals(s.getIsDeleted())).collect(Collectors.groupingBy(s -> s.getListingCode() + '_' + s.getSection()));
        ArrayList<SettlementBookStatementDetailVO> detailVOListNew = new ArrayList<SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : pcList) {
            SettlementBookStatementDetailVO bookStatementDetailVO;
            String subitemCode = settlementBookStatementDetailVO.getListingCode();
            String section = settlementBookStatementDetailVO.getSection();
            String innercodeDouble = null;
            Object s2 = null;
            StringBuilder errorsMsgBuilder = new StringBuilder();
            if (subitemCode.length() == 4) {
                innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
                errorsMsgBuilder.append(this.checkDouble(innercodeDouble, map));
                errorsMsgBuilder.append(this.checkPcDouble(innercodeDouble, mapPcDouble));
            }
            if (subitemCode.length() == 6) {
                innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
                errorsMsgBuilder.append(this.checkDouble(innercodeDouble, map));
                errorsMsgBuilder.append(this.checkPcDouble(innercodeDouble, mapPcDouble));
                innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
                errorsMsgBuilder.append(this.checkDouble(innercodeDouble, map));
                errorsMsgBuilder.append(this.checkPcDouble(innercodeDouble, mapPcDouble));
            }
            if (subitemCode.length() > 6) {
                innercodeDouble = subitemCode.substring(0, 6) + "_" + section;
                errorsMsgBuilder.append(this.checkDouble(innercodeDouble, map));
                errorsMsgBuilder.append(this.checkPcDouble(innercodeDouble, mapPcDouble));
                innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
                errorsMsgBuilder.append(this.checkDouble(innercodeDouble, map));
                errorsMsgBuilder.append(this.checkPcDouble(innercodeDouble, mapPcDouble));
                innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
                errorsMsgBuilder.append(this.checkDouble(innercodeDouble, map));
                errorsMsgBuilder.append(this.checkPcDouble(innercodeDouble, mapPcDouble));
            }
            if (errorsMsgBuilder.length() <= 0) {
                bookStatementDetailVO = (SettlementBookStatementDetailVO)((Object)BeanMapper.map((Object)((Object)settlementBookStatementDetailVO), SettlementBookStatementDetailVO.class));
                detailVOListNew.add(bookStatementDetailVO);
                continue;
            }
            bookStatementDetailVO = (SettlementBookStatementDetailVO)((Object)BeanMapper.map((Object)((Object)settlementBookStatementDetailVO), SettlementBookStatementDetailVO.class));
            bookStatementDetailVO.setErrorMsg(errorsMsgBuilder.toString());
            errorList.add(bookStatementDetailVO);
        }
        List<SettlementBookStatementDetailVO> settlementBookStatementDetailVOS = this.setTidAndTpid(detailVOListNew, attacMap);
        List successTpids = settlementBookStatementDetailVOS.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
        for (SettlementBookStatementDetailVO vo : settlementBookStatementDetailVOS) {
            List lastDetails;
            vo.setId(IdWorker.getId());
            List<SettlementBookStatementDetailVO> detailVOListTid = this.getDetailByPidPlanCsf(vo.getTid(), settlementBookStatementDetailVOS);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailVOListTid) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(lastDetails = detailVOListTid.stream().filter(s -> !successTpids.contains(s.getTid())).collect(Collectors.toList()))) {
                vo.setThisEngineeringQuantity(null);
                vo.setQuantities(null);
                vo.setIntaxUnitprice(null);
                vo.setExtaxUnitprice(null);
                vo.setInsettlementUnitprice(null);
                vo.setExsettlementUnitprice(null);
                vo.setThisAmountsTax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setThisAmountsNotax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setIntaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getIntaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setExtaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getExtaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            detailVOListTid.clear();
        }
        successList = settlementBookStatementDetailVOS;
        successList = ExcelSettlementBookStatementController.createTreeData(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)pcList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private String checkDouble(String innercode, Map<String, List<SettlementBookStatementDetailVO>> mapDouble) {
        List<SettlementBookStatementDetailVO> subcontractingvolumedetailVOS;
        if (mapDouble.containsKey(innercode) && (subcontractingvolumedetailVOS = mapDouble.get(innercode)).size() > 1) {
            return "\u7236\u7ea7\u7f16\u7801\u91cd\u590d,\u65e0\u6cd5\u65b0\u589e!";
        }
        return "";
    }

    private String checkPcDouble(String innercode, Map<String, List<SettlementBookStatementDetailVO>> mapDouble) {
        if (mapDouble.containsKey(innercode)) {
            List<SettlementBookStatementDetailVO> subcontractingvolumedetailVOS = mapDouble.get(innercode);
            for (SettlementBookStatementDetailVO vo : subcontractingvolumedetailVOS) {
                if (vo.getInsettlementUnitprice() == null && vo.getExsettlementUnitprice() == null && vo.getExtaxUnitprice() == null && vo.getIntaxUnitprice() == null) continue;
                return "\u7236\u7ea7\u5df2\u6709\u6570\u636e,\u65e0\u6cd5\u65b0\u589e!";
            }
        }
        return "";
    }

    private List<SettlementBookStatementDetailVO> getDetailByPidPlanCsf(String tid, List<SettlementBookStatementDetailVO> list) {
        for (SettlementBookStatementDetailVO vo : list) {
            if (tid == null || !tid.equals(vo.getTpid())) continue;
            this.getDetailByPidPlanCsf(vo.getTid(), list);
            this.detailVOList.add(vo);
        }
        return this.detailVOList;
    }

    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            SettlementBookStatementDetailVO settlementBookStatementDetailVO = vos.get(i);
            String innercode = settlementBookStatementDetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                settlementBookStatementDetailVO.setTpid(pid.toString());
                continue;
            }
            settlementBookStatementDetailVO.setTpid("");
        }
        return vos;
    }

    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        ArrayList<SettlementBookStatementDetailVO> resp = new ArrayList<SettlementBookStatementDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SettlementBookStatementDetailVO> listMap = new HashMap<String, SettlementBookStatementDetailVO>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SettlementBookStatementDetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = (SettlementBookStatementDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SettlementBookStatementDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }
}

