/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.settlementmanage.bean.SettlementCountersignEntity;
import com.ejianc.business.settlementmanage.mapper.SettlementCountersignMapper;
import com.ejianc.business.settlementmanage.service.ISettlementCountersignService;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementCountersignService")
public class SettlementCountersignServiceImpl
extends BaseServiceImpl<SettlementCountersignMapper, SettlementCountersignEntity>
implements ISettlementCountersignService {
    @Autowired
    private SettlementCountersignMapper settlementCountersignMapper;

    @Override
    public SettlementCountersignVO querySettleById(Long contractId) {
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        status.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SettlementCountersignEntity::getContractId, (Object)contractId);
        lambda.in(SettlementCountersignEntity::getBillState, status);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List settlementCountersignList = super.list((Wrapper)lambda);
        SettlementCountersignVO settlementCountersignVO = null;
        if (CollectionUtils.isNotEmpty((Collection)settlementCountersignList)) {
            SettlementCountersignEntity settlementCountersignEntity = (SettlementCountersignEntity)((Object)settlementCountersignList.get(0));
            settlementCountersignVO = (SettlementCountersignVO)((Object)BeanMapper.map((Object)((Object)settlementCountersignEntity), SettlementCountersignVO.class));
        }
        return settlementCountersignVO;
    }

    @Override
    public SettlementCountersignVO queryEngineermeasurementPayee(Long contractId) {
        return this.settlementCountersignMapper.queryEngineermeasurementPayee(contractId);
    }

    @Override
    public SettlementCountersignVO querySettlementPlan(Long contractId) {
        return this.settlementCountersignMapper.querySettlementPlan(contractId);
    }
}

