package com.ejianc.business.settlementmanage.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.bean.MachinerySettlementDetailEntity;
import com.ejianc.business.settlementmanage.mapper.MachinerySettlementDetailMapper;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementDetailService;
import com.ejianc.business.settlementmanage.utils.DateUtils;
import com.ejianc.business.settlementmanage.vo.EventListVO;
import com.ejianc.business.settlementmanage.vo.MachinerySettlementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.settlementmanage.bean.MachinerySettlementEntity;
import com.ejianc.business.settlementmanage.service.IMachinerySettlementService;
import com.ejianc.business.settlementmanage.vo.MachinerySettlementVO;

/**
 * 机械设备结算-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("machinerySettlement")
public class MachinerySettlementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "settlementmanage-machinery-settlement";//此处需要根据实际修改

    @Autowired
    private IMachinerySettlementService service;
    @Autowired
    private IMachinerySettlementDetailService detailService ;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MachinerySettlementVO> saveOrUpdate(@RequestBody MachinerySettlementVO saveorUpdateVO) {
        MachinerySettlementEntity entity = BeanMapper.map(saveorUpdateVO, MachinerySettlementEntity.class);
        List<MachinerySettlementEntity> entityList = service.list(new QueryWrapper<MachinerySettlementEntity>().ne(null != saveorUpdateVO.getId(), "id", saveorUpdateVO.getId()).eq("project_id", saveorUpdateVO.getProjectId()).eq("contract_id", saveorUpdateVO.getContractId()).notIn("bill_state",1,3));
        if (CollectionUtils.isNotEmpty(entityList)) {
            throw new BusinessException("该合同下已存在自由态单据，不允许保存");
        }
        List<MachinerySettlementEntity> entities = service.list(new QueryWrapper<MachinerySettlementEntity>().eq("project_id", saveorUpdateVO.getProjectId()).eq("contract_id", saveorUpdateVO.getContractId()).lt("settlement_date",saveorUpdateVO.getSettlementDate()));
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("该合同下已存在比当前结算时间更大的单据，不允许保存");
        }
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        List<MachinerySettlementDetailEntity> machinerySettlementDetailEntities = entity.getMachinerySettlementDetailEntities();
        if (CollectionUtils.isNotEmpty(machinerySettlementDetailEntities)){
            List<Long> sourceIds = machinerySettlementDetailEntities.stream().map(MachinerySettlementDetailEntity::getSourceId).collect(Collectors.toList());
            detailService.changeFlag(sourceIds,0);
        }

        MachinerySettlementVO vo = BeanMapper.map(entity, MachinerySettlementVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    public static String dateToStr(java.util.Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MachinerySettlementVO> queryDetail(Long id) {
    	MachinerySettlementEntity entity = service.selectById(id);
    	MachinerySettlementVO vo = BeanMapper.map(entity, MachinerySettlementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryMechanicallease", method = RequestMethod.GET)
    @ResponseBody
    public List<MachinerySettlementDetailVO> queryMechanicallease(Long projectId,Long contractId,String settlementDate) {
        List<MachinerySettlementDetailVO> list = detailService.queryMechanicallease(projectId,contractId,settlementDate);
        for (MachinerySettlementDetailVO vo : list) {
            vo.setId(IdWorker.getId());
        }
        return list;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MachinerySettlementVO> vos) {
        //查询出所有的子表已用数据id
        List<Long> ids = vos.stream().map(MachinerySettlementVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)){
            QueryWrapper<MachinerySettlementDetailEntity> objectQueryWrapper = new QueryWrapper<>();
            objectQueryWrapper.in("mid",ids);
            objectQueryWrapper.eq("dr","0");
            List<MachinerySettlementDetailEntity> machinerySettlementDetailEntities = detailService.list(objectQueryWrapper);
            if (CollectionUtils.isNotEmpty(machinerySettlementDetailEntities)){
                List<Long> sourceIds = machinerySettlementDetailEntities.stream().map(MachinerySettlementDetailEntity::getSourceId).collect(Collectors.toList());
                detailService.changeFlag(sourceIds,1);
            }

        }
        service.removeByIds(vos.stream().map(MachinerySettlementVO::getId).collect(Collectors.toList()),true);


        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MachinerySettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("lessorName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
       // param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<MachinerySettlementEntity> page = service.queryPage(param,false);
        IPage<MachinerySettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MachinerySettlementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("lessorName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MachinerySettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<MachinerySettlementVO> MachinerySettlementVOList = BeanMapper.mapList(list, MachinerySettlementVO.class);
        for (int i = 0; i < MachinerySettlementVOList.size(); i++) {
            MachinerySettlementVO machinerySettlementVO= MachinerySettlementVOList.get(i);

            if (machinerySettlementVO.getBillingStartTime()!=null){
                machinerySettlementVO.setBillingStartTimeStr(DateUtils.dateSimple(machinerySettlementVO.getBillingStartTime()));
            }
            if (machinerySettlementVO.getBillingEndTime()!=null){
                machinerySettlementVO.setBillingEndTimeStr(DateUtils.dateSimple(machinerySettlementVO.getBillingEndTime()));
            }
            String billStateStr = machinerySettlementVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "审批驳回";
                }
                machinerySettlementVO.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", MachinerySettlementVOList);
        ExcelExport.getInstance().export("MachinerySettlement-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMachinerySettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MachinerySettlementVO>> refMachinerySettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MachinerySettlementEntity> page = service.queryPage(param,false);
        IPage<MachinerySettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MachinerySettlementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
