package com.ejianc.business.settlementmanage.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.settlementmanage.bean.SettlementBookStatementDetailEntity;
import com.ejianc.business.settlementmanage.service.ISettlementBookStatementDetailService;
import com.ejianc.business.settlementmanage.utils.BigDecimalUtils;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookVO;
import com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工程分包结算书-工程量清单结算表
 */
@Controller
@RequestMapping("settlementBookStatementExport")
public class ExcelSettlementBookStatementController {

    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementBookStatementDetailService statementDetailService;

    @Autowired
    private IOutcontractApi outcontractApi;

    @Qualifier("com.ejianc.foundation.middlemeasurement.api.SubcontractingvolumeApi")
    @Autowired
    private SubcontractingvolumeApi subcontractingvolumeApi;

    /**
     * 工程量清单结算表导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportStateFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void exportStateFromPage(@RequestBody List<SettlementBookStatementDetailVO> list, HttpServletResponse response) {
        List<SettlementBookStatementDetailVO> records = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SettlementBookStatementDetailVO statementDetailVO = list.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
                records.add(statementDetailVO);
                if(statementDetailVO.getChildren()!=null&&statementDetailVO.getChildren().size()>0){
                    this.splitList(statementDetailVO.getChildren(),records);
                }
            }

        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<SettlementBookStatementDetailVO> list,List<SettlementBookStatementDetailVO> records) {
        for(SettlementBookStatementDetailVO vo : list){
            String source = vo.getSource();
            if("1".equals(source)){//来源：1合同内 2合同外
                source = "合同内";
            }else if("2".equals(source)){
                source = "合同外";
            }
            vo.setSource(source);
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }

    /**
     * 工程量清单结算表导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/exportStateFromDataBase", method = RequestMethod.POST)
    @ResponseBody
    public void exportStateFromDataBase(@RequestBody SettlementBookVO settlementBookVO, HttpServletResponse response) {
        QueryWrapper<SettlementBookStatementDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", settlementBookVO.getId());
        queryWrapper.eq("dr", 0);
        List<SettlementBookStatementDetailEntity> list = statementDetailService.list(queryWrapper);
        List<SettlementBookStatementDetailVO> statementDetailVOList = BeanMapper.mapList(list, SettlementBookStatementDetailVO.class);
        if (statementDetailVOList != null && statementDetailVOList.size() > 0) {
            for (int i = 0; i < statementDetailVOList.size(); i++) {
                SettlementBookStatementDetailVO statementDetailVO = statementDetailVOList.get(i);
                statementDetailVO.setSort(Long.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementBookStatementDetail-export.xlsx", beans, response);
    }

    /**
     * 工程量清单结算表导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/stateExcelDown")
    @ResponseBody
    public void stateExcelDown(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SettlementBookStatementDetail-import.xlsx", "工程量清单结算表模板");
    }

    /**
     * 工程量清单结算表导入
     */
    @RequestMapping(value = "/statementExcelUpload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> statementExcelUpload(HttpServletRequest request, HttpServletResponse response, Long contractId,String detailVOS,boolean isExport) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SettlementBookStatementDetailVO> successList = new ArrayList<>();
        List<SettlementBookStatementDetailVO> errorList = new ArrayList<>();
        HashMap<String, BigDecimal> excelMap = new HashMap<>();
        Map<String, String> aloneMap = new HashMap<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else{
            boolean flag = true;
            List<List<String>> result = ExcelReader.readExcel(mf);
            // 处理excel表格数据，将”编码+区段+含税单价+无税单价“+本期审核工程量 封装进excelMap
            if (result != null && result.size() > 0){

                CommonResponse<OutcontractVO> outcontractVOCommonResponse = outcontractApi.queryDetail(contractId);
                if(!outcontractVOCommonResponse.isSuccess()) {
                    throw new BusinessException("获取合同信息失败" + outcontractVOCommonResponse.getMsg());
                }
                OutcontractVO outcontractVO = outcontractVOCommonResponse.getData();
                List<OutcontractSubcontractUnitPriceVO> outcontractSubcontractUnitPriceList = outcontractVO.getOutcontractSubcontractUnitPriceList();
                Map<String, List<OutcontractSubcontractUnitPriceVO>> contractListCodeMap = outcontractSubcontractUnitPriceList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getListCode()
                        ));

                for (int i = 2; i < result.size(); i++){
                    List<String> datas = result.get(i);
                    String inndeCode = datas.get(0) + "_" + datas.get(1) + "_" + datas.get(7) + "_" + datas.get(8);
                    String thisEngineeringQuantity = datas.get(12) != null && datas.get(12)!="" ? datas.get(12) : "0";
                    excelMap.put(inndeCode, new BigDecimal(thisEngineeringQuantity));
                }

                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String listingCode = datas.get(0);//清单编码
                    String section = datas.get(1);//区段
                    String partProjectName = datas.get(2);//分部分项工程名称
                    String subitemDesc = datas.get(3);//子目特征描述
                    String units = datas.get(4);//单位
                    String intaxUnitprice = datas.get(5);//合同单价（含税）
                    String extaxUnitprice = datas.get(6);//合同单价（除税）
                    String insettlementUnitprice = datas.get(7);//结算单价（含税）
                    String exsettlementUnitprice = datas.get(8);//结算单价（除税）
                    String thisEngineeringQuantity = datas.get(12);//本期审核工程量
                    String remarks = datas.get(19);//备注


                    SettlementBookStatementDetailVO settlementBookStatementDetailVO = new SettlementBookStatementDetailVO();
                    settlementBookStatementDetailVO.setId(IdWorker.getId());//id
                    settlementBookStatementDetailVO.setTid(settlementBookStatementDetailVO.getId().toString());//id
//                    settlementBookStatementDetailVO.setIsDeleted("是");//id

                    //必填项校验
                    if (datas.get(0) == null || datas.get(0) == "") {
                        settlementBookStatementDetailVO.setErrorMsg("清单编码不能为空");
                        errorsMsgBuilder.append("清单编码");
                    } else {
                        settlementBookStatementDetailVO.setListingCode(datas.get(0));
                    }
                    if (datas.get(1) == null || StringUtils.isBlank(datas.get(1))) {
                        settlementBookStatementDetailVO.setErrorMsg("区段不能为空");
                        errorsMsgBuilder.append("区段不能为空");
                    } else {
                        settlementBookStatementDetailVO.setSection(datas.get(1));
                    }

                    //清单编码校验
                    if (StringUtils.isNotBlank(listingCode)) {
                        settlementBookStatementDetailVO.setInnercode(listingCode+ "_" + section);//清单编号确定唯一性
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (listingCode == null || !(listingCode.length() == 2 || listingCode.length() == 4 || listingCode.length() == 6 || listingCode.length() >= 9)) {
                            settlementBookStatementDetailVO.setErrorMsg("清单编码不符合规定格式");
                            errorsMsgBuilder.append("清单编码不符合规定格式！");
                        }
                        settlementBookStatementDetailVO.setListingCode(listingCode);
                    }

                    if (datas.get(2) == null || StringUtils.isBlank(datas.get(2))) {
                        settlementBookStatementDetailVO.setErrorMsg("分部分项工程名称不能为空");
                        errorsMsgBuilder.append("分部分项工程名称不能为空");
                    } else {
                        settlementBookStatementDetailVO.setPartProjectName(datas.get(2));
                    }
                    settlementBookStatementDetailVO.setSubitemDesc(datas.get(3));
                    settlementBookStatementDetailVO.setUnits(datas.get(4));

                    if (StringUtils.isNotBlank(intaxUnitprice)) {
                        if (NumberUtil.isNumber(intaxUnitprice)) {
                            settlementBookStatementDetailVO.setIntaxUnitprice(new BigDecimal(intaxUnitprice));
                        } else {
                            settlementBookStatementDetailVO.setErrorMsg("合同单价（含税）格式不正确！");
                            errorsMsgBuilder.append("合同单价（含税）格式不正确！");
                        }
                    }
                    if (StringUtils.isNotBlank(extaxUnitprice)) {
                        if (NumberUtil.isNumber(extaxUnitprice)) {
                            settlementBookStatementDetailVO.setExtaxUnitprice(new BigDecimal(extaxUnitprice));
                        } else {
                            settlementBookStatementDetailVO.setErrorMsg("合同单价（除税）格式不正确！");
                            errorsMsgBuilder.append("合同单价（除税）格式不正确！");
                        }
                    }



                    if (StringUtils.isNotBlank(insettlementUnitprice)) {
                        if (NumberUtil.isNumber(insettlementUnitprice)) {
                            settlementBookStatementDetailVO.setInsettlementUnitprice(new BigDecimal(insettlementUnitprice));
                        } else {
                            settlementBookStatementDetailVO.setErrorMsg("结算单价（含税）格式不正确！");
                            errorsMsgBuilder.append("结算单价（含税）格式不正确！");
                        }
                    }else{
                        settlementBookStatementDetailVO.setErrorMsg("结算单价（含税）不能为空");
                        errorsMsgBuilder.append("结算单价（含税）不能为空");
                    }
                    if (StringUtils.isNotBlank(exsettlementUnitprice)) {
                        if (NumberUtil.isNumber(exsettlementUnitprice)) {
                            settlementBookStatementDetailVO.setExsettlementUnitprice(new BigDecimal(exsettlementUnitprice));
                        } else {
                            settlementBookStatementDetailVO.setErrorMsg("结算单价（除税）格式不正确！");
                            errorsMsgBuilder.append("结算单价（除税）格式不正确！");
                        }
                    }else{
                        settlementBookStatementDetailVO.setErrorMsg("结算单价（除税）不能为空");
                        errorsMsgBuilder.append("结算单价（除税）不能为空");
                    }
                    if (StringUtils.isNotBlank(thisEngineeringQuantity)) {
                        if (NumberUtil.isNumber(thisEngineeringQuantity)) {
                            settlementBookStatementDetailVO.setThisEngineeringQuantity(new BigDecimal(thisEngineeringQuantity));
                        } else {
                            settlementBookStatementDetailVO.setErrorMsg("本期审核工程量格式不正确！");
                            errorsMsgBuilder.append("本期审核工程量格式不正确！");
                        }
                    }else{
                        settlementBookStatementDetailVO.setErrorMsg("本期审核工程量不能为空");
                        errorsMsgBuilder.append("本期审核工程量不能为空");
                    }

                    if (errorsMsgBuilder.length() <= 0) {
                        String key = settlementBookStatementDetailVO.getListingCode() + "-" + settlementBookStatementDetailVO.getSection() + "-" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "-" + settlementBookStatementDetailVO.getExsettlementUnitprice();
                        if (aloneMap.containsKey(key)){
                            settlementBookStatementDetailVO.setErrorMsg(settlementBookStatementDetailVO.getListingCode()+":数据重复!");
                            errorsMsgBuilder.append(key+"数据重复!");
                        }else{
                            aloneMap.put(key,"1");
                        }
                    }
                    if (contractListCodeMap.containsKey(settlementBookStatementDetailVO.getListingCode())) {
                        OutcontractSubcontractUnitPriceVO outcontractSubcontractUnitPriceVO = contractListCodeMap.get(settlementBookStatementDetailVO.getListingCode()).stream().findFirst().get();
                        settlementBookStatementDetailVO.setSource("1");//合同内
                    }else {
                        settlementBookStatementDetailVO.setSource("2");//合同外
                    }


                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(settlementBookStatementDetailVO);
                    } else {
                        successList.add(settlementBookStatementDetailVO);
                    }
                }
            }
        }

        // 处理前端传入数据
        List<SettlementBookStatementDetailVO> detailList = JSONArray.parseArray(detailVOS, SettlementBookStatementDetailVO.class);
//        List<SettlementBookStatementDetailVO> lastDetialList = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(detailList)){
//            //不能删除的数据
//            lastDetialList = detailList.stream().filter(s -> !"del".equals(s.getRowState()) && s.getIsDeleted().equals("否")).collect(Collectors.toList());
//        }
        List<SettlementBookStatementDetailVO> pcList = new ArrayList<>(); // 合同带出的原数据的voList
        for (SettlementBookStatementDetailVO vo : detailList) {
            vo.setIntaxAddition(vo.getIntaxAddition() != null ? vo.getIntaxAddition() : BigDecimal.ZERO);
            vo.setExtaxAddition(vo.getExtaxAddition() != null ? vo.getExtaxAddition() : BigDecimal.ZERO);
            vo.setThisAmountsTax(vo.getThisAmountsTax() != null ? vo.getThisAmountsTax() : BigDecimal.ZERO);
            vo.setThisAmountsNotax(vo.getThisAmountsNotax() != null ? vo.getThisAmountsNotax() : BigDecimal.ZERO);
            vo.setChildren(null);
            pcList.add(vo);
        }


        //过滤出上期带入数据
        Map<String, List<SettlementBookStatementDetailVO>> pcMap = new HashMap<>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pcList)){
            pcMap = pcList.stream().filter(s->"del"!=s.getRowState()).collect(
                    Collectors.groupingBy(
                            s->s.getListingCode() + "-" + s.getSection() + "-" + s.getInsettlementUnitprice() + "-" + s.getExsettlementUnitprice()
                    ));
        }

        Map<String, List<SettlementBookStatementDetailVO>> excelDataMap = new HashMap<>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(successList)){
            excelDataMap = successList.stream().filter(s->"del"!=s.getRowState()).collect(
                    Collectors.groupingBy(
                            s->s.getListingCode() + "-" + s.getSection() + "-" + s.getInsettlementUnitprice() + "-" + s.getExsettlementUnitprice()
                    ));
        }

//        for(SettlementBookStatementDetailVO settlementBookStatementDetailVO : pcList){
//            String key = settlementBookStatementDetailVO.getListingCode() + "-" + settlementBookStatementDetailVO.getSection() + "-" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "-" + settlementBookStatementDetailVO.getExsettlementUnitprice();
//            if (excelDataMap.containsKey(key)){
//                List<SettlementBookStatementDetailVO> consultotherfinaldetailVOS = excelDataMap.get(key);
//                SettlementBookStatementDetailVO consultotherfinaldetailVOExcel = consultotherfinaldetailVOS.stream().findFirst().get();
//                //导入的本期数量
//                BigDecimal quantity = consultotherfinaldetailVOExcel.getThisEngineeringQuantity();
//                settlementBookStatementDetailVO.setQuantity(quantity);
//                settlementBookStatementDetailVO.setCurExtaxPrice(ComputeUtil.safeMultiply(quantity,consultotherfinaldetailVO.getUnitprice()));
//                settlementBookStatementDetailVO.setCurIntaxPrice(ComputeUtil.safeMultiply(quantity,consultotherfinaldetailVO.getTaxUnitprice()));
//                settlementBookStatementDetailVO.setAmounts(ComputeUtil.safeMultiply(consultotherfinaldetailVO.getCumExtaxPrice(),consultotherfinaldetailVO.getCurExtaxPrice()));
//                settlementBookStatementDetailVO.setTaxAmounts(ComputeUtil.safeMultiply(consultotherfinaldetailVO.getCumIntaxPrice(),consultotherfinaldetailVO.getCurIntaxPrice()));
//            }
//        }
        // pcList比较excelMap， 并计算
        for (SettlementBookStatementDetailVO vo : pcList) {
            String code = vo.getListingCode() + "_" + vo.getSection() + "_" + vo.getInsettlementUnitprice() + "_" + vo.getExsettlementUnitprice();
            if (excelMap.containsKey(code)) {
                vo.setThisEngineeringQuantity(excelMap.get(code));
                vo.setThisAmountsTax(ComputeUtil.safeMultiply(vo.getInsettlementUnitprice(),vo.getThisEngineeringQuantity()));//本次审核金额(含税)
                vo.setThisAmountsNotax(ComputeUtil.safeMultiply(vo.getExsettlementUnitprice(), vo.getThisEngineeringQuantity()));//本次审核金额(除税)
                vo.setQuantities(ComputeUtil.safeAdd(vo.getCumulativeEngineeringQuantity(),vo.getThisEngineeringQuantity()));//工程量
                vo.setIntaxAddition(ComputeUtil.safeAdd(vo.getAccruingAmountsTax(),vo.getThisAmountsTax()));//合价(含税)
                vo.setExtaxAddition(ComputeUtil.safeAdd(vo.getAccruingAmountsNotax(),vo.getThisAmountsNotax()));//合价(除税)
            }
        }

        //汇总新增的数据
        for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : successList){

            String key = settlementBookStatementDetailVO.getListingCode() + "-" + settlementBookStatementDetailVO.getSection() + "-" + settlementBookStatementDetailVO.getInsettlementUnitprice() + "-" + settlementBookStatementDetailVO.getExsettlementUnitprice();
            BigDecimal thisEngineeringQuantity = settlementBookStatementDetailVO.getThisEngineeringQuantity();
            if (!pcMap.containsKey(key)){
                settlementBookStatementDetailVO.setThisAmountsTax(ComputeUtil.safeMultiply(settlementBookStatementDetailVO.getInsettlementUnitprice(),settlementBookStatementDetailVO.getThisEngineeringQuantity()));//本次审核金额(含税)
                settlementBookStatementDetailVO.setThisAmountsNotax(ComputeUtil.safeMultiply(settlementBookStatementDetailVO.getExsettlementUnitprice(), settlementBookStatementDetailVO.getThisEngineeringQuantity()));//本次审核金额(除税)
                settlementBookStatementDetailVO.setQuantities(ComputeUtil.safeAdd(settlementBookStatementDetailVO.getCumulativeEngineeringQuantity(),settlementBookStatementDetailVO.getThisEngineeringQuantity()));//工程量
                settlementBookStatementDetailVO.setIntaxAddition(ComputeUtil.safeAdd(settlementBookStatementDetailVO.getAccruingAmountsTax(),settlementBookStatementDetailVO.getThisAmountsTax()));//合价(含税)
                settlementBookStatementDetailVO.setExtaxAddition(ComputeUtil.safeAdd(settlementBookStatementDetailVO.getAccruingAmountsNotax(),settlementBookStatementDetailVO.getThisAmountsNotax()));//合价(除税)

                pcList.add(settlementBookStatementDetailVO);
            }
        }

        List<SettlementBookStatementDetailVO> distinctList = pcList.stream()
                .collect(Collectors.collectingAndThen(
                        Collectors.toMap(
                                SettlementBookStatementDetailVO::getInnercode,
                                Function.identity(),
                                (existing, replacement) -> existing
                        ),
                        map -> new ArrayList<>(map.values())
                ));

// 再转换为Map（通常无需此步，直接使用上述Map即可）
        Map<String, SettlementBookStatementDetailVO> attacMap = distinctList.stream()
                .collect(Collectors.toMap(
                        SettlementBookStatementDetailVO::getInnercode,
                        Function.identity()
                ));
        Map<String, List<SettlementBookStatementDetailVO>> mapDouble = pcList.stream().collect(
                Collectors.groupingBy(
                        s -> s.getListingCode()+'_'+s.getSection()
                ));
        Map<String, List<SettlementBookStatementDetailVO>> mapPcDouble = pcList.stream().filter(s->"否".equals(s.getIsDeleted())).collect(
                Collectors.groupingBy(
                        s -> s.getListingCode()+'_'+s.getSection()
                ));
        List<SettlementBookStatementDetailVO> detailVOListNew  = new ArrayList<>();
        for (SettlementBookStatementDetailVO settlementBookStatementDetailVO : pcList){
            //校验
            String subitemCode = settlementBookStatementDetailVO.getListingCode();
            String section = settlementBookStatementDetailVO.getSection();
            String innercodeDouble = null;
            String s= null;
            StringBuilder errorsMsgBuilder = new StringBuilder();

            if (subitemCode.length() == 4){
                innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
                errorsMsgBuilder.append(checkDouble(innercodeDouble, mapDouble));
                errorsMsgBuilder.append(checkPcDouble(innercodeDouble, mapPcDouble));
            }
            if (subitemCode.length() == 6){
                innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
                errorsMsgBuilder.append(checkDouble(innercodeDouble, mapDouble));
                errorsMsgBuilder.append(checkPcDouble(innercodeDouble, mapPcDouble));
                innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
                errorsMsgBuilder.append(checkDouble(innercodeDouble, mapDouble));
                errorsMsgBuilder.append(checkPcDouble(innercodeDouble, mapPcDouble));
            }
            if (subitemCode.length() > 6){
                innercodeDouble = subitemCode.substring(0, 6) + "_" + section;
                errorsMsgBuilder.append(checkDouble(innercodeDouble, mapDouble));
                errorsMsgBuilder.append(checkPcDouble(innercodeDouble, mapPcDouble));
                innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
                errorsMsgBuilder.append(checkDouble(innercodeDouble, mapDouble));
                errorsMsgBuilder.append(checkPcDouble(innercodeDouble, mapPcDouble));
                innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
                errorsMsgBuilder.append(checkDouble(innercodeDouble, mapDouble));
                errorsMsgBuilder.append(checkPcDouble(innercodeDouble, mapPcDouble));
            }
            if (errorsMsgBuilder.length() <= 0){
//                lastDetialList
                //校验, 如果父级或子集已经发生业务数据,不允许新增
                SettlementBookStatementDetailVO bookStatementDetailVO = BeanMapper.map(settlementBookStatementDetailVO, SettlementBookStatementDetailVO.class);
//                bookStatementDetailVO.setIsDeleted("是");
                detailVOListNew.add(bookStatementDetailVO);
            }else{
                SettlementBookStatementDetailVO bookStatementDetailVO = BeanMapper.map(settlementBookStatementDetailVO, SettlementBookStatementDetailVO.class);
                bookStatementDetailVO.setErrorMsg(errorsMsgBuilder.toString());
                errorList.add(bookStatementDetailVO);
            }
        }

        List<SettlementBookStatementDetailVO> settlementBookStatementDetailVOS = setTidAndTpid(detailVOListNew, attacMap);

        // 汇总
        List<String> successTpids = settlementBookStatementDetailVOS.stream().map(SettlementBookStatementDetailVO::getTpid).collect(Collectors.toList());
        for (SettlementBookStatementDetailVO vo : settlementBookStatementDetailVOS) {
            vo.setId(IdWorker.getId());
            List<SettlementBookStatementDetailVO> detailVOListTid = getDetailByPidPlanCsf(vo.getTid(), settlementBookStatementDetailVOS);
            if (CollectionUtils.isNotEmpty(detailVOListTid)) {
                List<SettlementBookStatementDetailVO> lastDetails = detailVOListTid.stream().filter(s -> !successTpids.contains(s.getTid())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(lastDetails)) {
                    vo.setThisEngineeringQuantity(null);
                    vo.setQuantities(null);
                    vo.setIntaxUnitprice(null);
                    vo.setExtaxUnitprice(null);
                    vo.setInsettlementUnitprice(null);
                    vo.setExsettlementUnitprice(null);
                    vo.setThisAmountsTax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsTax).reduce(BigDecimal.ZERO, BigDecimal::add));
                    vo.setThisAmountsNotax(lastDetails.stream().map(SettlementBookStatementDetailVO::getThisAmountsNotax).reduce(BigDecimal.ZERO, BigDecimal::add));
                    vo.setIntaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getIntaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
                    vo.setExtaxAddition(lastDetails.stream().map(SettlementBookStatementDetailVO::getExtaxAddition).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
            }
            detailVOListTid.clear();
        }
        successList = settlementBookStatementDetailVOS;
        //构建树
        successList = createTreeData(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", pcList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    private String checkDouble(String innercode, Map<String, List<SettlementBookStatementDetailVO>> mapDouble) {
        if (mapDouble.containsKey(innercode)){
            List<SettlementBookStatementDetailVO> subcontractingvolumedetailVOS = mapDouble.get(innercode);
            if (subcontractingvolumedetailVOS.size() > 1){
                return "父级编码重复,无法新增!";
            }
//            for (SettlementBookStatementDetailVO vo :subcontractingvolumedetailVOS){
//                if (vo.getInsettlementUnitprice() != null || vo.getExsettlementUnitprice() != null || vo.getExtaxUnitprice() != null || vo.getIntaxUnitprice() != null){
//                    return "父级已有数据,无法新增!";
//                }
//            }

        }
        return "";
    }
    private String checkPcDouble(String innercode, Map<String, List<SettlementBookStatementDetailVO>> mapDouble) {
        if (mapDouble.containsKey(innercode)){
            List<SettlementBookStatementDetailVO> subcontractingvolumedetailVOS = mapDouble.get(innercode);
            for (SettlementBookStatementDetailVO vo :subcontractingvolumedetailVOS){
                if (vo.getInsettlementUnitprice() != null || vo.getExsettlementUnitprice() != null || vo.getExtaxUnitprice() != null || vo.getIntaxUnitprice() != null){
                    return "父级已有数据,无法新增!";
                }
            }


        }
        return "";
    }

    List<SettlementBookStatementDetailVO> detailVOList = new ArrayList<>();
    private List<SettlementBookStatementDetailVO> getDetailByPidPlanCsf(String tid, List<SettlementBookStatementDetailVO> list) {

        for (SettlementBookStatementDetailVO vo : list) {
            if (tid != null && tid.equals(vo.getTpid())) {
                getDetailByPidPlanCsf(vo.getTid(), list);
                detailVOList.add(vo);
            }
        }
        return detailVOList;
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<SettlementBookStatementDetailVO> setTidAndTpid(List<SettlementBookStatementDetailVO> vos, Map<String, SettlementBookStatementDetailVO> map) {
        if (vos == null) {
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            SettlementBookStatementDetailVO settlementBookStatementDetailVO = vos.get(i);
            //设置父级id
            String innercode = settlementBookStatementDetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                settlementBookStatementDetailVO.setTpid(pid.toString());
            } else {
                settlementBookStatementDetailVO.setTpid("");
            }
        }

        return vos;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<SettlementBookStatementDetailVO> createTreeData(List<SettlementBookStatementDetailVO> list) {
        List<SettlementBookStatementDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SettlementBookStatementDetailVO> listMap = new HashMap<>();
        for (SettlementBookStatementDetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SettlementBookStatementDetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SettlementBookStatementDetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SettlementBookStatementDetailVO> child = (List<SettlementBookStatementDetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SettlementBookStatementDetailVO> children = new ArrayList<SettlementBookStatementDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SettlementBookStatementDetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }
}
