/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settlementmanage.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlementmanage.service.ITurnoverLeaseSetDetailService;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSetDetailVO;
import com.ejianc.business.settlementmanage.vo.TurnoverLeaseSettlementVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"turnoverLeaseSettlementExport"})
public class ExcelTurnoverLeaseSettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITurnoverLeaseSetDetailService turnoverLeaseSetDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @RequestMapping(value={"/downloadTurnoverLeaseSettlementDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadTurnoverLeaseSettlementDetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"TurnoverLeaseSetDetail-import.xlsx", (String)"\u5468\u8f6c\u79df\u8d41\u7ed3\u7b97\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportTurnoverLeaseSettlementDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTurnoverLeaseSettlementDetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<TurnoverLeaseSetDetailVO> successList = new ArrayList<TurnoverLeaseSetDetailVO>();
        ArrayList<TurnoverLeaseSetDetailVO> errorList = new ArrayList<TurnoverLeaseSetDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                int num = 0;
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = new TurnoverLeaseSetDetailVO();
                List datas = (List)result.get(i);
                turnoverLeaseSetDetailVO.setId(IdWorker.getId());
                turnoverLeaseSetDetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? (String)datas.get(10) : null);
                if (num > 0) {
                    errorList.add(turnoverLeaseSetDetailVO);
                    continue;
                }
                successList.add(turnoverLeaseSetDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    @RequestMapping(value={"/excelExportTurnoverLeaseSettlementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTurnoverLeaseSettlementFromPage(@RequestBody List<TurnoverLeaseSetDetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = list.get(i);
                turnoverLeaseSetDetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<TurnoverLeaseSetDetailVO>> beans = new HashMap<String, List<TurnoverLeaseSetDetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TurnoverLeaseSetDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportTurnoverLeaseSettlementDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTurnoverLeaseSettlementDatabase(@RequestBody TurnoverLeaseSettlementVO turnoverLeaseSettlementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)turnoverLeaseSettlementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.turnoverLeaseSetDetailService.list((Wrapper)queryWrapper);
        List tnrnoverLeaseSetDetailVOList = BeanMapper.mapList((Iterable)list, TurnoverLeaseSetDetailVO.class);
        if (tnrnoverLeaseSetDetailVOList != null && tnrnoverLeaseSetDetailVOList.size() > 0) {
            for (int i = 0; i < tnrnoverLeaseSetDetailVOList.size(); ++i) {
                TurnoverLeaseSetDetailVO turnoverLeaseSetDetailVO = (TurnoverLeaseSetDetailVO)((Object)tnrnoverLeaseSetDetailVOList.get(i));
                turnoverLeaseSetDetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", tnrnoverLeaseSetDetailVOList);
        ExcelExport.getInstance().export("TurnoverLeaseSetDetail-export.xlsx", beans, response);
    }
}

