package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.UnitHystrix;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2023/11/28 15:51
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = UnitHystrix.class)
public interface IUnitApi {

    @PostMapping(value = "/api/unitApi/getAllEnabledList")
    CommonResponse<List<UnitShareVO>> findAllEnabledList(@RequestBody List<String> unitNames);
    @PostMapping(value = "/api/unitApi/getAllByIds")
    CommonResponse<List<UnitShareVO>> getAllByIds(@RequestBody List<Long> ids);

}
