package com.ejianc.foundation.support.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.hystrix.ShareSupplierHystrix;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 供应商API
 *
 * @author CJ
 * @Description:
 * @date 2020/6/30 14:58
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareSupplierHystrix.class)
public interface IShareSupplierApi {

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("/api/shareSupplierApi/queryById")
    CommonResponse<SupplierVO> queryById(@RequestParam(value = "id") Long id);

    /**
     * 根据ids查询项目详情
     *
     * @param ids
     * @return
     */
    @GetMapping(value = "/api/shareSupplierApi/querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids);
    
    /**
     * 根据名称查询唯一匹配的客户信息
     *
     * @param name
     * @param tenantId
     * @return
     */
    @GetMapping("/api/shareSupplierApi/findOneByName")
    CommonResponse<SupplierVO> findOneByName(@RequestParam(value = "name") String name,
                                                 @RequestParam(value = "tenantId") Long tenantId);
}
