package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ProjectSetHystrix;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 项目立项rpc服务
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = ProjectSetHystrix
        .class)
public interface IProjectSetApi {

    /**
     * 推送生成项目池
     *
     */
    @PostMapping(value = "/api/projectPoolSetApi/pushProjectPoolSet")
    public CommonResponse<String> pushProjectPoolSet(@RequestBody byte[] supplyByte);

    /**
     * 项目立项撤回 删除已生成的项目信息
     *
     * @return supplyByte 是SupplierVO的json字符串生成的字节数组
     */
    @GetMapping(value = "/api/projectPoolSetApi/callBackProjectPool")
    public CommonResponse<String> callBackProjectPool(@RequestParam Long id);


    /**
     * @param projectId      项目id
     * @param businessStatus 业务状态
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @description: 项目业务状态回写
     * @author songlx
     * @date: 2022/3/21
     */
    @Deprecated
    @GetMapping(value = "/api/projectPoolSetApi/changeProjectBusinessStatus")
    CommonResponse<String> changeProjectBusinessStatus(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "businessStatus") String businessStatus);

    /**
     * @param projectId       项目id
     * @param projectStatus   项目状态：1、在建 2、项目中止 3、竣工 4、保修
     * @param businessStatus  业务状态：1、开工准备 2、在建 3、停工 5、完工 4、项目中止 6、竣工验收 12、保修中 13、保修结束
     * @param settleStatus    结算状态：1、未决算 8、决算中 9、已决算
     * @param archiveStatus   归档状态：10、资料未归档 11、资料已归档
     * @param capitalStatus   资金管控状态：14、开账正常 15、资金冻结 16、成本关门  17、已销账
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @description: 更新项目各种状态，为空则不更新该状态，不为空则更新,同时更新该项目的父项目相关状态
     * @date: 2022/8/24
     */
    @GetMapping(value = "/api/projectPoolSetApi/changeProjectStatus")
    CommonResponse<String> changeProjectStatus(@RequestParam(value = "projectId") Long projectId,
                                               @RequestParam(value = "projectStatus", required = false) String projectStatus,
                                               @RequestParam(value = "businessStatus", required = false) String businessStatus,
                                               @RequestParam(value = "settleStatus", required = false) String settleStatus,
                                               @RequestParam(value = "archiveStatus", required = false) String archiveStatus,
                                               @RequestParam(value = "capitalStatus", required = false) String capitalStatus
    );

    /**
     * @param projectId      项目id
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @description: 根据项目id查询
     * @date: 2022/4/14
     */
    @GetMapping(value = "/api/projectPoolSetApi/getProjectId")
    CommonResponse<ProjectPoolSetVO> getProjectId(@RequestParam(value = "projectId") Long projectId);

    /**
     * 根据集合查询多条项目
     * @param projectIds
     * @return
     */
    @PostMapping(value = "/api/projectPoolSetApi/getProjectListIds")
    CommonResponse<List<ProjectPoolDTO>> getProjectListIds(@RequestBody List<Long> projectIds);
}
