package com.ejianc.foundation.cpmpany.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 公司潜亏情况子表
 * 
 * @author generator
 * 
 */
public class CompanyStateDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String errorMsg;
    private Long pid; // 主表ID
    private String memo; // 备注
    private String branch; // 分公司
    private Long projectId; // 项目名称(ID)
    private String projectName; // 项目名称
    private Integer projectStatus; // 项目状态
    private Date actualCommencement; // 实际开工日期
    private BigDecimal contractAmount; // 合同金额（含补充协议）
    private BigDecimal taxRate; // 税率
    private BigDecimal profitMargin; // 目标 利润率Y
    private BigDecimal freeIncomeTax; // 预计不含税总收入 A1
    private BigDecimal totalOutputTax; // 预计总销项税 A2
    private BigDecimal revenueIncludingTax; // 预计含税总收入
    private BigDecimal costExcludingTax; // 预计不含税总成本
    private BigDecimal inputTaxVatSurcharge; // 预计总进项税、增值税、附加税等 B2'
    private BigDecimal totalFinancialExpenses; // 预计总财务费用 C
    private BigDecimal costIncludingTax; // 预计含税总成本 B=B1+B2+C
    private BigDecimal totalProfitLoss; // 预计总盈亏 D=A-B
    private BigDecimal totalProfitMargin; // 预计总利润率 E=D/A
    private BigDecimal cumulativeFreeIncome; // 累计不含税收入 a1
    private BigDecimal cumulativeOutputTax; // 累计销项税 a2
    private BigDecimal cumulativeRevenueIncludingTax; // 累计含税收入 a=a1+a2
    private BigDecimal cumulativeFreeCost; // 累计不含税成本 b1
    private BigDecimal cumulativeInputTaxVatSurcharge; // 累计进项税、应纳增值税、附加税等
    private BigDecimal cumulativeFinancialExpenses; // 累计财务费用 c
    private BigDecimal cumulativeCostIncludingTax; // 累计含税成本 b=b1+b2+c
    private BigDecimal cumulativeProfitLoss; // 累计盈亏 d=a-b
    private BigDecimal cumulativeProfitMargin; // 累计利润率 e=d/a
    private BigDecimal mainBusinessIncome; // 主营业务收入
    private BigDecimal mainBusinessCost; // 主营业务成本
    private BigDecimal grossProfit; // 毛利
    private BigDecimal taxesSurcharges; // 税金及附加
    private BigDecimal managementExpenses; // 管理费用
    private BigDecimal rdExpenses; // 研发费用
    private BigDecimal financialExpenses; // 财务费用
    private BigDecimal assetCreditImpairmentLoss; // 资产/信用减值损失
    private BigDecimal otherIncomeExpenses; // 其他（收益负数列示）
    private BigDecimal financialProjectProfit; // 财务项目净利m
    private String menon; // 备注

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    private BigDecimal potentialLossAmount; // 潜亏金额 = 商务累计盈亏 - (财务项目净利 + 减值损失)
    private Integer potentialLossType; // 潜亏类别 (1:一类潜亏, 2:二类潜亏, 3:正常项目)
    private Integer potentialLossTypeCompletion; // 潜亏类别-完工预计经营情况 (1:一类潜亏, 2:二类潜亏, 3:正常项目)
    private Integer potentialLossTypeAccumulated; // 潜亏类别-开累经营情况 (1:一类潜亏, 2:二类潜亏, 3:正常项目)

    public BigDecimal getPotentialLossAmount() {
        return potentialLossAmount;
    }

    public void setPotentialLossAmount(BigDecimal potentialLossAmount) {
        this.potentialLossAmount = potentialLossAmount;
    }

    public Integer getPotentialLossType() {
        return potentialLossType;
    }

    public void setPotentialLossType(Integer potentialLossType) {
        this.potentialLossType = potentialLossType;
    }

    public Integer getPotentialLossTypeCompletion() {
        return potentialLossTypeCompletion;
    }

    public void setPotentialLossTypeCompletion(Integer potentialLossTypeCompletion) {
        this.potentialLossTypeCompletion = potentialLossTypeCompletion;
    }

    public Integer getPotentialLossTypeAccumulated() {
        return potentialLossTypeAccumulated;
    }

    public void setPotentialLossTypeAccumulated(Integer potentialLossTypeAccumulated) {
        this.potentialLossTypeAccumulated = potentialLossTypeAccumulated;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public Date getActualCommencement() {
        return actualCommencement;
    }

    public void setActualCommencement(Date actualCommencement) {
        this.actualCommencement = actualCommencement;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getProfitMargin() {
        return profitMargin;
    }

    public void setProfitMargin(BigDecimal profitMargin) {
        this.profitMargin = profitMargin;
    }
    public BigDecimal getFreeIncomeTax() {
        return freeIncomeTax;
    }

    public void setFreeIncomeTax(BigDecimal freeIncomeTax) {
        this.freeIncomeTax = freeIncomeTax;
    }
    public BigDecimal getTotalOutputTax() {
        return totalOutputTax;
    }

    public void setTotalOutputTax(BigDecimal totalOutputTax) {
        this.totalOutputTax = totalOutputTax;
    }
    public BigDecimal getRevenueIncludingTax() {
        return revenueIncludingTax;
    }

    public void setRevenueIncludingTax(BigDecimal revenueIncludingTax) {
        this.revenueIncludingTax = revenueIncludingTax;
    }
    public BigDecimal getCostExcludingTax() {
        return costExcludingTax;
    }

    public void setCostExcludingTax(BigDecimal costExcludingTax) {
        this.costExcludingTax = costExcludingTax;
    }
    public BigDecimal getInputTaxVatSurcharge() {
        return inputTaxVatSurcharge;
    }

    public void setInputTaxVatSurcharge(BigDecimal inputTaxVatSurcharge) {
        this.inputTaxVatSurcharge = inputTaxVatSurcharge;
    }
    public BigDecimal getTotalFinancialExpenses() {
        return totalFinancialExpenses;
    }

    public void setTotalFinancialExpenses(BigDecimal totalFinancialExpenses) {
        this.totalFinancialExpenses = totalFinancialExpenses;
    }
    public BigDecimal getCostIncludingTax() {
        return costIncludingTax;
    }

    public void setCostIncludingTax(BigDecimal costIncludingTax) {
        this.costIncludingTax = costIncludingTax;
    }
    public BigDecimal getTotalProfitLoss() {
        return totalProfitLoss;
    }

    public void setTotalProfitLoss(BigDecimal totalProfitLoss) {
        this.totalProfitLoss = totalProfitLoss;
    }
    public BigDecimal getTotalProfitMargin() {
        return totalProfitMargin;
    }

    public void setTotalProfitMargin(BigDecimal totalProfitMargin) {
        this.totalProfitMargin = totalProfitMargin;
    }
    public BigDecimal getCumulativeFreeIncome() {
        return cumulativeFreeIncome;
    }

    public void setCumulativeFreeIncome(BigDecimal cumulativeFreeIncome) {
        this.cumulativeFreeIncome = cumulativeFreeIncome;
    }
    public BigDecimal getCumulativeOutputTax() {
        return cumulativeOutputTax;
    }

    public void setCumulativeOutputTax(BigDecimal cumulativeOutputTax) {
        this.cumulativeOutputTax = cumulativeOutputTax;
    }
    public BigDecimal getCumulativeRevenueIncludingTax() {
        return cumulativeRevenueIncludingTax;
    }

    public void setCumulativeRevenueIncludingTax(BigDecimal cumulativeRevenueIncludingTax) {
        this.cumulativeRevenueIncludingTax = cumulativeRevenueIncludingTax;
    }
    public BigDecimal getCumulativeFreeCost() {
        return cumulativeFreeCost;
    }

    public void setCumulativeFreeCost(BigDecimal cumulativeFreeCost) {
        this.cumulativeFreeCost = cumulativeFreeCost;
    }
    public BigDecimal getCumulativeInputTaxVatSurcharge() {
        return cumulativeInputTaxVatSurcharge;
    }

    public void setCumulativeInputTaxVatSurcharge(BigDecimal cumulativeInputTaxVatSurcharge) {
        this.cumulativeInputTaxVatSurcharge = cumulativeInputTaxVatSurcharge;
    }
    public BigDecimal getCumulativeFinancialExpenses() {
        return cumulativeFinancialExpenses;
    }

    public void setCumulativeFinancialExpenses(BigDecimal cumulativeFinancialExpenses) {
        this.cumulativeFinancialExpenses = cumulativeFinancialExpenses;
    }
    public BigDecimal getCumulativeCostIncludingTax() {
        return cumulativeCostIncludingTax;
    }

    public void setCumulativeCostIncludingTax(BigDecimal cumulativeCostIncludingTax) {
        this.cumulativeCostIncludingTax = cumulativeCostIncludingTax;
    }
    public BigDecimal getCumulativeProfitLoss() {
        return cumulativeProfitLoss;
    }

    public void setCumulativeProfitLoss(BigDecimal cumulativeProfitLoss) {
        this.cumulativeProfitLoss = cumulativeProfitLoss;
    }
    public BigDecimal getCumulativeProfitMargin() {
        return cumulativeProfitMargin;
    }

    public void setCumulativeProfitMargin(BigDecimal cumulativeProfitMargin) {
        this.cumulativeProfitMargin = cumulativeProfitMargin;
    }
    public BigDecimal getMainBusinessIncome() {
        return mainBusinessIncome;
    }

    public void setMainBusinessIncome(BigDecimal mainBusinessIncome) {
        this.mainBusinessIncome = mainBusinessIncome;
    }
    public BigDecimal getMainBusinessCost() {
        return mainBusinessCost;
    }

    public void setMainBusinessCost(BigDecimal mainBusinessCost) {
        this.mainBusinessCost = mainBusinessCost;
    }
    public BigDecimal getGrossProfit() {
        return grossProfit;
    }

    public void setGrossProfit(BigDecimal grossProfit) {
        this.grossProfit = grossProfit;
    }
    public BigDecimal getTaxesSurcharges() {
        return taxesSurcharges;
    }

    public void setTaxesSurcharges(BigDecimal taxesSurcharges) {
        this.taxesSurcharges = taxesSurcharges;
    }
    public BigDecimal getManagementExpenses() {
        return managementExpenses;
    }

    public void setManagementExpenses(BigDecimal managementExpenses) {
        this.managementExpenses = managementExpenses;
    }
    public BigDecimal getRdExpenses() {
        return rdExpenses;
    }

    public void setRdExpenses(BigDecimal rdExpenses) {
        this.rdExpenses = rdExpenses;
    }
    public BigDecimal getFinancialExpenses() {
        return financialExpenses;
    }

    public void setFinancialExpenses(BigDecimal financialExpenses) {
        this.financialExpenses = financialExpenses;
    }
    public BigDecimal getAssetCreditImpairmentLoss() {
        return assetCreditImpairmentLoss;
    }

    public void setAssetCreditImpairmentLoss(BigDecimal assetCreditImpairmentLoss) {
        this.assetCreditImpairmentLoss = assetCreditImpairmentLoss;
    }
    public BigDecimal getOtherIncomeExpenses() {
        return otherIncomeExpenses;
    }

    public void setOtherIncomeExpenses(BigDecimal otherIncomeExpenses) {
        this.otherIncomeExpenses = otherIncomeExpenses;
    }
    public BigDecimal getFinancialProjectProfit() {
        return financialProjectProfit;
    }

    public void setFinancialProjectProfit(BigDecimal financialProjectProfit) {
        this.financialProjectProfit = financialProjectProfit;
    }
    public String getMenon() {
        return menon;
    }

    public void setMenon(String menon) {
        this.menon = menon;
    }
    
}
