package com.ejianc.foundation.share.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 供应商准入---证书
 * 
 * @author generator
 * 
 */
public class CertsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String certCode; // 证件编号
    private String certName; // 证件名称
    private Long certId; // 证件名称id
    private String awardOrg; // 发证单位
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date awardDate; // 授予时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date timeValidity; // 有效期至
    private Long pid; // 主表id
    private String qualificationInformation; //资质信息
    private String qualificationLevel; //资质等级


    public String getQualificationInformation() {
        return qualificationInformation;
    }

    public void setQualificationInformation(String qualificationInformation) {
        this.qualificationInformation = qualificationInformation;
    }

    public String getQualificationLevel() {
        return qualificationLevel;
    }

    public void setQualificationLevel(String qualificationLevel) {
        this.qualificationLevel = qualificationLevel;
    }




    /**
     * 证件编号
     */
    public String getCertCode() {
        return certCode;
    }

    /**
     * 证件编号
     */
    public void setCertCode(String certCode) {
        this.certCode = certCode;
    }
    /**
     * 证件名称
     */
    public String getCertName() {
        return certName;
    }

    /**
     * 证件名称
     */
    public void setCertName(String certName) {
        this.certName = certName;
    }
    /**
     * 证件名称id
     */
    @ReferSerialTransfer(referCode="supplier_the_scope")
    public Long getCertId() {
        return certId;
    }

    /**
     * 证件名称id
     */
    @ReferDeserialTransfer
    public void setCertId(Long certId) {
        this.certId = certId;
    }
    /**
     * 发证单位
     */
    public String getAwardOrg() {
        return awardOrg;
    }

    /**
     * 发证单位
     */
    public void setAwardOrg(String awardOrg) {
        this.awardOrg = awardOrg;
    }
    /**
     * 授予时间
     */
    public Date getAwardDate() {
        return awardDate;
    }

    /**
     * 授予时间
     */
    public void setAwardDate(Date awardDate) {
        this.awardDate = awardDate;
    }
    /**
     * 有效期至
     */
    public Date getTimeValidity() {
        return timeValidity;
    }
    /**
     * 有效期至
     */
    public void setTimeValidity(Date timeValidity) {
        this.timeValidity = timeValidity;
    }

    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
