package com.ejianc.foundation.share.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * @author songlx
 * @version 1.0
 * @description: 桌面项目统计
 * @date 2022/4/26
 */
public class ProjectDesktopVO implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 累计项目立项数
     */
    private BigDecimal totalNum;

    /**
     * 在建项目数
     */
    private BigDecimal buildNum;
    /**
     *本年新增项目数
     */
    private BigDecimal thisYearProjectNum;
    private boolean yearProjectNumAddFlag;
    private boolean monthProjectNumAddFlag;

    private Integer yearChangeNum; //项目月度变化数量，正数，新增、减少以thisYearProjectNumAddFlag为标识
    private Integer monthChangeNum; //项目月度变化数量，正数，新增、减少以thisYearProjectNumAddFlag为标识

    public boolean isMonthProjectNumAddFlag() {
        return monthProjectNumAddFlag;
    }

    public void setMonthProjectNumAddFlag(boolean monthProjectNumAddFlag) {
        this.monthProjectNumAddFlag = monthProjectNumAddFlag;
    }

    public Integer getYearChangeNum() {
        return yearChangeNum;
    }

    public void setYearChangeNum(Integer yearChangeNum) {
        this.yearChangeNum = yearChangeNum;
    }

    public Integer getMonthChangeNum() {
        return monthChangeNum;
    }

    public void setMonthChangeNum(Integer monthChangeNum) {
        this.monthChangeNum = monthChangeNum;
    }

    /**
     * 明细数据
     */
    private List<ProjectDesktopSubVO> detail;
    /**
     * 所有项目数
     */
    private BigDecimal totalNumAll;


    public BigDecimal getTotalNumAll() {
        return totalNumAll;
    }

    public boolean isYearProjectNumAddFlag() {
        return yearProjectNumAddFlag;
    }

    public void setYearProjectNumAddFlag(boolean yearProjectNumAddFlag) {
        this.yearProjectNumAddFlag = yearProjectNumAddFlag;
    }

    public void setTotalNumAll(BigDecimal totalNumAll) {
        this.totalNumAll = totalNumAll;
    }

    public ProjectDesktopVO() {
    }

    public ProjectDesktopVO(BigDecimal totalNum, BigDecimal buildNum) {
        this.totalNum = totalNum;
        this.buildNum = buildNum;
    }

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public BigDecimal getBuildNum() {
        return buildNum;
    }

    public void setBuildNum(BigDecimal buildNum) {
        this.buildNum = buildNum;
    }

    public BigDecimal getThisYearProjectNum() {
        return thisYearProjectNum;
    }

    public void setThisYearProjectNum(BigDecimal thisYearProjectNum) {
        this.thisYearProjectNum = thisYearProjectNum;
    }

    public List<ProjectDesktopSubVO> getDetail() {
        return detail;
    }

    public void setDetail(List<ProjectDesktopSubVO> detail) {
        this.detail = detail;
    }

}
