package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.PartHystrix;
import com.ejianc.foundation.share.vo.PartDocDetailVO;
import com.ejianc.foundation.share.vo.PartDocVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 分部分项
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = PartHystrix.class)
public interface IPartApi {



    /**
     *根据分部分项子表主键查询List
     *
     */
    @PostMapping(value = "/api/partApi/getPartDetailListByIds")
    CommonResponse<List<PartDocDetailVO>> getPartDetailListByIds(@RequestBody PartDocVO partDocVO);
    /**
     *根据分部分项主表主键查询List
     *
     */
    @PostMapping(value = "/api/partApi/getPartListByIds")
    CommonResponse<List<PartDocVO>> getPartListByIds(@RequestBody PartDocVO partDocVO);

}
