package com.ejianc.foundation.share.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 清单档案入库申请主实体
 * 
 * @author generator
 * 
 */
public class LabSubItemDocApplyVO extends BaseVO {


    private static final long serialVersionUID = 3288121943054060104L;
    private Integer billState; // 单据状态
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate; // 生效日期
    private Long employeeId; // 申请人id
    private String employeeName; // 申请人名称
    private String memo; // 备注
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date applyDate; // 申请日期
    private String applyItemType; // 清单档案类型：labsub-劳务清单，prosub-专业清单

    private String billCode; //申请单编码

    private List<LabSubItemDocApplyDetailVO> detailList = new ArrayList<>(); // 清单档案入库申请-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getApplyItemType() {
        return applyItemType;
    }

    public void setApplyItemType(String applyItemType) {
        this.applyItemType = applyItemType;
    }

    public List<LabSubItemDocApplyDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<LabSubItemDocApplyDetailVO> detailList) {
        this.detailList = detailList;
    }
}
