package com.ejianc.foundation.share.vo;

import com.ejianc.foundation.share.utils.ITreeNodeB;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 桌面项目统计
 * @date 2022/4/26
 */
public class ProjectDesktopSubParentVO implements ITreeNodeB,Serializable {

    private static final long serialVersionUID = 1L;

    private List<ITreeNodeB> children; //子集数据
    private Long id; // 项目id
    private Long parentProjectId; // 父项目
    //业务状态：1、开工准备 2、正式开工 3、停工 4、复工5、完工6、竣工验收 7、成本关门 8、决算中 9、已决算 10、资料未归档 11、资料已归档 12、保修中 13、保修结束 14、开账 15、资金冻结 16、资金恢复 17、已销账
    private String businessStatus;
    private String businessStatusName;
    private String projectStatus; // 项目状态：1、在建 2、项目中止 3、竣工 4、保修
    private String projectDate;

    private Date statusChangeTime; //状态变动日期

    public Date getStatusChangeTime() {
        return statusChangeTime;
    }

    public void setStatusChangeTime(Date statusChangeTime) {
        this.statusChangeTime = statusChangeTime;
    }

    public String getProjectDate() {
        return projectDate;
    }

    public void setProjectDate(String projectDate) {
        this.projectDate = projectDate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentProjectId() {
        return parentProjectId;
    }

    public void setParentProjectId(Long parentProjectId) {
        this.parentProjectId = parentProjectId;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getBusinessStatusName() {
        return businessStatusName;
    }

    public void setBusinessStatusName(String businessStatusName) {
        this.businessStatusName = businessStatusName;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentProjectId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
}
