package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.share.vo.dto.SubleadersDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/shareSupplierApi/")
public class SupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private IBankAccountService bankAccountService;

    @Autowired
    private IBankService bankService;
    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("queryById")
    public CommonResponse<SupplierDTO> queryById(@RequestParam(value = "id") Long id) {
        SupplierVO vo = supplierService.queryDetail(id);
        SupplierDTO dto = BeanMapper.map(vo, SupplierDTO.class);
        return CommonResponse.success("查询成功！！！！",dto);
    }


    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("selectById")
    public CommonResponse<SupplierDTO> selectById(@RequestParam(value = "id") Long id) {
        logger.info("id:"+id);
        SupplierEntity supplierEntity = supplierService.selectById(id);
        if(supplierEntity == null){
            return CommonResponse.error("查询失败");
        }
        QueryWrapper<BankAccountEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("supplier_id",id);
        List<BankAccountEntity> list = bankAccountService.list(wrapper);
        List<BankAccountVO> supplyBankEntities = BeanMapper.mapList(list, BankAccountVO.class);
        SupplierVO supplierVo = BeanMapper.map(supplierEntity,SupplierVO.class);
        supplierVo.setBanks(supplyBankEntities);
        SupplierDTO dto = BeanMapper.map(supplierVo, SupplierDTO.class);
        logger.info("dto:"+JSONObject.toJSONString(dto));
        return CommonResponse.success("查询成功！！！！",dto);
    }

    /**
     * 根据修改时间查询供应商信息
     *
     * @returnselectByUpDateSubLeaders
     */
    @GetMapping("selectByUpDate")
    public CommonResponse<List<SupplierDTO>> selectByUpDate(@RequestParam(value = "upDate") String upDate) {
        List<SupplierDTO> vos = supplierService.selectByUpDate(upDate);
        return CommonResponse.success(vos);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("querySupplierByIds")
    public CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids) {
        logger.info("接受到的参数,ids:"+ids);
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        logger.info("条数:"+entitys.size());
        if(entitys != null){
            vos = BeanMapper.mapList(entitys, SupplierVO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param ids 供应商Id
     * @return
     */
    @GetMapping("querySupplierDTOByIds")
    public CommonResponse<List<SupplierDTO>> querySupplierDTOByIds(@RequestParam(value = "ids") List<Long> ids) {
        logger.info("接受到的参数,ids:"+ids);
        List<SupplierDTO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        logger.info("条数:"+entitys.size());
        if(entitys != null){
            vos = BeanMapper.mapList(entitys, SupplierDTO.class);
        }
        return CommonResponse.success("查询成功！", vos);
    }

    /**
     * 根据供应商Ids查询供应商信息
     *
     * @param map 供应商Id
     * @return
     */
    @PostMapping("queryPostSupplierByIds")
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> queryPostSupplierByIds(@RequestBody Map<String,List<Long>> map) {
        List<Long> ids = map.get("ids");
        logger.info("接受到的参数,ids:"+ids);
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", ids);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        logger.info("条数:"+entitys.size());
        List<SupplierDTO> dtos = BeanMapper.mapList(entitys, SupplierDTO.class);
        return CommonResponse.success("查询成功！！！！",dtos);
    }

    /**
     * 根据供应商 名称 查询供应商信息
     *
     * @param names 供应商 名称
     * @return
     */
    @PostMapping("querySupplierByNames")
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> querySupplierByNames(@RequestBody List<String> names) {
        logger.info("根据供应商 名称 查询供应商信息 接受到的参数,names:"+names);
        List<SupplierVO> vos = new ArrayList<>();
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("name", names);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        logger.info("根据供应商 名称 查询供应商信息 条数:"+entitys.size());
        List<SupplierDTO> dtos = BeanMapper.mapList(entitys, SupplierDTO.class);
        return CommonResponse.success("查询成功！！！！",dtos);
    }


    /**
     * 根据I8单位编码、纳税人识别号，获取供应商信息
     *
     * @param unitCodeOrTaxPayerIdentifier I8单位编码 或 纳税人识别号
     * @return
     */
    @PostMapping("selectByUnitCodeOrTaxPayerIdentifier")
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> selectByUnitCodeOrTaxPayerIdentifier(@RequestBody List<String> unitCodeOrTaxPayerIdentifier)  {
        logger.info("根据I8单位编码、纳税人识别号，获取供应商信息，接受到的参数,I8单位编码、纳税人识别号:" + unitCodeOrTaxPayerIdentifier);
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("unit_i8_code", unitCodeOrTaxPayerIdentifier);
        queryWrapper.or();
        queryWrapper.in("tax_payer_identifier", unitCodeOrTaxPayerIdentifier);
        List<SupplierEntity> entitys = supplierService.list(queryWrapper);
        logger.info("根据I8单位编码、纳税人识别号，查询供应商信息 条数:"+entitys.size());
        List<SupplierDTO> dtos = BeanMapper.mapList(entitys, SupplierDTO.class);
        return CommonResponse.success("查询成功！！！！",dtos);
    }

    public static void main(String[] args) {
        CommonResponse commonResponse = new CommonResponse();
        List<SupplierEntity> entitys = new ArrayList<>();
        List<SupplierDTO> dtos = new ArrayList<>();
        SupplierEntity entity = new SupplierEntity();
        entity.setId(11L);
        entitys.add(entity);
        String data = JSONObject.toJSONString(entitys);
        commonResponse.setData(data);
        Object info = commonResponse.getData();
        System.out.println(info);
    }



    /**
     * 根据供应商名称查询供应商信息
     *
     * @param name 供应商Id
     * @return
     */
    @GetMapping("findOneByName")
    public CommonResponse<SupplierVO> findOneByName(@RequestParam(value = "name") String name,
            @RequestParam(value = "tenantId") Long tenantId) {
    	SupplierVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<SupplierEntity> list = supplierService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), SupplierVO.class);
        }

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 推送，生成企业供应商
     *
     * @return
     */
    @PostMapping(value = "pushSupplierToShare")
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte){
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        logger.info("推送，生成企业供应商pushSupplierToShare---{}", supplyStr);
        /** 校验 纳税人识别号是否存在 不能乱增 */
        SupplierVO supplierVO = JSONObject.parseObject(supplyStr,SupplierVO.class);
        supplierVO.setSupplierFlag(1);//供应商
        QueryParam param = new QueryParam();
        String[] supplyType =  supplierVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic(ComplexParam.AND);
        for (int i = 0; i < supplyType.length; i++) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic(ComplexParam.OR);
            t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,supplierVO.getTaxPayerIdentifier()));
        if(ListUtil.isNotEmpty(supplierService.queryList(param))){
            if(supplierVO.getPersonal().equals("p")) {
                return CommonResponse.error("供应商库已存在身份证号为【"+supplierVO.getTaxPayerIdentifier()+"】的供应商！");
            }else {
                return CommonResponse.error("供应商库已存在纳税人识别号为【"+supplierVO.getTaxPayerIdentifier()+"】的供应商！");
            }

        }
        QueryParam paramName = new QueryParam();
        paramName.getComplexParams().add(c);
        paramName.getParams().put("name",new Parameter(QueryParam.EQ,supplierVO.getName()));
        if(ListUtil.isNotEmpty(supplierService.queryList(paramName))){
            return CommonResponse.error("供应商库已存在名称为【"+supplierVO.getName()+"】的供应商！");
        }

        supplierVO.setSocialCreditCode(supplierVO.getTaxPayerIdentifier());
        supplierVO.setEnabled(1);//默认启用
        supplierVO.setInsideOrg(false);//外部客商

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,supplierVO.getTaxPayerIdentifier()));
        List<SupplierEntity> supplierEntityList = supplierService.queryList(queryParam);
        if(ListUtil.isNotEmpty(supplierEntityList)){
            logger.info("存在结果集{}",supplierEntityList);
            SupplierEntity supplierEntity = supplierEntityList.get(0);
            SupplierEntity se = BeanMapper.map(supplierVO, SupplierEntity.class);
            /** 供应商每次准入时：除了更新类别之外。 还需要更新字段：集团内外、等级、注册资金、营业额、业务代表、业务代表电话等字段 */
            supplierEntity.setGroupInOrOut(se.getGroupInOrOut());
            supplierEntity.setGradeId(se.getGradeId());
            supplierEntity.setGradeName(se.getGradeName());
            supplierEntity.setRegisteredCapital(se.getRegisteredCapital());
            supplierEntity.setTurnover(se.getTurnover());
            supplierEntity.setBusinessPerson(se.getBusinessPerson());
            supplierEntity.setBusinessPhone(se.getBusinessPhone());

            supplierEntity.setInException(se.getInException());
            supplierEntity.setPunishApplyOrg(se.getPunishApplyOrg());
            supplierEntity.setPunishDate(se.getPunishDate());
            supplierEntity.setPunishGrade(se.getGradeName());
            supplierEntity.setPunishMemo(se.getPunishMemo());
            supplierEntity.setPunishType(se.getPunishType());
            supplierEntity.setExceptionEndDate(se.getExceptionEndDate());

            if (StringUtils.isNotEmpty(supplierEntity.getSupplyType())) {
                if (!supplierEntity.getSupplyType().contains(supplierVO.getSupplyType())) {
                    supplierEntity.setSupplyType(supplierEntity.getSupplyType() + "," + supplierVO.getSupplyType());
                    supplierEntity.setSupplyTypeName(supplierEntity.getSupplyTypeName() + "," + supplierVO.getSupplyTypeName());
                }
            } else {
                supplierEntity.setSupplyType(supplierVO.getSupplyType());
                supplierEntity.setSupplyTypeName(supplierVO.getSupplyTypeName());
            }
            logger.info("结果数据{}",supplierVO.getSupplyType());

            if(supplierVO.getSupplyType().contains("material")){
                supplierEntity.setMaterialContent(supplierVO.getMaterialContent());
                supplierEntity.setMaterialContentId(supplierVO.getMaterialContentId());
                supplierEntity.setMaterialMemo(supplierVO.getMaterialMemo());
            }
            if(supplierVO.getSupplyType().contains("equipment")){
                supplierEntity.setEquipmentContent(supplierVO.getEquipmentContent());
                supplierEntity.setEquipmentContentId(supplierVO.getEquipmentContentId());
                supplierEntity.setEquipmentMemo(supplierVO.getEquipmentMemo());
            }
            if(supplierVO.getSupplyType().contains("revolvMaterial")){
                supplierEntity.setRevolvMaterialContent(supplierVO.getRevolvMaterialContent());
                supplierEntity.setRevolvMaterialContentId(supplierVO.getRevolvMaterialContentId());
                supplierEntity.setRevolvMaterialMemo(supplierVO.getRevolvMaterialMemo());
            }
            if(supplierVO.getSupplyType().contains("consult")){
                supplierEntity.setConsultContent(supplierVO.getConsultContent());
                supplierEntity.setConsultContentId(supplierVO.getConsultContentId());
                supplierEntity.setConsultMemo(supplierVO.getConsultMemo());
            }
            if(supplierVO.getSupplyType().contains("other")){
                supplierEntity.setOtherContent(supplierVO.getOtherContent());
                supplierEntity.setOtherContentId(supplierVO.getOtherContentId());
                supplierEntity.setOtherMemo(supplierVO.getOtherMemo());
            }
            if(supplierVO.getSupplyType().contains("labor")){
                supplierEntity.setLaborContent(supplierVO.getLaborContent());
                supplierEntity.setLaborContentId(supplierVO.getLaborContentId());
                //supplierEntity.setLaborMemo(supplierVO.getLaborMmo());
            }
            if(supplierVO.getSupplyType().contains("major")){
                supplierEntity.setMajorContent(supplierVO.getMajorContent());
                supplierEntity.setMajorContentId(supplierVO.getMajorContentId());
                supplierEntity.setMajorMemo(supplierVO.getMajorMemo());
            }
            // 供应商银行、供应商证件
            if(ListUtil.isNotEmpty(supplierVO.getBanks())){
                for(BankAccountVO bankAccountVO: supplierVO.getBanks()){
                    /** 判重 ： 根据银行名称+账号+户名 进行判重 2022年11月8日*/
                    QueryParam bankParam = new QueryParam();
                    bankParam.getParams().put("bankName",new Parameter(QueryParam.EQ,bankAccountVO.getBankName()));
                    bankParam.getParams().put("bankCode",new Parameter(QueryParam.EQ,bankAccountVO.getBankCode()));
                    bankParam.getParams().put("bankAccount",new Parameter(QueryParam.EQ,bankAccountVO.getBankAccount()));
                    List<BankAccountEntity> accountEntities = bankAccountService.queryList(bankParam,false);
                    if(ListUtil.isEmpty(accountEntities)){
                        addBanks(supplierEntity,bankAccountVO);
                    }
                }
            }
            if(ListUtil.isNotEmpty(se.getCerts())){
                for (CertsEntity cert : se.getCerts()) {
                    cert.setPid(supplierEntity.getId());
                    supplierEntity.getCerts().add(cert);
                }
            }
            supplierService.saveOrUpdate(supplierEntity,false);
            //分包供应商 分包负责人
            if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
                if(ListUtil.isNotEmpty(se.getSubLeaders())){
                    for (SubleadersEntity subLeader : se.getSubLeaders()) {
                        subLeader.setPid(supplierEntity.getId());
                        subleadersService.saveOrUpdate(subLeader);
                    }
                }
            }

        }else {
            SupplierEntity se = BeanMapper.map(supplierVO,SupplierEntity.class);
            Boolean coordination = se.getCoordination();
            if(coordination == null){
                se.setCoordination(false);
            }
            supplierService.saveOrUpdate(se,false);
            se = supplierService.generateSupplierTenant(se);
            supplierService.saveOrUpdate(se,false);
            if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
                //分包供应商 分包负责人
                if(ListUtil.isNotEmpty(se.getSubLeaders()) ){
                    for (SubleadersEntity subLeader : se.getSubLeaders()) {
                        supplierService.generateSubSupplierTenant(subLeader,se);
                        subleadersService.saveOrUpdate(subLeader);
                    }
                }
            }
            List<BankAccountVO> banks = supplierVO.getBanks();
            if(ListUtil.isNotEmpty(banks)){
                QueryParam params = new QueryParam();
                List<Long> collect = banks.stream().map(BankAccountVO::getId).collect(Collectors.toList());
                params.getParams().put("id",new Parameter(QueryParam.IN,collect));

                List<BankAccountEntity> bankAccountEntityList = bankAccountService.queryList(params);
                List<BankAccountVO> rm = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(bankAccountEntityList)){
                    for(BankAccountVO bankAccountVO: banks){
                        for(BankAccountEntity bankAccountEntity: bankAccountEntityList){
                            if(bankAccountVO.getId().equals(bankAccountEntity.getId())){
                                rm.add(bankAccountVO);
                            }
                        }
                    }
                }
                banks.removeAll(rm);
                for(BankAccountVO bankAccountVO: banks){
                    addBanks(se,bankAccountVO);
                }
            }
        }
        return CommonResponse.success("保存成功！");
    }


    /**
     * 推送，生成企业供应商郑州一建
     *
     * @return
     */
    @PostMapping(value = "pushSupplierToShareZzyj")
    public CommonResponse<String> pushSupplierToShareZzyj(@RequestBody byte[] supplyByte){
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        logger.info("推送，生成企业供应商pushSupplierToShare---{}", supplyStr);
        /** 校验 纳税人识别号是否存在 不能乱增 */
        SupplierVO supplierVO = JSONObject.parseObject(supplyStr,SupplierVO.class);
        supplierVO.setSupplierFlag(1);//供应商
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,supplierVO.getTaxPayerIdentifier()));
        String[] supplyType =  supplierVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic(ComplexParam.AND);
        for (int i = 0; i < supplyType.length; i++) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic(ComplexParam.OR);
            t.getParams().put("supplyType",new Parameter(QueryParam.LIKE,type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);

        if(ListUtil.isNotEmpty(supplierService.queryList(param))){
            if(supplierVO.getPersonal().equals("p")) {
                return CommonResponse.error("供应商库已存在身份证号为【"+supplierVO.getTaxPayerIdentifier()+"】的供应商！");
            }else {
                return CommonResponse.error("供应商库已存在纳税人识别号为【"+supplierVO.getTaxPayerIdentifier()+"】的供应商！");
            }

        }

        QueryParam paramName = new QueryParam();
        paramName.getComplexParams().add(c);
        paramName.getParams().put("name",new Parameter(QueryParam.EQ,supplierVO.getName()));
        if(ListUtil.isNotEmpty(supplierService.queryList(paramName))){
            return CommonResponse.error("供应商库已存在名称为【"+supplierVO.getName()+"】的供应商！");
        }


        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,supplierVO.getTaxPayerIdentifier()));
        List<SupplierEntity> supplierEntityList = supplierService.queryList(queryParam);
        if(ListUtil.isNotEmpty(supplierEntityList)){
            SupplierEntity supplierEntity = supplierEntityList.get(0);
            SupplierEntity se = BeanMapper.map(supplierVO,SupplierEntity.class);
            /** 供应商每次准入时：除了更新类别之外。 还需要更新字段：集团内外、等级、注册资金、营业额、业务代表、业务代表电话等字段 */
            supplierEntity.setGroupInOrOut(se.getGroupInOrOut());
            supplierEntity.setGradeId(se.getGradeId());
            supplierEntity.setGradeName(se.getGradeName());
            supplierEntity.setRegisteredCapital(se.getRegisteredCapital());
            supplierEntity.setTurnover(se.getTurnover());
            supplierEntity.setBusinessPerson(se.getBusinessPerson());
            supplierEntity.setBusinessPhone(se.getBusinessPhone());

            if(StringUtils.isNotEmpty(supplierEntity.getSupplyType())){
                if(!supplierEntity.getSupplyType().contains(supplierVO.getSupplyType())){
                    supplierEntity.setSupplyType(supplierEntity.getSupplyType()+","+supplierVO.getSupplyType());
                    supplierEntity.setSupplyTypeName(supplierEntity.getSupplyTypeName()+","+supplierVO.getSupplyTypeName());
                }
            }else {
                supplierEntity.setSupplyType(supplierVO.getSupplyType());
                supplierEntity.setSupplyTypeName(supplierVO.getSupplyTypeName());
            }
            if("material".equals(supplierVO.getSupplyType())){
                supplierEntity.setMaterialContent(supplierVO.getMaterialContent());
                supplierEntity.setMaterialContentId(supplierVO.getMaterialContentId());
                supplierEntity.setMaterialMemo(supplierVO.getMaterialMemo());
            }
            if("equipment".equals(supplierVO.getSupplyType())){
                supplierEntity.setEquipmentContent(supplierVO.getEquipmentContent());
                supplierEntity.setEquipmentContentId(supplierVO.getEquipmentContentId());
                supplierEntity.setEquipmentMemo(supplierVO.getEquipmentMemo());
            }
            if("revolvMaterial".equals(supplierVO.getSupplyType())){
                supplierEntity.setRevolvMaterialContent(supplierVO.getRevolvMaterialContent());
                supplierEntity.setRevolvMaterialContentId(supplierVO.getRevolvMaterialContentId());
                supplierEntity.setRevolvMaterialMemo(supplierVO.getRevolvMaterialMemo());
            }
            if("consult".equals(supplierVO.getSupplyType())){
                supplierEntity.setConsultContent(supplierVO.getConsultContent());
                supplierEntity.setConsultContentId(supplierVO.getConsultContentId());
                supplierEntity.setConsultMemo(supplierVO.getConsultMemo());
            }
            if("other".equals(supplierVO.getSupplyType())){
                supplierEntity.setOtherContent(supplierVO.getOtherContent());
                supplierEntity.setOtherContentId(supplierVO.getOtherContentId());
                supplierEntity.setOtherMemo(supplierVO.getOtherMemo());
            }
            if("labor".equals(supplierVO.getSupplyType())){
                supplierEntity.setLaborContent(supplierVO.getLaborContent());
                supplierEntity.setLaborContentId(supplierVO.getLaborContentId());
                supplierEntity.setLaborMemo(supplierVO.getLaborMemo());
            }
            if("major".equals(supplierVO.getSupplyType())){
                supplierEntity.setMajorContent(supplierVO.getMajorContent());
                supplierEntity.setMajorContentId(supplierVO.getMajorContentId());
                supplierEntity.setMajorMemo(supplierVO.getMajorMemo());
            }
            Boolean coordination = se.getCoordination();
            if(coordination == null){
                se.setCoordination(false);
                coordination  = false;
            }
            if(coordination){
                supplierEntity = supplierService.generateSupplierTenant(supplierEntity);
            }
            // 供应商银行、供应商证件
            if(ListUtil.isNotEmpty(supplierVO.getBanks())){
                for(BankAccountVO bankAccountVO: supplierVO.getBanks()){
                    /** 判重 ： 根据银行名称+账号+户名 进行判重 2022年11月8日*/
                    QueryParam bankParam = new QueryParam();
                    bankParam.getParams().put("bankName",new Parameter(QueryParam.EQ,bankAccountVO.getBankName()));
                    bankParam.getParams().put("bankCode",new Parameter(QueryParam.EQ,bankAccountVO.getBankCode()));
                    bankParam.getParams().put("bankAccount",new Parameter(QueryParam.EQ,bankAccountVO.getBankAccount()));
                    List<BankAccountEntity> accountEntities = bankAccountService.queryList(bankParam,false);
                    if(ListUtil.isEmpty(accountEntities)){
                        addBanks(supplierEntity,bankAccountVO);
                    }
                }
            }
            if(ListUtil.isNotEmpty(se.getCerts())){
                for (CertsEntity cert : se.getCerts()) {
                    cert.setPid(supplierEntity.getId());
                    supplierEntity.getCerts().add(cert);
                }
            }
            supplierService.saveOrUpdate(supplierEntity,false);

            //分包供应商 分包负责人
            if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
                if(ListUtil.isNotEmpty(se.getSubLeaders())){
                    for (SubleadersEntity subLeader : se.getSubLeaders()) {
                        subLeader.setPid(supplierEntity.getId());
                        subleadersService.saveOrUpdate(subLeader);
                        if(coordination){
                            supplierService.generateSubSupplierTenant(subLeader,supplierEntity);
                        }
                    }
                }
            }

        }else {
            supplierVO.setSocialCreditCode(supplierVO.getTaxPayerIdentifier());
            supplierVO.setEnabled(1);//默认启用
            supplierVO.setInsideOrg(false);//外部客商
            supplierVO.setComeFrom("自行准入");//自行准入

            SupplierEntity se = BeanMapper.map(supplierVO,SupplierEntity.class);
            Boolean coordination = se.getCoordination();
            if(coordination == null){
                se.setCoordination(false);
            }
            supplierService.saveOrUpdate(se,false);
            se = supplierService.generateSupplierTenant(se);
            supplierService.saveOrUpdate(se,false);
            if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
                //分包供应商 分包负责人
                if(ListUtil.isNotEmpty(se.getSubLeaders()) ){
                    for (SubleadersEntity subLeader : se.getSubLeaders()) {
                        supplierService.generateSubSupplierTenant(subLeader,se);
                        subleadersService.saveOrUpdate(subLeader);
                    }
                }
            }
            List<BankAccountVO> banks = supplierVO.getBanks();
            if(ListUtil.isNotEmpty(banks)){
                QueryParam params = new QueryParam();
                List<Long> collect = banks.stream().map(BankAccountVO::getId).collect(Collectors.toList());
                params.getParams().put("id",new Parameter(QueryParam.IN,collect));

                List<BankAccountEntity> bankAccountEntityList = bankAccountService.queryList(params);
                List<BankAccountVO> rm = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(bankAccountEntityList)){
                    for(BankAccountVO bankAccountVO: banks){
                        for(BankAccountEntity bankAccountEntity: bankAccountEntityList){
                            if(bankAccountVO.getId().equals(bankAccountEntity.getId())){
                                rm.add(bankAccountVO);
                            }
                        }
                    }
                }
                banks.removeAll(rm);
                for(BankAccountVO bankAccountVO: banks){
                    addBanks(se,bankAccountVO);
                }
            }

        }
        return CommonResponse.success("保存成功！");
    }

    private void addBanks(SupplierEntity supplierVO,BankAccountVO bankAccountVO){
        BankAccountEntity accountEntity = BeanMapper.map(bankAccountVO,BankAccountEntity.class);
        accountEntity.setOrgId(supplierVO.getApplyOrgId());
        accountEntity.setOrgName(supplierVO.getApplyOrgName());
        accountEntity.setSupplierId(supplierVO.getId());
        accountEntity.setSupplierName(supplierVO.getName());
        accountEntity.setSupplierCode(supplierVO.getCode());

        if(bankAccountVO.getBankNum() == null){
            BankEntity bankEntity = bankService.selectById(bankAccountVO.getBankId());
            accountEntity.setBankNum(bankEntity.getCode());
        }
        accountEntity.setTenantId(999999L);
        accountEntity.setEnabled(1);
        accountEntity.setInsideState(0);
        accountEntity.setSupplierFlag(1);//供应商
        if(accountEntity.getDefaultFlag()==null){
            accountEntity.setDefaultFlag(0);
        }
        bankAccountService.saveOrUpdate(accountEntity);
    }

    @GetMapping(value = "judgeTaxpayerNumIsRepeat")
    public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam  String taxpayerNum, @RequestParam  String personal,@RequestParam(required = false) String supplyType){
        logger.info("判重参数：taxpayerNum={},personal={},supplyType={}",taxpayerNum,personal,supplyType);
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,taxpayerNum));
        if(StringUtils.isNotEmpty(supplyType) && !"-".equals(supplyType)){
            ComplexParam complexParam = new ComplexParam();
            complexParam.setLogic(ComplexParam.AND);
            for (String s : supplyType.split(",")) {
                ComplexParam c = new ComplexParam();
                c.setLogic(ComplexParam.OR);
                c.getParams().put("supplyType",new Parameter(QueryParam.LIKE,s));
                complexParam.getComplexParams().add(c);
            }
            param.getComplexParams().add(complexParam);
        }
        List<SupplierEntity> supplierEntities = supplierService.queryList(param);
        if(ListUtil.isNotEmpty(supplierEntities)){
            if("p".equals(personal)) {
                return CommonResponse.error("供应商库已存在身份证号为【"+taxpayerNum+"】的个人供应商！",supplierEntities.get(0).getSupplyTypeName());
            }else {
                return CommonResponse.error("供应商库已存在纳税人识别号为【"+taxpayerNum+"】的企业供应商！",supplierEntities.get(0).getSupplyTypeName());
            }
        }
        return CommonResponse.success("供应商不重复！");
    }

    /**
     * 推送，生成企业供应商
     *
     * @return
     */
    @PostMapping(value = "pushSubLeadersToShare")
    public CommonResponse<String> pushSubLeadersToShare(@RequestBody SubleadersPushVO pushVO){
        logger.info("分包负责人推送，生成企业供应商pushSupplierToShare---{}", JSONObject.toJSONString(pushVO));
        SupplierEntity se = supplierService.selectById(pushVO.getSupplierId());
        if(se == null){
            return CommonResponse.error("没有找到分包负责人所在供应商");
        }
        if(ListUtil.isEmpty(pushVO.getSubLeaders())){
            return CommonResponse.error("要准入的分包负责人不能为空！");
        }
        Boolean coordination = se.getCoordination();
        if(coordination == null){
            se.setCoordination(false);
        }
        //分包供应商 分包负责人
        for (SubleadersVO subleadersVO : pushVO.getSubLeaders()) {
            SubleadersEntity subLeader = BeanMapper.map(subleadersVO,SubleadersEntity.class);
            subLeader.setContentId(subleadersVO.getContentIdForTrans());
            supplierService.generateSubSupplierTenant(subLeader,se);
            /** 更新主表id */
            subLeader.setPid(se.getId());
            subleadersService.saveOrUpdate(subLeader);
        }
        return CommonResponse.success("保存成功！");
    }

    /**
     * 批量供应商处置更新供应商库
     *
     * @return
     */
    @PostMapping(value = "punishSupplierBatch")
    public CommonResponse<String> punishSupplierBatch(@RequestBody List<PunishVO> punishVOs){
        String msg = supplierService.punishSupplierBatch(punishVOs);
        return StringUtils.isNotBlank(msg) ? CommonResponse.error(msg) : CommonResponse.success("处置成功！");
    }

    /**
     * 批量更新供应商/分包负责人等级
     *
     * @param updateParamsStr [{id: 供应商或分包负责人Id，type: supplier-供应商，subLeader-分包负责人, grade: 等级Id，gradeName:等级名称}]
     * @return
     */
    @PostMapping(value = "updateSupplierAndSubLeaderBatch")
    public CommonResponse<String> updateSupplierAndSubLeaderBatch(@RequestBody String updateParamsStr) {
        String updateRs = supplierService.updateSupplierAndSubLeaderBatch(updateParamsStr);
        return StringUtils.isNotBlank(updateRs) ? CommonResponse.error(updateRs) : CommonResponse.success("更新成功！");
    }

    /**
     * 供应商处置更新供应商库
     *
     * @return
     */
    @PostMapping(value = "punishSupplier")
    public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO){
        String punishVOStr = JSONObject.toJSONString(punishVO);
        logger.info("punishVOStr:"+punishVOStr);
        SupplierEntity supplierEntity = supplierService.selectById(punishVO.getSupplierId());
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        if(null == punishVO.getPunishOldGrade()){
            punishVO.setPunishOldGrade(supplierEntity.getPunishOldGrade());
        }
        boolean inException = true;
        if(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,new Date()).equals(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,punishVO.getExceptionEndDate()))){
            inException = false;
        }
        if(punishVO.getSubLeaderId()==null){
            //处置供应商punishOldGrade
            logger.info("执行了。。。。。。");

            BeanUtils.copyProperties(punishVO,supplierEntity);
            supplierEntity.setGradeId(punishVO.getPunishGradeId());
            supplierEntity.setGradeName(punishVO.getPunishGrade());
            supplierEntity.setPunishOldGrade(punishVO.getPunishOldGrade());
            supplierEntity.setInException(inException);
            Date startDate = new Date();
            boolean b = supplierService.saveOrUpdate(supplierEntity, false);
            Date endDate = new Date();
            logger.info("处置结果插入:"+b);
            logger.info("处置时间(毫秒数):"+(endDate.getTime()-startDate.getTime()));
        }else {
            logger.info("到了.....");
            //处置分包负责人
            if(ListUtil.isEmpty(supplierEntity.getSubLeaders())){
                return CommonResponse.error("分包负责人不存在，无法处置！");
            }
            SubleadersEntity leader = null;
            for (SubleadersEntity subLeader : supplierEntity.getSubLeaders()) {
                if(punishVO.getSubLeaderId().equals(subLeader.getId())){
                    leader = subLeader;
                }
            }
            if(leader == null){
                return CommonResponse.error("分包负责人不存在，无法处置！");
            }
            BeanUtils.copyProperties(punishVO,leader);
            leader.setGrade(punishVO.getPunishGradeId());
            leader.setGradeName(punishVO.getPunishGrade());
            leader.setInException(inException);
            logger.info("数据:{}",leader);
            subleadersService.saveOrUpdate(leader,false);
        }
        return CommonResponse.success("处置成功！");
    }

    /**
     * 供应商 评级更新供应商库
     * @param supplierId 供应商id
     * @param gradeId 评定等级id
     * @param gradeName 评定等级名称
     */
    @GetMapping(value = "upgradeSupplier")
    public CommonResponse<String> upgradeSupplier(@RequestParam("supplierId") Long supplierId,
                                                  @RequestParam("gradeId") Long gradeId,
                                                  @RequestParam("gradeName") String gradeName) {
        logger.info("评级更新供应商库");
        logger.info(supplierId.toString());
        logger.info(gradeId.toString());
        logger.info(gradeName);
        SupplierEntity supplierEntity = supplierService.selectById(supplierId);
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);

        supplierService.saveOrUpdate(supplierEntity,false);
        return CommonResponse.success("供应商评级设置成功！");
    }

    /**
     * 移除供应商异常标签
     * @param supplierId 供应商id
     * @param gradeId 评定等级id
     * @param gradeName 评定等级名称
     */
    @GetMapping(value = "returnSupplierToNormal")
    public CommonResponse<String> returnSupplierToNormal(@RequestParam("supplierId") Long supplierId,
                                                         @RequestParam("gradeId") Long gradeId,
                                                         @RequestParam("gradeName") String gradeName) {
        logger.info("移除供应商异常标签");
        SupplierEntity supplierEntity = supplierService.selectById(supplierId);
        if (supplierEntity == null) {
            return CommonResponse.error("供应商不存在！");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);
        supplierEntity.setInException(false);
        supplierEntity.setExceptionEndDate(null);
        supplierEntity.setPunishType(null);

        supplierService.saveOrUpdate(supplierEntity, false);
        return CommonResponse.success("移除供应商异常标签成功！");
    }

    /**
     * 移除 分包负责人 异常标签
     *
     * @param supplierId 分包负责人id
     * @param gradeId    评定等级id
     * @param gradeName  评定等级名称
     */
    @GetMapping(value = "returnSubleaderToNormal")
    public CommonResponse<String> returnSubleaderToNormal(@RequestParam("supplierId") Long supplierId,
                                                          @RequestParam("gradeId") Long gradeId,
                                                          @RequestParam("gradeName") String gradeName) {
        logger.info("移除 分包负责人 异常标签");
        SubleadersEntity supplierEntity = subleadersService.selectById(supplierId);
        if (supplierEntity == null) {
            return CommonResponse.error("分包负责人不存在！");
        }
        supplierEntity.setGrade(gradeId);
        supplierEntity.setGradeName(gradeName);
        supplierEntity.setInException(false);
        supplierEntity.setExceptionEndDate(null);
        supplierEntity.setPunishType(null);

        subleadersService.saveOrUpdate(supplierEntity, false);
        return CommonResponse.success("分包负责人移除异常成功！");
    }

    /**
     * 获取本私有化平台在 益企联公有云平台内的系统标识编码
     */
    @GetMapping(value = "getEjcCloudSystemCode")
    public CommonResponse<String> getEjcCloudSystemCode() {
        QueryParam param = new QueryParam();
        List<EjcCloudSystemEntity> list =  ejcCloudSystemService.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.success("查询成功",list.get(0).getCode());
        }
        System.out.println("益企联公有云平台内的系统标识编码 尚未配置！");
        return CommonResponse.error("查询失败");
    }


    /**
     * 根据供应商id，查询供应商信息
     */
    @GetMapping(value = "getSupplierInfo")
    @ResponseBody
    public CommonResponse<SupplierProVO> getSupplierInfo(@RequestParam("supplierId") Long supplierId){
        SupplierEntity supplierEntity = supplierService.selectById(supplierId);
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        SupplierProVO vo = BeanMapper.map(supplierEntity,SupplierProVO.class);
        return CommonResponse.success("查询供应商信息成功！",vo);
    }


    /**
     * 根据供应商id，查询供应商是否真正协同成功
     */
    @GetMapping(value = "whetherSupplierCoo")
    @ResponseBody
    public CommonResponse<Boolean> whetherSupplierCoo(@RequestParam("supplierId") Long supplierId){
        boolean coo = false;
        SupplierEntity supplierEntity = supplierService.selectById(supplierId);
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        if(StringUtils.isNotEmpty(supplierEntity.getSystemId()) && supplierEntity.getCoordination()!=null && supplierEntity.getCoordination()){
            coo = true;
        }
        logger.info("根据供应商id，查询供应商是否真正协同成功{}===>>{}",coo,JSONObject.toJSONString(supplierEntity));
        return CommonResponse.success("查询成功！",coo);
    }


    /**
     * 根据供应商id，查询供应商信息
     */
    @GetMapping(value = "updateLastCoDate")
    public CommonResponse<String> updateLastCoDate(@RequestParam("supplierId") Long supplierId){
        SupplierEntity supplierEntity = supplierService.selectById(supplierId);
        if(supplierEntity == null){
            return CommonResponse.error("供应商不存在！");
        }
        supplierEntity.setLastCoDate(new Date());
        supplierService.saveOrUpdate(supplierEntity);
        return CommonResponse.success("更新成功！");
    }

    /**
     * 根据供应商税号，获取供应商信息
     *
     */
    @GetMapping(value = "selectByTaxpayerNum")
    public CommonResponse<SupplierDTO> selectByTaxpayerNum(@RequestParam("taxpayerNum") String taxpayerNum){
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,taxpayerNum));
        List<SupplierEntity> supplierEntities = supplierService.queryList(param);
        if (supplierEntities.size() > 0){
            return  CommonResponse.success("查询成功！",BeanMapper.map(supplierEntities.get(0), SupplierDTO.class));
        } else{
            return  CommonResponse.error("供应商不存在！");
        }
    }


    /**
     * 根据供应商税号 或者 名称 校验供应商是否一致
     * 不一致，返回失败，并提示信息不一致的信息
     * 一致，返回成功
     */
    @GetMapping(value = "checkTaxpayerNumOrNameIsSame")
    public CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(@RequestParam("taxpayerNum") String taxpayerNum,@RequestParam("name") String name){
        QueryParam param = new QueryParam();
        param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,taxpayerNum));
        List<SupplierEntity> supplierEntities = supplierService.queryList(param);
        if(ListUtil.isNotEmpty(supplierEntities)){
            if(supplierEntities.get(0).getName().equals(name)){
                return CommonResponse.success("纳税人识别号和名称一致",true);
            }
            return CommonResponse.success("供应商库存在纳税人识别号一致，但是名称不一致的供应商,请检查数据是否正确！",false);
        }
        param = new QueryParam();
        param.getParams().put("name",new Parameter(QueryParam.EQ,name));
        supplierEntities = supplierService.queryList(param);
        if(ListUtil.isNotEmpty(supplierEntities)){
            if(supplierEntities.get(0).getTaxPayerIdentifier().equals(taxpayerNum)){
                return CommonResponse.success("纳税人识别号和名称一致",true);
            }
            return CommonResponse.success("供应商库存在名称一致，但是纳税人识别号不一致的供应商,请检查数据是否正确！",false);
        }
        return CommonResponse.success("没有找到相关供应商，认为一致",true);
    }


    /**
     * 根据供应商id和分包负责人身份证号 校验分包负责人是否在该供应商下存在
     * 不存在，返回false，并提示信息不一致的信息
     * 存在，返回true
     * @param supplierId 供应商id
     * @param idCardNum  分包负责人身份证号
     */
    @GetMapping(value = "checkSubLeaderIsExist")
    public CommonResponse<Boolean> checkSubLeaderIsExist(@RequestParam("supplierId") Long supplierId,@RequestParam("idCardNum") String idCardNum){
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ,supplierId));
        param.getParams().put("idNum",new Parameter(QueryParam.EQ,idCardNum));
        List<SubleadersEntity> supplierEntities = subleadersService.queryList(param);
        if(ListUtil.isNotEmpty(supplierEntities)){
            return CommonResponse.success("分包负责人身份证号:"+idCardNum+"重复！",true);
        }
        return CommonResponse.success("不重复！",false);
    }
}
