package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.ProsubCategoryMapper;
import com.ejianc.foundation.share.mapper.ProsubItemMapper;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemImportVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专业分包档案
 *
 * @author generator
 */
@Service("prosubItemService")
public class ProsubItemServiceImpl extends BaseServiceImpl<ProsubItemMapper, ProsubItemEntity> implements IProsubItemService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PSI_CODE";
    @Autowired
    private IProsubItemService service;
    @Autowired
    private IProsubCategoryService prosubCategoryService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ProsubItemMapper prosubItemMapper;
    @Autowired
    private ISubjectOrgService subjectOrgService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        int i = prosubItemMapper.updateByCategoryId(categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ProsubItemImportVO> successList = new ArrayList<>();
        List<ProsubItemImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("专业分包档案超过10000条，请分批上传！");
                }
                Map<String, List<ProsubCategoryEntity>> caListMap = new HashMap<>();
                Map<String, ProsubItemVO> materialMap = new HashMap<>();
                Map<String, ProsubItemVO> materialBeanMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ProsubItemImportVO prosubItemImport = new ProsubItemImportVO();
                    prosubItemImport.setId(IdWorker.getId());
                    prosubItemImport.setCategoryCode(datas.get(0));
                    prosubItemImport.setTrawlingCode(datas.get(1));
                    prosubItemImport.setTrawlingName(datas.get(2));
                    prosubItemImport.setPriceType(datas.get(3));
                    prosubItemImport.setUnitName(datas.get(4));
                    prosubItemImport.setJobContent(datas.get(5));
                    prosubItemImport.setDetailMeasurementRules(datas.get(6));
                    prosubItemImport.setRemarks(datas.get(7));
                    if (StringUtils.isBlank(datas.get(0))) {
                        prosubItemImport.setRemarks("档案编码为空！");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                        prosubItemImport.setRemarks("档案名称为空！");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        prosubItemImport.setRemarks("价格类型为空！");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    //通过档案分类Code获取档案分类ID
                    List<ProsubCategoryEntity> materialCategoryVo = caListMap.get(datas.get(0));
                    if (ListUtil.isEmpty(materialCategoryVo)) {
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, String.valueOf(datas.get(0))));
                        materialCategoryVo = prosubCategoryService.queryList(queryParam, false);
                        if (ListUtil.isNotEmpty(materialCategoryVo)) {
                            caListMap.put(datas.get(0), materialCategoryVo);
                        }
                    }
                    if (ListUtil.isNotEmpty(materialCategoryVo)) {
                        prosubItemImport.setCategoryId(materialCategoryVo.get(0).getId());

                        if (StringUtils.isBlank(datas.get(1))) {//没有编号，自动生成一个
                            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                            if (codeBatchByRuleCode.isSuccess()) {
                                prosubItemImport.setTrawlingCode(codeBatchByRuleCode.getData());
                            } else {
                                prosubItemImport.setTrawlingCode(System.currentTimeMillis() + "");
                            }

                        } else {//有编号，判重
                            ProsubItemVO vo = materialMap.get(datas.get(1));
                            if (vo == null) {
                                QueryWrapper<ProsubItemEntity> queryWrapper = new QueryWrapper<>();
                                queryWrapper.eq("trawling_code", String.valueOf(datas.get(1)));
                                ProsubItemEntity one =null;
                                List<ProsubItemEntity> list = service.list(queryWrapper);
                                if (CollectionUtils.isNotEmpty(list)){
                                    one=list.get(0);
                                }
                                if (one != null) {
                                    vo = BeanMapper.map(one, ProsubItemVO.class);
                                }
                                if (vo != null) {
                                    materialMap.put(datas.get(1), vo);
                                }
                            }
                            if (vo != null) {
                                prosubItemImport.setRemarks("档案编号重复！");
                                errorList.add(prosubItemImport);
                                continue;
                            }
                        }
                        ProsubItemVO materialBean = materialBeanMap.get(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + materialCategoryVo.get(0).getId());
                        if (materialBean == null) {
                            QueryWrapper<ProsubItemEntity> queryWrapper = new QueryWrapper<>();
                            queryWrapper.eq("trawling_name", prosubItemImport.getTrawlingName());
                            queryWrapper.eq("price_type", prosubItemImport.getPriceType());
                            queryWrapper.eq("unit_name", prosubItemImport.getUnitName());
                            queryWrapper.eq("category_id", materialCategoryVo.get(0).getId());
                            prosubItemImport.setCategoryName(materialCategoryVo.get(0).getCategoryName());
                            ProsubItemEntity one = null;
                            List<ProsubItemEntity> list = service.list(queryWrapper);
                            if (CollectionUtils.isNotEmpty(list)){
                                one=list.get(0);
                            }
                            if (one != null) {
                                materialBean = BeanMapper.map(one, ProsubItemVO.class);
                                materialBeanMap.put(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + materialCategoryVo.get(0).getId(), materialBean);
                            }
                        }
                        if (materialBean != null) {
                            prosubItemImport.setRemarks("重复档案！");
                            errorList.add(prosubItemImport);
                            continue;
                        }
                        prosubItemImport.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        prosubItemImport.setCreateTime(new Date());
                        prosubItemImport.setTenantId(InvocationInfoProxy.getTenantid());
                        prosubItemImport.setEnabled(1);
                        successList.add(prosubItemImport);
                    } else {
                        prosubItemImport.setRemarks("档案分类编号不存在！");
                        errorList.add(prosubItemImport);
                    }
                    if (StringUtils.isBlank(datas.get(8))) {
//                        prosubItemImport.setRemarks("成本科目为空！");
//                        errorList.add(prosubItemImport);
//                        continue;
                    }else {
                        String subjectName = datas.get(8).toString();
                        QueryWrapper<SubjectOrgEntity> subjectQueryWrapper = new QueryWrapper<>();
                        subjectQueryWrapper.like("subject_name",subjectName);
                        List<SubjectOrgEntity> list = subjectOrgService.list(subjectQueryWrapper);
                        if(CollectionUtils.isNotEmpty(list)){
                            prosubItemImport.setSubjectId(list.get(0).getId());
                            prosubItemImport.setSubjectName(list.get(0).getSubjectName());
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public CommonResponse<ProsubItemVO> saveOrUpdateProsubItem(ProsubItemVO saveorUpdateVO) {
        ProsubItemEntity entity = BeanMapper.map(saveorUpdateVO, ProsubItemEntity.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("trawlingCode",new Parameter(QueryParam.EQ, saveorUpdateVO.getTrawlingCode()));
        List<ProsubItemEntity> prosubItemEntities = service.queryList(queryParam);
        if (saveorUpdateVO.getId()!=null){
            if (StringUtils.isEmpty(saveorUpdateVO.getTrawlingCode())){
                return CommonResponse.error("分包档案编码不能为空！");
            }
            ProsubItemEntity prosubItemEntity = service.selectById(saveorUpdateVO.getId());
            if (!prosubItemEntity.getTrawlingCode().equals(saveorUpdateVO.getTrawlingCode())){
                if (CollectionUtils.isNotEmpty(prosubItemEntities)){
                    return CommonResponse.error("分包档案编码重复！");
                }
            }
        }else {
            if (CollectionUtils.isNotEmpty(prosubItemEntities)){
                return CommonResponse.error("分包档案编码重复！");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {

                // 新增子项未绑定成本科目时 自动带入父级的成本科目
                if(null == entity.getSubjectId()){
                    Long categoryId = entity.getCategoryId();
                    ProsubCategoryEntity prosubCategoryEntity = prosubCategoryService.selectById(categoryId);
                    entity.setSubjectId(prosubCategoryEntity.getSubjectId());
                    entity.setSubjectName(prosubCategoryEntity.getSubjectName());
                }
                if (saveorUpdateVO.getTrawlingCode()==null){
                    entity.setTrawlingCode(billCode.getData());
                }
                entity.setEnabled(0);
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
                ProsubCategoryEntity prosubCategoryEntity = prosubCategoryService.selectById(entity.getCategoryId());
                if (prosubCategoryEntity!=null){
                    entity.setCategoryName(prosubCategoryEntity.getCategoryName());
                }
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            LambdaUpdateWrapper<ProsubItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(ProsubItemEntity::getId, saveorUpdateVO.getId());
            updateWrapper.set(ProsubItemEntity::getTrawlingName, saveorUpdateVO.getTrawlingName());
            updateWrapper.set(ProsubItemEntity::getPriceType, saveorUpdateVO.getPriceType());
            updateWrapper.set(ProsubItemEntity::getUnitName, saveorUpdateVO.getUnitName());
            updateWrapper.set(ProsubItemEntity::getJobContent, saveorUpdateVO.getJobContent());
            updateWrapper.set(ProsubItemEntity::getOrgId, sessionManager.getUserContext().getOrgId());
            updateWrapper.set(ProsubItemEntity::getOrgName, sessionManager.getUserContext().getOrgName());
            updateWrapper.set(ProsubItemEntity::getRemarks, saveorUpdateVO.getRemarks());
            updateWrapper.set(ProsubItemEntity::getSubjectId, saveorUpdateVO.getSubjectId());
            updateWrapper.set(ProsubItemEntity::getTrawlingCode,saveorUpdateVO.getTrawlingCode());
            updateWrapper.set(ProsubItemEntity::getUpdateTime, new Date());
            updateWrapper.set(ProsubItemEntity::getUpdateUserCode, InvocationInfoProxy.getUsercode());
            updateWrapper.set(ProsubItemEntity::getDetailMeasurementRules,saveorUpdateVO.getDetailMeasurementRules());
            updateWrapper.set(ProsubItemEntity::getSubjectName, saveorUpdateVO.getSubjectName());
            service.update(updateWrapper);
            return CommonResponse.success("保存或修改单据成功！");
        }
        service.saveOrUpdate(entity, false);
        ProsubItemVO vo = BeanMapper.map(entity, ProsubItemVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public List<ProsubItemVO> queryProsubItemList(Page<ProsubItemVO> page, QueryWrapper wrapper) {
        return baseMapper.queryProsubItemList(page, wrapper);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        LambdaUpdateWrapper<ProsubItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(ProsubItemEntity::getId,ids);
        updateWrapper.set(ProsubItemEntity::getSubjectId,subjectId);
        updateWrapper.set(ProsubItemEntity::getSubjectName,subjectName);
        service.update(updateWrapper);
    }
}
