package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/shareProjectWbsApi/")
public class ProjectWbsApi {
    private final String WBS_PARAM = "P-K5DI350192";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IProjectWbsService projectWbsService;

    @Autowired
    private IProjectSetService projectSetService;

    /**
     * 根据id查询本下项目WBS
     *
     * @param
     * @return
     * @Author
     */
    @GetMapping("queryProjectWbsList")
    public CommonResponse<List<ProjectWbsVO>> queryProjectWbsList(@RequestParam(value = "id") Long id) {
        ProjectWbsEntity parent = projectWbsService.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        List<ProjectWbsEntity> list = projectWbsService.queryList(queryParam, false);
        List<ProjectWbsVO> projectWbsVOList = BeanMapper.mapList(list, ProjectWbsVO.class);
        return CommonResponse.success("查询成功！", projectWbsVOList);
    }



    /**
     * 根据项目 id 查询根节点项目WBS
     *
     * @param
     * @return
     * @Author
     */
    @GetMapping("queryProjectWbsNodes")
    public CommonResponse<ProjectWbsVO> queryProjectWbsNodes(@RequestParam(value = "projectId") Long projectId) {
        CommonResponse<ParamRegisterSetVO> subResponse = paramConfigApi.getByCode(WBS_PARAM);
        if (subResponse.isSuccess() && (null == subResponse.getData() ||
                (null != subResponse.getData() && subResponse.getData().getValueData().equals("1")))) {
            QueryWrapper<ProjectWbsEntity> lambdaQueryWrapper = new QueryWrapper();
            lambdaQueryWrapper.eq("project_id",projectId);
            lambdaQueryWrapper.ne("enabled",1);
            lambdaQueryWrapper.isNull("parent_id");
            ProjectWbsEntity one = projectWbsService.getOne(lambdaQueryWrapper);
            if(null!=one){
                ProjectWbsVO map = BeanMapper.map(one, ProjectWbsVO.class);
                return CommonResponse.success("查询成功！", map);
            }
        }
        return CommonResponse.success("查询成功！");
    }
    /***
     * @description: 根据项目id查询wbs
     *
     * @param projectId
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.share.vo.ProjectWbsVO>>
     * @author songlx
     * @date: 2022/5/31
     */
    @GetMapping("queryByProjectId")
    CommonResponse<List<ProjectWbsVO>> queryByProjectId(@RequestParam(value = "projectId") Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        List<ProjectWbsEntity> list = projectWbsService.queryList(queryParam, false);
        List<ProjectWbsVO> projectWbsVOList = BeanMapper.mapList(list, ProjectWbsVO.class);
        return CommonResponse.success("查询成功！", projectWbsVOList);
    }

    /***
     * @description: 根据项目ids 返回项目默认的wbs
     *
     * @param projectIds
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.share.vo.ProjectWbsVO>>
     * @author songlx
     * @date: 2022/5/31
     */
    @GetMapping("queryByProjectIds")
    CommonResponse<Map<Long,ProjectWbsVO>> queryByProjectIds(@RequestParam(value = "projectIds") List<Long> projectIds) {
        Map<Long,ProjectWbsVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectIds)){
            for(int i=0;i<projectIds.size();i++){
                QueryWrapper<ProjectWbsEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("project_id", projectIds.get(i));
                List<ProjectWbsEntity> list = projectWbsService.list(queryWrapper);
                if (0==list.size()) {
                    ProjectSetPoolEntity projectSetPoolEntity = projectSetService.selectById(projectIds.get(i));
                    long id = IdWorker.getId();
                    ProjectWbsVO projectWbsVO = new ProjectWbsVO();
                    projectWbsVO.setId(id);
                    projectWbsVO.setCode(projectSetPoolEntity.getCode());
                    projectWbsVO.setName(projectSetPoolEntity.getName());
                    projectWbsVO.setProjectId(projectIds.get(i));
                    projectWbsVO.setOrgId(projectSetPoolEntity.getOrgId());
                    projectWbsVO.setEnabled(1);
                    projectWbsVO.setInnerCode(String.valueOf(id));
                    ProjectWbsEntity projectWbsEntity = BeanMapper.map(projectWbsVO, ProjectWbsEntity.class);
                    projectWbsService.saveOrUpdate(projectWbsEntity);
                    map.put(projectIds.get(i),BeanMapper.map(projectWbsEntity,ProjectWbsVO.class));
                }else{
                    map.put(projectIds.get(i),BeanMapper.map(list.get(0),ProjectWbsVO.class));
                }
            }
        }
        return CommonResponse.success("查询成功！", map);
    }
}
