package com.ejianc.foundation.share.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.EquipmentMapper;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@Service
public class EquipmentServiceImpl implements IEquipmentService {

	@Autowired
	private EquipmentMapper equipmentMapper;
	@Autowired
	private EquipmentCategoryMapper equipmentCategoryMapper;

	@Override
	public List<EquipmentVO> queryListByCategoryId(Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<EquipmentEntity> entities = equipmentMapper.queryListByCategoryId(tenantId, categoryId);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, EquipmentVO.class);
		}
		return null;
	}

	@Override
	public List<EquipmentVO> queryItem(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<EquipmentEntity> equipmentEntities = equipmentMapper.queryItem(tenantId, ids);
		if(equipmentEntities != null && equipmentEntities.size() > 0) {
			return BeanMapper.mapList(equipmentEntities, EquipmentVO.class);
		}
		return null;
	}

	@Override
	public EquipmentVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		EquipmentEntity entity = equipmentMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, EquipmentVO.class);
		}
		return null;
	}

	@Override
	public void update(EquipmentVO uniqueBean) {
		equipmentMapper.update(uniqueBean);
	}

	@Override
	public void amend(Long id, Long property,String propertyName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		equipmentMapper.amend(id,property,propertyName,tenantId);
	}

	@Override
	public void save(EquipmentVO EquipmentVo) {
		equipmentMapper.save(EquipmentVo);
	}

	/**
	 * 批量保存
	 *
	 * @param materialVOList
	 */
	@Override
	public void insertBatch(List<EquipmentVO> materialVOList) {
		if(ListUtil.isNotEmpty(materialVOList)){
			List<EquipmentVO> toInsert = new ArrayList<>();
			for (EquipmentVO equipmentVO : materialVOList) {
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					equipmentMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(equipmentVO);
			}
			if(toInsert.size()>0){
				equipmentMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			equipmentMapper.delete(tenantId, id);
		}
	}

	@Override
	public IPage<EquipmentEntity> queryPage(QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				Object value = parameter.getValue();
				if (value==null){
					continue;
				}
				EquipmentCategoryEntity categoryEntity = equipmentCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
				if(categoryEntity != null) {
					condition.put("innerCode", categoryEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());

		List<EquipmentEntity> records = equipmentMapper.queryList(condition);
		Long count = equipmentMapper.queryCount(condition);

		IPage<EquipmentEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public EquipmentVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		EquipmentVO EquipmentVo = equipmentMapper.queryExitFlag(tenantId, name, spec, unitName,categoryId);
		return EquipmentVo;
	}

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	@Override
	public EquipmentVO queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return equipmentMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<EquipmentEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<EquipmentEntity> records = equipmentMapper.queryExportList(condition);
		return records;
	}

	@Override
	public void insertEquipmentListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		equipmentMapper.insertEquipmentListFromPlatform(tenantId);
	}

	@Override
	public IPage<EquipmentEntity> queryRefEquipmentPage(Map<String, Object> params) {
		List<EquipmentEntity> dataList = equipmentMapper.queryRefEquipmentList(params);
		Long dataCount = equipmentMapper.queryRefEquipmentCount(params);

		IPage<EquipmentEntity> page = new Page<>();
		page.setCurrent(Long.valueOf(params.get("pageNumber").toString()));
		page.setSize(Long.valueOf(params.get("pageSize").toString()));
		page.setRecords(dataList);
		page.setTotal(dataCount);
		return page;
	}

	@Override
	public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = equipmentMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
		return CommonResponse.success();
	}

	@Override
	public List<EquipmentVO> queryEquipmentListByCodes(List<String> codeList) {
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		params.put("codeList", codeList);
		List<EquipmentEntity> equipmentEntities = equipmentMapper.queryEquipmentListByCodes(params);
		if(equipmentEntities != null && equipmentEntities.size() > 0) {
			return BeanMapper.mapList(equipmentEntities, EquipmentVO.class);
		}
		return null;
	}
}
