/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CooperateEntity;
import com.ejianc.foundation.share.mapper.CooperateMapper;
import com.ejianc.foundation.share.service.ICooperateService;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.util.BillShareHelper;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareCooperateApi/"})
public class CooperateApi {
    @Autowired
    private ICooperateService service;
    @Autowired
    private CooperateMapper cooperateMapper;
    @Autowired
    private BillShareHelper billShareHelper;

    @GetMapping(value={"queryCooperateListByModuleId"})
    public CommonResponse<List<CooperateVO>> queryCooperateListByModuleId(@RequestParam(value="moduleId") Long moduleId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("moduleId", new Parameter("eq", (Object)moduleId));
        List cooperateEntities = this.service.queryList(queryParam);
        List cooperateVos = BeanMapper.mapList((Iterable)cooperateEntities, CooperateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)cooperateVos);
    }

    @GetMapping(value={"queryCooperateBybillTypeCode"})
    public CommonResponse<CooperateVO> queryCooperateBybillTypeCode(@RequestParam(value="billTypeCode") String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_type_code", (Object)billTypeCode);
        CooperateEntity cooperateEntity = (CooperateEntity)((Object)this.cooperateMapper.selectOne((Wrapper)queryWrapper));
        CooperateVO vo = new CooperateVO();
        if (cooperateEntity != null) {
            vo = (CooperateVO)BeanMapper.map((Object)((Object)cooperateEntity), CooperateVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"getShareLink"})
    public CommonResponse<JSONObject> getShareLink(@RequestParam(value="billId") Long billId, @RequestParam(value="billTypeCode") String billTypeCode, @RequestParam(value="supplierId") String supplierId, @RequestParam(value="h5FrontUrl") String h5FrontUrl, @RequestParam(value="wxFrontUrl", required=false) String wxFrontUrl) {
        return this.billShareHelper.getBillShareLink(billId, billTypeCode, supplierId, h5FrontUrl, wxFrontUrl);
    }
}

